/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NullChecking {
    public static <T, U> @Nullable U applyIfNonNull(@Nullable T value, @NonNull Function<@NonNull T, U> function) {
        if (value == null) {
            return null;
        }
        return function.apply(value);
    }

    public static <T, U> U applyIfNonNullOrCreateDefault(@Nullable T value, @NonNull Function<@NonNull T, U> function, @NonNull Supplier<U> defaultSupplier) {
        if (value == null) {
            return defaultSupplier.get();
        }
        return function.apply(value);
    }

    public static <T, U, E extends Throwable> U applyIfNonNullOrCreateDefaultThrows(@Nullable T value, @NonNull IThrowingFunction<@NonNull T, U, E> function, @NonNull IThrowingSupplier<U, E> defaultSupplier) throws E {
        if (value == null) {
            return defaultSupplier.get();
        }
        return function.apply(value);
    }

    public static <T, U> U applyIfNonNullOrDefault(@Nullable T value, U defaultValue, @NonNull Function<@NonNull T, U> function) {
        if (value == null) {
            return defaultValue;
        }
        return function.apply(value);
    }

    public static <T, U, E extends Throwable> U applyIfNonNullOrDefaultThrows(@Nullable T value, U defaultValue, @NonNull IThrowingFunction<@NonNull T, U, E> function) throws E {
        if (value == null) {
            return defaultValue;
        }
        return function.apply(value);
    }

    public static <T, U, E extends Throwable> @Nullable U applyIfNonNullThrows(@Nullable T value, @NonNull IThrowingFunction<@NonNull T, U, E> function) throws E {
        if (value == null) {
            return null;
        }
        return function.apply(value);
    }

    public static <T extends Comparable<? super T>> int compareToNullable(@Nullable T a, @Nullable T b, boolean nullsFirst) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null && b != null) {
            return nullsFirst ? -1 : 1;
        }
        if (a != null && b == null) {
            return nullsFirst ? 1 : -1;
        }
        return 0;
    }

    public static <T> void consumeIfNonNull(@Nullable T value, @NonNull Consumer<? super @NonNull T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T> boolean equalsNeverNull(@Nullable T a, @Nullable T b) {
        if (a == null || b == null) {
            throw new NullPointerException();
        }
        return a.equals(b);
    }

    public static <T> boolean equalsNullable(@Nullable T a, @Nullable T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsNullableArray(boolean @Nullable [] a, boolean @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    public static boolean equalsNullableArray(byte @Nullable [] a, byte @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    public static boolean equalsNullableArray(int @Nullable [] a, int @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    public static boolean equalsNullableArray(long @Nullable [] a, long @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    public static boolean equalsNullableArray(short @Nullable [] a, short @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    public static <T> boolean equalsNullableArray(T @Nullable [] a, T @Nullable [] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    @SafeVarargs
    public static <T> @Nullable T firstNonNull(T ... values) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            @Nullable T value = TArray[n2];
            if (value != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static <T> int hashNullable(@Nullable T a) {
        return a != null ? a.hashCode() : 0;
    }

    public static boolean isNotNull(@Nullable Object o) {
        return o != null;
    }

    public static <T> @NonNull T neverNull(@Nullable T t) throws NullPointerException {
        if (t != null) {
            return t;
        }
        throw new NullPointerException();
    }

    public static <T> T @NonNull [] neverNull(T @Nullable [] t) throws NullPointerException {
        if (t != null) {
            return t;
        }
        throw new NullPointerException();
    }

    public static boolean neverNullOr(@Nullable Boolean t, boolean d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static byte neverNullOr(@Nullable Byte t, byte d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static int neverNullOr(@Nullable Integer t, int d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static long neverNullOr(@Nullable Long t, long d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static short neverNullOr(@Nullable Short t, short d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static <T> @NonNull T neverNullOr(@Nullable T t, @NonNull T d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static <T> @Nullable T neverNullOrNullable(@Nullable T t, @Nullable T d) {
        if (t != null) {
            return t;
        }
        return d;
    }

    public static <T> @NonNull T neverNullOrCreate(@Nullable T t, @NonNull Supplier<? extends @NonNull T> defaultSupplier) {
        if (t != null) {
            return t;
        }
        return defaultSupplier.get();
    }

    public static <T, E extends Throwable> @NonNull T neverNullOrThrow(@Nullable T t, @NonNull Supplier<@NonNull E> exceptionSupplier) throws E {
        if (t != null) {
            return t;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public static <T> @NonNull T @NonNull [] nonNullElementsUnchecked(T @NonNull [] t) {
        return t;
    }

    public static <T> @Nullable T nullable(@NonNull T t) {
        return t;
    }

    public static <T> @Nullable T @NonNull [] nullableContents(@NonNull T @NonNull [] array) {
        return array;
    }

    public static @Nullable Integer nullIfEqual(int value, int nullValue) {
        if (value == nullValue) {
            return null;
        }
        return value;
    }

    public static @Nullable String nullIfBlank(@Nullable String str) {
        return str != null && !str.isBlank() ? str : null;
    }

    public static <T, E extends Throwable> @Nullable T nullIfThrows(@NonNull IThrowingSupplier<T, E> supplier, Class<? extends E> exceptionType) throws E {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            if (exceptionType.isInstance(t)) {
                return null;
            }
            throw t;
        }
    }

    public static <T> @Nullable T nullXor(@Nullable T a, @Nullable T b) {
        if (a != null) {
            if (b == null) {
                return a;
            }
            return null;
        }
        return b;
    }
}

