/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.topology;

import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CoresFile
implements ICores {
    public static final @NonNull String UNKNOWN = "Unknown";
    private final @NonNull List<@NonNull String> mCoreNames = new ArrayList<String>();
    private final @NonNull List<@NonNull ProcessingElementReference> mProcessingElementReference = new ArrayList<ProcessingElementReference>();
    private final @NonNull List<@Nullable ProcessingElementTopology> mProcessingElementTopology = new ArrayList<ProcessingElementTopology>();
    private final @NonNull List<@NonNull String> mUniqueClusterNames = new ArrayList<String>();
    private final int @NonNull [] mCpuIDs;
    private final int @NonNull [] mRelativeCoreIDs;

    public CoresFile(@NonNull List<@NonNull String> coreNames, @NonNull List<@NonNull String> uniqueClusterNames, @NonNull List<@NonNull ProcessingElementReference> processingElementReference, @NonNull List<@Nullable ProcessingElementTopology> processingElementTopology, int @NonNull [] cpuIDs, int @NonNull [] relativeCoreIDs) {
        assert (coreNames.size() == processingElementReference.size());
        assert (coreNames.size() == processingElementTopology.size());
        assert (coreNames.size() == cpuIDs.length);
        assert (coreNames.size() == relativeCoreIDs.length);
        this.mCoreNames.addAll(coreNames);
        this.mUniqueClusterNames.addAll(uniqueClusterNames);
        this.mProcessingElementReference.addAll(processingElementReference);
        this.mProcessingElementTopology.addAll(processingElementTopology);
        this.mCpuIDs = cpuIDs;
        this.mRelativeCoreIDs = relativeCoreIDs;
    }

    public @Nullable Integer getClusterIndex(int core, @NonNull IClustersInfo clusterInfo) {
        return clusterInfo.findClusterIndex(this.getCoreClusterLabel(core));
    }

    public @NonNull String getCoreClusterLabel(int coreID) {
        return this.mCoreNames.get(coreID);
    }

    public int getCoreIndex(@NonNull ProcessingElementReference peReference) {
        return this.mProcessingElementReference.indexOf(peReference);
    }

    public @NonNull TIntArrayList getCores(int clusterID, @NonNull IClustersInfo clusterInfo) {
        @Nullable String clusterName = (String)clusterInfo.getClusterNames().get(clusterID);
        @NonNull TIntArrayList cores = new TIntArrayList();
        if (clusterName != null) {
            int length = this.mCoreNames.size();
            int i = 0;
            while (i < length) {
                @NonNull String name = this.mCoreNames.get(i);
                if (name.contentEquals(clusterName)) {
                    cores.add(i);
                }
                ++i;
            }
        }
        return cores;
    }

    public int getNumCores() {
        return this.mCoreNames.size();
    }

    public @NonNull ProcessingElementReference getProcessingElementReference(int coreID) {
        return this.mProcessingElementReference.get(coreID);
    }

    public @NonNull ProcessingElementReference @NonNull [] getProcessingElementReferences() {
        return this.mProcessingElementReference.toArray(new ProcessingElementReference[this.mProcessingElementReference.size()]);
    }

    public @Nullable ProcessingElementTopology getProcessingElementTopology(int coreID) {
        return this.mProcessingElementTopology.get(coreID);
    }

    public int getCpuID(int coreID) {
        return this.mCpuIDs[coreID];
    }

    public int getRelativeCoreId(int coreID) {
        return this.mRelativeCoreIDs[coreID];
    }
}

