/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.topology;

import com.arm.streamline.analysis.model.topology.CoresFile;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClusterInformationRewriter {
    public static @NonNull Pair<@NonNull List<@NonNull ProcessingElementReference>, @NonNull XmlClustersInfo> write(@NonNull OutputStream varReplacerStream, @NonNull List<@NonNull CounterRecord> counterList, boolean alwaysSupportMultipleClusterRewrite, @NonNull IClustersInfo clustersInfo_, @NonNull ProcessingElementReferenceSet processingElements, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties) throws IOException {
        @NonNull ArrayList<@NonNull ProcessingElementReference> cpuProcessingElementReferences = new ArrayList<ProcessingElementReference>(processingElements.getList(DeviceType.CPU));
        Collections.sort(cpuProcessingElementReferences);
        boolean allowMultipleClusters = alwaysSupportMultipleClusterRewrite || clustersInfo_.hasClusters() || !clustersInfo_.isGatorClusterInformationMissing();
        boolean forceClusters = counterList.stream().anyMatch(cr -> cr.getCluster() != null);
        @NonNull XmlClustersInfo mappedClusterInfo = ClusterInformationRewriter.createClusterInformation(true, alwaysSupportMultipleClusterRewrite, clustersInfo_, processingElementProperties, cpuProcessingElementReferences);
        VariableReplacer variableReplacer = new VariableReplacer();
        if (allowMultipleClusters || forceClusters) {
            variableReplacer.createClusterVariables((IClustersInfo)mappedClusterInfo);
            mappedClusterInfo.updateCounterRecordsWithClusterInformation(forceClusters, counterList);
        } else {
            counterList.forEach(cr -> cr.setCluster(null));
        }
        variableReplacer.writeXML(varReplacerStream);
        return new Pair(cpuProcessingElementReferences, (Object)mappedClusterInfo);
    }

    private static @NonNull XmlClustersInfo createClusterInformation(boolean allowMultipleClusters, boolean alwaysRewrite, @NonNull IClustersInfo clustersInfo, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull List<@NonNull ProcessingElementReference> coreOrder) {
        int clusterId;
        Object label;
        assert (coreOrder.size() >= processingElementProperties.size() && coreOrder.containsAll(processingElementProperties.keySet()));
        @NonNull HashSet<@NonNull String> possibleKnownDisplayNameForOther = new HashSet<String>();
        @NonNull TObjectIntHashMap labelToClusterMap = new TObjectIntHashMap(10, 0.5f, -1);
        @NonNull TIntObjectHashMap clusterToDisplayLabelMap = new TIntObjectHashMap(10, 0.5f, -1);
        @NonNull TIntIntHashMap coreIndexToClusterMap = new TIntIntHashMap(10, 0.5f, -1, -1);
        @NonNull ArrayList<@NonNull String> coreIndexNames = new ArrayList<String>();
        @NonNull ArrayList<@NonNull String> uniqueClusterNames = new ArrayList<String>();
        @NonNull ArrayList<@Nullable ProcessingElementTopology> topology = new ArrayList<ProcessingElementTopology>();
        @NonNull TIntArrayList cpuIds = new TIntArrayList();
        int clusterIdCounter = 0;
        @NonNull TIntObjectMap existingClusters = clustersInfo.getClusterNames();
        if (!alwaysRewrite) {
            boolean hasOther = false;
            int[] existingClusterIds = existingClusters.keys();
            Arrays.sort(existingClusterIds);
            int[] nArray = existingClusterIds;
            int n = existingClusterIds.length;
            int n2 = 0;
            while (n2 < n) {
                int clusterId2 = nArray[n2];
                label = (String)NullChecking.neverNull((Object)((String)existingClusters.get(clusterId2)));
                hasOther |= ((String)label).contentEquals("Other");
                if (!(!((String)label).contentEquals("Other") && ((String)label).startsWith("Unknown") || labelToClusterMap.containsKey(label))) {
                    assert (!clusterToDisplayLabelMap.containsKey(clusterId2));
                    labelToClusterMap.put(label, clusterId2);
                    clusterToDisplayLabelMap.put(clusterId2, label);
                    clusterIdCounter = Math.max(clusterIdCounter, clusterId2 + 1);
                    assert (uniqueClusterNames.size() == clusterId2);
                    uniqueClusterNames.add((String)label);
                }
                ++n2;
            }
            if (hasOther && labelToClusterMap.size() == 1) {
                labelToClusterMap.clear();
                clusterToDisplayLabelMap.clear();
                uniqueClusterNames.clear();
                clusterIdCounter = 0;
            }
        }
        assert (clusterIdCounter == clusterToDisplayLabelMap.size());
        int originalMaxClusterIdCount = clusterIdCounter;
        int coreIndex = 0;
        while (coreIndex < coreOrder.size()) {
            @NonNull ProcessingElementReference core = coreOrder.get(coreIndex);
            @Nullable ProcessingElementDescriptor record = processingElementProperties.get(core);
            if (record != null) {
                clusterIdCounter = ClusterInformationRewriter.extendClusterInformation(possibleKnownDisplayNameForOther, (TObjectIntMap<String>)labelToClusterMap, (TIntObjectMap<String>)clusterToDisplayLabelMap, (TIntIntMap)coreIndexToClusterMap, uniqueClusterNames, topology, (TIntList)cpuIds, clusterIdCounter, coreIndex, record);
            } else {
                int nearestMatchingCoreIndex = ClusterInformationRewriter.findNearestPreceedingCoreRecord(processingElementProperties, coreOrder, coreIndex);
                if (nearestMatchingCoreIndex >= 0) {
                    @NonNull ProcessingElementReference nearestMatchingCore = coreOrder.get(nearestMatchingCoreIndex);
                    @NonNull ProcessingElementDescriptor nearestMatch = (ProcessingElementDescriptor)NullChecking.neverNull((Object)processingElementProperties.get(nearestMatchingCore));
                    fakeRecord = new ProcessingElementDescriptor(nearestMatch.getCpuid(), Integer.MAX_VALUE, nearestMatch.getLabel(), null);
                    processingElementProperties.put(core, fakeRecord);
                    clusterIdCounter = ClusterInformationRewriter.extendClusterInformation(possibleKnownDisplayNameForOther, (TObjectIntMap<String>)labelToClusterMap, (TIntObjectMap<String>)clusterToDisplayLabelMap, (TIntIntMap)coreIndexToClusterMap, uniqueClusterNames, topology, (TIntList)cpuIds, clusterIdCounter, coreIndex, fakeRecord);
                } else {
                    Integer existingClusterId;
                    Integer n = existingClusterId = core.vmUID == 0L ? clustersInfo.findClusterIndex(core.deviceNumber) : null;
                    assert (existingClusterId != null || clusterToDisplayLabelMap.size() != 1 || clusterToDisplayLabelMap.containsKey(0));
                    label = existingClusterId != null ? (String)NullChecking.neverNull((Object)((String)existingClusters.get(existingClusterId.intValue()))) : (clusterToDisplayLabelMap.size() == 1 ? (String)NullChecking.neverNull((Object)((String)clusterToDisplayLabelMap.get(0))) : "Unknown");
                    fakeRecord = new ProcessingElementDescriptor(-1, Integer.MAX_VALUE, (String)label, null);
                    processingElementProperties.put(core, fakeRecord);
                    clusterIdCounter = ClusterInformationRewriter.extendClusterInformation(possibleKnownDisplayNameForOther, (TObjectIntMap<String>)labelToClusterMap, (TIntObjectMap<String>)clusterToDisplayLabelMap, (TIntIntMap)coreIndexToClusterMap, uniqueClusterNames, topology, (TIntList)cpuIds, clusterIdCounter, coreIndex, fakeRecord);
                }
            }
            ++coreIndex;
        }
        boolean anyAreNew = false;
        boolean allAreNew = true;
        int coreIndex2 = 0;
        while (coreIndex2 < coreOrder.size()) {
            clusterId = coreIndexToClusterMap.get(coreIndex2);
            anyAreNew |= clusterId >= originalMaxClusterIdCount;
            allAreNew &= clusterId >= originalMaxClusterIdCount;
            ++coreIndex2;
        }
        if (anyAreNew && allAreNew) {
            @NonNull TIntObjectHashMap newMap = new TIntObjectHashMap(10, 0.5f, -1);
            clusterToDisplayLabelMap.forEachEntry((arg_0, arg_1) -> ClusterInformationRewriter.lambda$2(originalMaxClusterIdCount, (TIntObjectMap)newMap, arg_0, arg_1));
            clusterToDisplayLabelMap.clear();
            clusterToDisplayLabelMap.putAll((TIntObjectMap)newMap);
            labelToClusterMap.retainEntries((k, v) -> v >= originalMaxClusterIdCount);
            labelToClusterMap.transformValues(v -> v - originalMaxClusterIdCount);
            coreIndexToClusterMap.transformValues(v -> v - originalMaxClusterIdCount);
            uniqueClusterNames.subList(0, originalMaxClusterIdCount).clear();
            clusterIdCounter -= originalMaxClusterIdCount;
        }
        TreeSet<@NonNull String> setOfNonUnknownClusterLabels = new TreeSet<String>();
        TIntHashSet cpuIdsForNonUnknownClusterLabels = new TIntHashSet();
        coreIndex = 0;
        while (coreIndex < coreOrder.size()) {
            clusterId = coreIndexToClusterMap.get(coreIndex);
            for (String clusterLabel : labelToClusterMap.keySet()) {
                if (labelToClusterMap.get((Object)clusterLabel) != clusterId) continue;
                int cpuId = cpuIds.get(coreIndex);
                coreIndexNames.add(clusterLabel);
                if ("Unknown".equals(clusterLabel)) continue;
                setOfNonUnknownClusterLabels.add(clusterLabel);
                cpuIdsForNonUnknownClusterLabels.add(cpuId);
                break;
            }
            ++coreIndex;
        }
        if (!allowMultipleClusters || setOfNonUnknownClusterLabels.size() == 1) {
            @NonNull String clusterName = setOfNonUnknownClusterLabels.isEmpty() ? "Unknown" : setOfNonUnknownClusterLabels.stream().map(name -> name.equals("Other") || name.equals("Perf_Hardware") ? "Unknown" : name).distinct().collect(Collectors.joining("/"));
            int[] cpuIdsAsArray = cpuIdsForNonUnknownClusterLabels.toArray();
            int cpuId = cpuIdsAsArray.length != 1 ? 1048575 : cpuIdsAsArray[0];
            clusterToDisplayLabelMap.clear();
            clusterToDisplayLabelMap.put(0, (Object)clusterName);
            TIntIntIterator it = coreIndexToClusterMap.iterator();
            while (it.hasNext()) {
                it.advance();
                it.setValue(0);
            }
            Collections.fill(coreIndexNames, clusterName);
            cpuIds.fill(cpuId);
            uniqueClusterNames.clear();
            uniqueClusterNames.add(clusterName);
        }
        if (possibleKnownDisplayNameForOther.size() == 1) {
            int otherClusterId = labelToClusterMap.get((Object)"Other");
            assert (otherClusterId != labelToClusterMap.getNoEntryValue());
            String[] names = (String[])possibleKnownDisplayNameForOther.toArray(String[]::new);
            assert (names.length == 1);
            clusterToDisplayLabelMap.put(otherClusterId, (Object)names[0]);
        }
        int[] relativeCoreIds = (int[])NullChecking.neverNull((Object)cpuIds.toArray());
        int i = 0;
        while (i < relativeCoreIds.length) {
            relativeCoreIds[i] = Integer.MAX_VALUE;
            ++i;
        }
        return new XmlClustersInfo(new GatorClusters((TIntObjectMap)clusterToDisplayLabelMap, (TIntIntMap)coreIndexToClusterMap), (ICores)new CoresFile(coreIndexNames, uniqueClusterNames, coreOrder, topology, (int[])NullChecking.neverNull((Object)cpuIds.toArray()), relativeCoreIds));
    }

    private static int extendClusterInformation(@NonNull Set<@NonNull String> possibleKnownDisplayNameForOther, @NonNull TObjectIntMap<String> labelToClusterMap, @NonNull TIntObjectMap<String> clusterToDisplayLabelMap, @NonNull TIntIntMap coreIndexToClusterMap, @NonNull List<@NonNull String> uniqueClusterNames, @NonNull List<@Nullable ProcessingElementTopology> topology, @NonNull TIntList cpuIds, int clusterIdCounter, int coreIndex, @NonNull ProcessingElementDescriptor record) {
        String displayLabel;
        String keylabel;
        boolean isPerfHardware;
        @NonNull String rawLabel = record.getLabel();
        @Nullable String archLabel = ClusterNameUtils.getArchName((String)rawLabel);
        int cpuid = record.getCpuid() & 0xFFFFF;
        @Nullable ProcessorPmu pmuById = EventsAndPmusXml.getPmuByCPUID((int)cpuid);
        @Nullable ProcessorPmu pmu = pmuById != null ? pmuById : EventsAndPmusXml.getPmuByName((String)(archLabel != null ? archLabel : rawLabel));
        boolean isUnknownCpuId = cpuid == 1048575;
        boolean isUnknownName = rawLabel.startsWith("Unknown");
        boolean isOther = rawLabel.equals("Other");
        boolean bl = isPerfHardware = rawLabel.equals("Perf_Hardware") || pmu != null && pmu.getId().contentEquals("Perf_Hardware");
        if (isPerfHardware) {
            keylabel = rawLabel;
            displayLabel = "Unknown";
        } else if (isUnknownCpuId) {
            keylabel = "Unknown";
            displayLabel = "Unknown";
        } else if (isUnknownName || isOther) {
            keylabel = "Other";
            displayLabel = "Unknown";
            if (pmu != null) {
                possibleKnownDisplayNameForOther.add(pmu.getCoreName());
            } else {
                possibleKnownDisplayNameForOther.add(displayLabel);
            }
        } else if (pmu != null && labelToClusterMap.containsKey((Object)pmu.getId())) {
            keylabel = pmu.getId();
            displayLabel = pmu.getCoreName();
        } else if (pmu != null && labelToClusterMap.containsKey((Object)pmu.getCoreName())) {
            keylabel = displayLabel = pmu.getCoreName();
        } else if (archLabel != null && labelToClusterMap.containsKey((Object)archLabel)) {
            keylabel = archLabel;
            displayLabel = pmu != null ? pmu.getCoreName() : archLabel;
        } else if (labelToClusterMap.containsKey((Object)rawLabel)) {
            keylabel = rawLabel;
            displayLabel = pmu != null ? pmu.getCoreName() : rawLabel;
        } else {
            keylabel = pmu != null ? (displayLabel = pmu.getCoreName()) : (archLabel != null ? (displayLabel = archLabel) : (displayLabel = rawLabel));
        }
        return ClusterInformationRewriter.insertOrUpdateClusterDetails(labelToClusterMap, clusterToDisplayLabelMap, coreIndexToClusterMap, uniqueClusterNames, topology, cpuIds, clusterIdCounter, coreIndex, record, keylabel, displayLabel, cpuid);
    }

    private static int findNearestPreceedingCoreRecord(@NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull List<@NonNull ProcessingElementReference> coreOrder, int currentIndex) {
        ProcessingElementDescriptor record;
        ProcessingElementReference core;
        @NonNull ProcessingElementReference currentCore = coreOrder.get(currentIndex);
        int i = currentIndex - 1;
        while (i >= 0) {
            core = coreOrder.get(i);
            record = processingElementProperties.get(core);
            if (record != null && core.vmUID == currentCore.vmUID) {
                return i;
            }
            --i;
        }
        i = currentIndex + 1;
        while (i < coreOrder.size()) {
            core = coreOrder.get(i);
            record = processingElementProperties.get(core);
            if (record != null && core.vmUID == currentCore.vmUID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int insertOrUpdateClusterDetails(@NonNull TObjectIntMap<String> labelToClusterMap, @NonNull TIntObjectMap<String> clusterToDisplayLabelMap, @NonNull TIntIntMap coreIndexToClusterMap, @NonNull List<@NonNull String> uniqueClusterNames, @NonNull List<@Nullable ProcessingElementTopology> topology, @NonNull TIntList cpuIds, int clusterIdCounter, int coreIndex, @NonNull ProcessingElementDescriptor record, @NonNull String keyLabel, @NonNull String displayLabel, int cpuid) {
        if (labelToClusterMap.containsKey((Object)keyLabel)) {
            return ClusterInformationRewriter.updatedExistingCluster(labelToClusterMap, clusterToDisplayLabelMap, coreIndexToClusterMap, topology, cpuIds, clusterIdCounter, coreIndex, record, cpuid, keyLabel, displayLabel);
        }
        int clusterId = clusterIdCounter++;
        labelToClusterMap.put((Object)keyLabel, clusterId);
        assert (uniqueClusterNames.size() == clusterId);
        uniqueClusterNames.add(keyLabel);
        return ClusterInformationRewriter.setClusterDetails(coreIndexToClusterMap, clusterToDisplayLabelMap, topology, cpuIds, clusterIdCounter, coreIndex, record, cpuid, clusterId, displayLabel);
    }

    private static int setClusterDetails(@NonNull TIntIntMap coreIndexToClusterMap, @NonNull TIntObjectMap<String> clusterToDisplayLabelMap, @NonNull List<@Nullable ProcessingElementTopology> topology, @NonNull TIntList cpuIds, int clusterIdCounter, int coreIndex, @NonNull ProcessingElementDescriptor record, int cpuid, int clusterId, @NonNull String displayLabel) {
        clusterToDisplayLabelMap.put(clusterId, (Object)displayLabel);
        coreIndexToClusterMap.put(coreIndex, clusterId);
        cpuIds.add(cpuid);
        topology.add(record.getTopology());
        return clusterIdCounter;
    }

    private static int updatedExistingCluster(@NonNull TObjectIntMap<String> labelToClusterMap, @NonNull TIntObjectMap<String> clusterToLabelMap, @NonNull TIntIntMap coreIndexToClusterMap, @NonNull List<@Nullable ProcessingElementTopology> topology, @NonNull TIntList cpuIds, int clusterIdCounter, int coreIndex, @NonNull ProcessingElementDescriptor record, int cpuid, @NonNull String keyLabel, @NonNull String displayLabel) {
        assert (labelToClusterMap.containsKey((Object)keyLabel));
        int clusterId = labelToClusterMap.get((Object)keyLabel);
        return ClusterInformationRewriter.setClusterDetails(coreIndexToClusterMap, clusterToLabelMap, topology, cpuIds, clusterIdCounter, coreIndex, record, cpuid, clusterId, displayLabel);
    }

    private static /* synthetic */ boolean lambda$2(int n, TIntObjectMap tIntObjectMap, int k, String v) {
        if (k >= n) {
            tIntObjectMap.put(k - n, (Object)v);
        }
        return true;
    }
}

