/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.processing.idle.AnalysisCounterIdleStateModificationDetector;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.Ternary;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StaticCounterSeriesKey
implements ICounterSeriesKey {
    private final @NonNull CounterRecord counterRecord;
    private final int mapActivityCount;
    private final boolean mapCounterToActivity;

    public StaticCounterSeriesKey(@NonNull CounterRecord counterRecord) {
        this.counterRecord = counterRecord;
        List activities = counterRecord.getActivity();
        this.mapCounterToActivity = counterRecord.getCounterClass() == CounterClass.ACTIVITY;
        this.mapActivityCount = this.mapCounterToActivity ? activities.size() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StaticCounterSeriesKey) {
            StaticCounterSeriesKey that = (StaticCounterSeriesKey)obj;
            return this.counterRecord.equals((Object)that.counterRecord);
        }
        return false;
    }

    @Override
    public @Nullable String getArbitraryBacktraceSourceName() {
        return String.format("%s: %s", this.counterRecord.getTitle(), this.counterRecord.getName());
    }

    @Override
    public @Nullable String getBacktraceSourceNameIfEbsCounter() {
        if (this.counterRecord.getEventCount() <= 0) {
            return null;
        }
        return this.getArbitraryBacktraceSourceName();
    }

    public @NonNull CounterRecord getCounterRecord() {
        return this.counterRecord;
    }

    @Override
    public @NonNull DeviceType getDeviceTypeOrDefault() {
        return this.counterRecord.getDeviceTypeOrDefault();
    }

    public int getKey() {
        return this.counterRecord.getKey();
    }

    @Override
    public @NonNull Integer getKeyIfHas() {
        return this.counterRecord.getKey();
    }

    @Override
    public int getMappedActivityCount() {
        return this.mapActivityCount;
    }

    @Override
    public @Nullable String getTracepointArg() {
        return this.counterRecord.getArg();
    }

    public int hashCode() {
        return this.counterRecord.hashCode();
    }

    @Override
    public boolean isCpuPmuCounter() {
        return AnalysisCounterIdleStateModificationDetector.isCpuPmuCounter(this.counterRecord);
    }

    @Override
    public boolean isDeltaCounter() {
        return this.counterRecord.getCounterClass() == CounterClass.DELTA;
    }

    @Override
    public boolean isMapCounterToActivity() {
        return this.mapCounterToActivity;
    }

    @Override
    public boolean isSourceFilterable() {
        return this.isThreadCounter() || this.isCpuPmuCounter() || this.counterRecord.isSourceFilterable();
    }

    @Override
    public boolean isStaticCounter() {
        return true;
    }

    @Override
    public boolean isThreadCounter() {
        return this.counterRecord.isProc() == Ternary.TRUE;
    }

    public String toString() {
        return this.counterRecord.getKey() + ": " + this.counterRecord.getAlias();
    }
}

