/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.types;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import org.eclipse.jdt.annotation.NonNull;

public class IndexTimestampSeqno
implements Comparable<IndexTimestampSeqno> {
    public final long sequenceNo;
    public final long timestamp;

    public static @NonNull IndexTimestampSeqno add(@NonNull IndexTimestampSeqno a, @NonNull IndexTimestampSeqno b) {
        return new IndexTimestampSeqno(a.timestamp + b.timestamp, a.sequenceNo + b.sequenceNo);
    }

    public static @NonNull IndexTimestampSeqno subtract(@NonNull IndexTimestampSeqno a, @NonNull IndexTimestampSeqno b) {
        return new IndexTimestampSeqno(a.timestamp - b.timestamp, a.sequenceNo - b.sequenceNo);
    }

    public static @NonNull IndexTimestampSeqno unpackOne(@NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        long timestamp = unpacker.unpackOneLong();
        long sequenceNo = unpacker.unpackOneLong();
        return new IndexTimestampSeqno(timestamp, sequenceNo);
    }

    public IndexTimestampSeqno(long timestamp, long sequenceNo) {
        this.timestamp = timestamp;
        this.sequenceNo = sequenceNo;
    }

    @Override
    public int compareTo(IndexTimestampSeqno o) {
        if (this.timestamp < o.timestamp) {
            return -1;
        }
        if (this.timestamp > o.timestamp) {
            return 1;
        }
        if (this.sequenceNo < o.sequenceNo) {
            return -1;
        }
        if (this.sequenceNo > o.sequenceNo) {
            return 1;
        }
        return 0;
    }

    public boolean isGreaterThan(IndexTimestampSeqno o) {
        return this.compareTo(o) > 0;
    }

    public boolean isLessThan(IndexTimestampSeqno o) {
        return this.compareTo(o) < 0;
    }

    public boolean isLessThanEqualTo(IndexTimestampSeqno o) {
        return !this.isGreaterThan(o);
    }

    public String toString() {
        long absTimestamp = Math.abs(this.timestamp);
        long seconds = absTimestamp / 1000000000L;
        long nanoSeconds = absTimestamp % 1000000000L;
        String timestampFmtd = (this.timestamp < 0L ? "-" : "") + seconds + "." + String.format("%09d", nanoSeconds);
        return "{timestamp=" + timestampFmtd + ", sequenceNo=" + this.sequenceNo + "}";
    }
}

