/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.ContextSwitchReason;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SchedulerStreamParser
implements IStreamParser<StreamValue> {
    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) {
        byte rtype = unpacker.takeOneByte();
        switch (rtype) {
            case 0: {
                int deviceNo = unpacker.unpackOneInt();
                long utid = unpacker.unpackOneLong();
                int reason = unpacker.unpackOneInt();
                return new StreamValue(index, EventKind.CONTEXT_SWITCH, utid, deviceNo, ContextSwitchReason.fromInt(reason));
            }
            case 1: {
                long utid = unpacker.unpackOneLong();
                return new StreamValue(index, EventKind.THREAD_EXIT, utid, 0, ContextSwitchReason.scheduled);
            }
        }
        throw new AssertionError((Object)"Unexpected rtype");
    }

    public static enum EventKind {
        CONTEXT_SWITCH,
        THREAD_EXIT;

    }

    public static final class StreamValue
    implements IPrintable {
        public final @NonNull IndexTimestampSeqno index;
        public final @NonNull EventKind type;
        public final @Nullable Integer utid;
        public final int deviceNo;
        public final @NonNull ContextSwitchReason reason;

        public StreamValue(@NonNull IndexTimestampSeqno index, @NonNull EventKind type, long utid, int deviceNo, @NonNull ContextSwitchReason reason) {
            this.index = index;
            this.type = type;
            this.utid = DbConstants.toUtid(utid);
            this.deviceNo = deviceNo;
            this.reason = reason;
        }

        @Override
        public void printToStream(@NonNull Appendable a) throws IOException {
            switch (this.type) {
                case CONTEXT_SWITCH: {
                    a.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: context_switch :: " + String.valueOf((Object)this.reason));
                    break;
                }
                case THREAD_EXIT: {
                    a.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$4s", this.utid) + " :: thread_exit");
                    break;
                }
                default: {
                    a.append("        " + String.valueOf(this.index) + " :: invalid type");
                }
            }
            a.append(System.lineSeparator());
        }
    }
}

