/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.metadata;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.io.ByteBufferFiller;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.io.MMappedFileDataView;
import com.arm.streamline.analysis.dbnative.metadata.IMetadata;
import com.arm.streamline.analysis.dbnative.metadata.MetadataEntryType;
import com.arm.streamline.analysis.dbnative.metadata.MetadataMappingEntry;
import com.arm.streamline.analysis.dbnative.root.DBRootTypeKey;
import com.arm.streamline.analysis.dbnative.types.IndexId;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.dbnative.types.StreamMetadataBlobEntry;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Metadata
implements IMetadata {
    private static final long EXPECTED_ALIGNMENT = 1L;
    private static final int HEADER_SIZE = 24;
    private static final int MAX_SIZE_OF_PACKED_LONG = 10;
    private static final int MAX_SIZE_OF_ID_MAPPING = 40;
    private static final int MAX_SIZE_OF_L0_ENTRY = 60;
    private static final int MAX_SIZE_OF_METADATA_BLOB_ENTRY = 30;
    private static final int MAX_SIZE_OF_METADATA_ENTRY = 10 + Math.max(Math.max(40, 60), 30);
    private static final int TMP_BUFFER_CAPACITY = 65536;
    private static final long METADATA_MAGIC_FROM_BIG_ENDIAN = 3544453245085901380L;
    private static final long METADATA_MAGIC_FROM_LITTLE_ENDIAN = 4927592701897814065L;
    private final @NonNull Map<@NonNull IndexId, @NonNull List<@NonNull L0IndexEntry>> l0Index;
    private final @NonNull Map<@NonNull IndexId, Map<@NonNull Long, @NonNull IndexId>> parentIdToChildKeyToDirectoryId;
    private final @NonNull Map<@NonNull IndexId, Map<@NonNull Long, @NonNull IndexId>> parentIdToChildKeyToStreamId;
    private final @NonNull Map<@NonNull IndexId, @NonNull List<@NonNull StreamMetadataBlobEntry>> streamMetadataBlobs;
    private @NonNull ByteOrder targetEndianness = ByteOrder.LITTLE_ENDIAN;

    public static @NonNull Metadata readFrom(@NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MMappedFileDataView viewIndex = new MMappedFileDataView(file);){
            return Metadata.readMetadataFile(viewIndex);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static @NonNull Metadata readMetadataFile(@NonNull IFileDataView viewMetadata) throws IOException {
        ByteOrder byteOrder = Metadata.validateMetadataHeader(viewMetadata);
        if (byteOrder == null) {
            throw new IOException("Profile database is corrupt and cannot be opened.");
        }
        @NonNull Metadata result = new Metadata();
        result.targetEndianness = byteOrder;
        HashSet<IndexId> directoryIds = new HashSet<IndexId>();
        HashSet<IndexId> streamIds = new HashSet<IndexId>();
        long remainingBytes = viewMetadata.fileSize() - 24L;
        if (remainingBytes > 0L) {
            ByteBuffer buffer = viewMetadata.getChunk(24L, Math.min(65536L, remainingBytes));
            ByteBufferFiller filler = new ByteBufferFiller(buffer, buffer.remaining() + 24, viewMetadata);
            PackedValueUnpacker unpacker = new PackedValueUnpacker(buffer);
            try {
                while (filler.tryEnsure(MAX_SIZE_OF_METADATA_ENTRY) > 0) {
                    @NonNull MetadataEntryType type = MetadataEntryType.fromLong(unpacker.unpackOneLong());
                    switch (type) {
                        case PADDING: {
                            break;
                        }
                        case ID_MAPPING: {
                            Metadata.readIdMapping(unpacker, result, directoryIds, streamIds);
                            break;
                        }
                        case L0_INDEX: {
                            Metadata.readL0Index(unpacker, result);
                            break;
                        }
                        case STREAM_METADATA_BLOB: {
                            Metadata.readStreamMetadataBlob(unpacker, result);
                            break;
                        }
                        default: {
                            throw new IOException("Invalid entry type found in metadata");
                        }
                    }
                }
            }
            catch (BufferUnderflowException e) {
                throw new IOException(e);
            }
        }
        Metadata.assertContainsValidMetadata(result, directoryIds, streamIds);
        return result;
    }

    public static @Nullable ByteOrder validateMetadataHeader(@NonNull IFileDataView viewMetadata) throws IOException {
        boolean versionMatch;
        ByteOrder byteOrder;
        if (viewMetadata.fileSize() < 24L) {
            return null;
        }
        ByteBuffer headerBytes = viewMetadata.getChunk(0L, 24L);
        long magic = headerBytes.getLong(0);
        if (magic == 4927592701897814065L) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (magic == 3544453245085901380L) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return null;
        }
        int version = headerBytes.getInt(8);
        boolean devBuild = headerBytes.get(12) != 0;
        byte alignment = headerBytes.get(13);
        byte sizeOfSizeT = headerBytes.get(14);
        byte sizeOfDbFileOffsetT = headerBytes.get(15);
        byte sizeOfDbFileSizeT = headerBytes.get(16);
        int prevReleaseVersion = 972;
        boolean bl = versionMatch = version == 972 && !devBuild || version / 10 == prevReleaseVersion / 10 && !devBuild;
        if (!versionMatch || (long)alignment != 1L || sizeOfSizeT != 8 || sizeOfDbFileOffsetT != 8 || sizeOfDbFileSizeT != 8) {
            return null;
        }
        return byteOrder;
    }

    private static @NonNull Pair<@NonNull DBRootTypeKey, @NonNull IndexId> asPair(Map.Entry<@NonNull Long, @NonNull IndexId> kv) {
        return new Pair((Object)DBRootTypeKey.fromLong(kv.getKey()), (Object)kv.getValue());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertContainsValidMetadata(@NonNull Metadata result, @NonNull Set<@NonNull IndexId> directoryIds, @NonNull Set<@NonNull IndexId> streamIds) throws IOException {
        for (Map.Entry<IndexId, Map<Long, IndexId>> entry : result.parentIdToChildKeyToDirectoryId.entrySet()) {
            if (entry.getKey().equals(IndexId.ROOT) || directoryIds.contains(entry.getKey())) continue;
            throw new IOException("Corrupted db metadata contains directory parent ID without hierarchy mapping");
        }
        for (Map.Entry<IndexId, Map<Long, IndexId>> entry : result.parentIdToChildKeyToStreamId.entrySet()) {
            if (directoryIds.contains(entry.getKey())) continue;
            throw new IOException("corrupted db metadata contains stream parent ID without hierarchy mapping");
        }
        for (Map.Entry<IndexId, Object> entry : result.l0Index.entrySet()) {
            if (!streamIds.contains(entry.getKey())) {
                throw new IOException("Corrupted db metadata contains l0 index entry without matching stream mapping");
            }
            @NonNull List list = (List)entry.getValue();
            Collections.sort(list);
        }
    }

    private static IndexId getId(@NonNull Map<@NonNull IndexId, Map<@NonNull Long, @NonNull IndexId>> map, @NonNull IndexId parent, @NonNull Long key) {
        Map<@NonNull Long, @NonNull IndexId> parentsChildren = map.get(parent);
        if (parentsChildren == null) {
            return null;
        }
        return parentsChildren.get(key);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void readIdMapping(@NonNull PackedValueUnpacker unpacker, @NonNull Metadata result, @NonNull Set<@NonNull IndexId> directoryIds, @NonNull Set<@NonNull IndexId> streamIds) throws IOException {
        @NonNull IndexId parentId = IndexId.fromLong(unpacker.unpackOneLong());
        @NonNull Long key = unpacker.unpackOneLong();
        @NonNull MetadataMappingEntry type = MetadataMappingEntry.fromLong(unpacker.unpackOneLong());
        @NonNull IndexId entryId = IndexId.fromLong(unpacker.unpackOneLong());
        if (entryId.equals(IndexId.ROOT)) {
            throw new IOException("Corrupted db metadata contains root ID");
        }
        if (entryId.equals(IndexId.METADATA)) {
            throw new IOException("Corrupted db metadata contains metadata ID");
        }
        switch (type) {
            case DIRECTORY: {
                @NonNull Map mapForParentId = result.parentIdToChildKeyToDirectoryId.computeIfAbsent(parentId, k -> new HashMap());
                @Nullable IndexId existingEntry = mapForParentId.putIfAbsent(key, entryId);
                if (existingEntry != null) {
                    throw new IOException("Corrupted db metadata contains duplicate directory key");
                }
                if (!directoryIds.add(entryId)) {
                    throw new IOException("Corrupted db metadata contains duplicate directory ID");
                }
                if (!streamIds.contains(entryId)) break;
                throw new IOException("Corrupted db metadata contains duplicate ID used for directory and stream");
            }
            case STREAM: {
                @NonNull Map mapForParentId = result.parentIdToChildKeyToStreamId.computeIfAbsent(parentId, k -> new HashMap());
                IndexId existingEntry = mapForParentId.putIfAbsent(key, entryId);
                if (existingEntry != null) {
                    throw new IOException("Corrupted db metadata contains duplicate stream key");
                }
                if (!streamIds.add(entryId)) {
                    throw new IOException("Corrupted db metadata contains duplicate stream ID");
                }
                if (!directoryIds.contains(entryId)) break;
                throw new IOException("Corrupted db metadata contains duplicate ID used for stream and directory");
            }
            default: {
                throw new IOException("Obtained unexpected metadata mapping id: " + String.valueOf((Object)type));
            }
        }
    }

    private static void readL0Index(@NonNull PackedValueUnpacker unpacker, @NonNull Metadata result) {
        IndexId id = IndexId.fromLong(unpacker.unpackOneLong());
        L0IndexEntry entry = L0IndexEntry.unpackOne(unpacker);
        result.l0Index.computeIfAbsent(id, k -> new ArrayList()).add(entry);
    }

    private static void readStreamMetadataBlob(@NonNull PackedValueUnpacker unpacker, @NonNull Metadata result) {
        IndexId id = IndexId.fromLong(unpacker.unpackOneLong());
        StreamMetadataBlobEntry entry = StreamMetadataBlobEntry.unpackOne(unpacker);
        result.streamMetadataBlobs.computeIfAbsent(id, k -> new ArrayList()).add(entry);
    }

    private static int toPrevVersion(int version) {
        version = version / 10 - 1;
        return version * 10;
    }

    private Metadata() {
        this.parentIdToChildKeyToDirectoryId = new HashMap<IndexId, Map<Long, IndexId>>();
        this.parentIdToChildKeyToStreamId = new HashMap<IndexId, Map<Long, IndexId>>();
        this.l0Index = new HashMap<IndexId, List<L0IndexEntry>>();
        this.streamMetadataBlobs = new HashMap<IndexId, List<StreamMetadataBlobEntry>>();
    }

    @Override
    public Map<@NonNull Long, @NonNull IndexId> getDirectoryFrom(IndexId directoryId) {
        Map<Long, IndexId> result = this.parentIdToChildKeyToDirectoryId.get(directoryId);
        return result == null ? null : Collections.unmodifiableMap(result);
    }

    @Override
    public IndexId getIndexIdOfDirectory(IndexId parent, Long key) {
        return Metadata.getId(this.parentIdToChildKeyToDirectoryId, parent, key);
    }

    @Override
    public List<@NonNull L0IndexEntry> getL0Index(IndexId id) {
        return Collections.unmodifiableList(this.l0Index.getOrDefault(id, Collections.emptyList()));
    }

    @Override
    public List<@NonNull StreamMetadataBlobEntry> getStreamMetadataBlobs(IndexId id) {
        return Collections.unmodifiableList(this.streamMetadataBlobs.getOrDefault(id, Collections.emptyList()));
    }

    @Override
    public Map<@NonNull Long, @NonNull IndexId> getStreamIndicesFromDirectory(IndexId directory) {
        Map<@NonNull Long, @NonNull IndexId> streamIndices = this.parentIdToChildKeyToStreamId.get(directory);
        if (streamIndices == null) {
            return null;
        }
        return Collections.unmodifiableMap(streamIndices);
    }

    @Override
    public ByteOrder getTargetEndianness() {
        return this.targetEndianness;
    }

    @Override
    public List<@NonNull Pair<@NonNull DBRootTypeKey, @NonNull IndexId>> rootDirectory() {
        Map<@NonNull Long, @NonNull IndexId> directory = this.parentIdToChildKeyToDirectoryId.get(IndexId.ROOT);
        if (directory == null) {
            return Collections.emptyList();
        }
        return directory.entrySet().stream().map(kv -> Metadata.asPair(kv)).collect(Collectors.toList());
    }

    protected final Map<@NonNull IndexId, @NonNull List<@NonNull L0IndexEntry>> getL0Index() {
        return Collections.unmodifiableMap(this.l0Index);
    }

    protected final Map<@NonNull IndexId, Map<@NonNull Long, @NonNull IndexId>> getParentIdToChildKeyToDirectoryId() {
        return Collections.unmodifiableMap(this.parentIdToChildKeyToDirectoryId);
    }

    protected final Map<@NonNull IndexId, Map<@NonNull Long, @NonNull IndexId>> getParentIdToChildKeyToStreamId() {
        return Collections.unmodifiableMap(this.parentIdToChildKeyToStreamId);
    }

    protected final Map<@NonNull IndexId, @NonNull List<@NonNull StreamMetadataBlobEntry>> getStreamMetadataBlobs() {
        return Collections.unmodifiableMap(this.streamMetadataBlobs);
    }

    protected final int parentCount() {
        return this.parentIdToChildKeyToDirectoryId.size() + this.parentIdToChildKeyToStreamId.size();
    }
}

