/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMReader;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMWriter;
import com.arm.streamline.analysis.database.stream.cam.CAMJobAggregator;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.CamStreamParser;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.StdLog;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseCamStreamReader
implements IAnalysisCAMReader {
    private final long vmUID;
    private final int viewUID;
    private final @Nullable Integer utid;
    private final @NonNull StreamValueIterator<CamStreamParser.IStreamValue> iterator;
    private final @NonNull LinkedList<IAnalysisCAMReader.Value> completedEvents = new LinkedList();
    private final @NonNull InternalVisitor eventAdaptor;

    private static @NonNull IAnalysisCAMWriter createWriterImpl(final LinkedList<IAnalysisCAMReader.Value> output) {
        return new IAnalysisCAMWriter(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consumeCAMJob(int jobUID, long startTime, String name, int track, long stopTime, int primaryDependency, @Nullable TIntSet dependencies, int color, @NonNull String detailText) throws IOException {
                if (!$assertionsDisabled && output.size() != 0) {
                    throw new AssertionError();
                }
                long duration = stopTime - startTime;
                int @NonNull [] dependenciesArray = dependencies == null ? new int[]{} : dependencies.toArray();
                @NonNull String jobName = name == null ? "" : name;
                output.add(new IAnalysisCAMReader.Value(duration, jobUID, track, color, startTime, primaryDependency, dependenciesArray, jobName, detailText));
            }
        };
    }

    public DatabaseCamStreamReader(long vmUID, int viewUID, @Nullable Integer utid, @NonNull StreamValueIterator<CamStreamParser.IStreamValue> iterator) {
        this.vmUID = vmUID;
        this.viewUID = viewUID;
        this.utid = utid;
        this.iterator = iterator;
        this.eventAdaptor = new InternalVisitor(this.completedEvents);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getViewUID() {
        return this.viewUID;
    }

    @Override
    public long getVmUID() {
        return this.vmUID;
    }

    public @Nullable Integer getUtid() {
        return this.utid;
    }

    @Override
    public @Nullable IAnalysisCAMReader.Value read() throws IOException {
        while (this.iterator.hasNext()) {
            CamStreamParser.IStreamValue item = this.iterator.next();
            item.accept(this.eventAdaptor);
            if (this.completedEvents.size() <= 0) continue;
            assert (this.completedEvents.size() == 1);
            return this.completedEvents.remove();
        }
        return null;
    }

    private static final class InternalVisitor
    implements CamStreamParser.IStreamValueVisitor {
        private final @NonNull CAMJobAggregator aggregator;
        private final @NonNull LinkedList<IAnalysisCAMReader.Value> completedEvents;

        public InternalVisitor(@NonNull LinkedList<IAnalysisCAMReader.Value> completedEvents) {
            this.completedEvents = completedEvents;
            this.aggregator = new CAMJobAggregator(Long.MAX_VALUE, DatabaseCamStreamReader.createWriterImpl(completedEvents), w -> StdLog.warn((Plugin)CommonPlugin.getInstance(), (String)(w.getTitle() + ": " + w.getDescription())));
        }

        @Override
        public void camJob(long timestamp, long sequenceNo, int trackUid, int jobUid, long duration, int colour, int primaryDependencyJobUid, int @NonNull [] dependencyJobUids, @NonNull String jobName, @NonNull String detailText) {
            this.completedEvents.add(new IAnalysisCAMReader.Value(duration, jobUid, trackUid, colour, timestamp, primaryDependencyJobUid, dependencyJobUids, jobName, detailText));
        }

        @Override
        public void camJobDependencies(long timestamp, long sequenceNo, int jobUid, int primaryDependencyJobUid, int @NonNull [] dependencyJobUids) {
            TIntHashSet set = new TIntHashSet(dependencyJobUids.length);
            try {
                set.addAll(dependencyJobUids);
                this.aggregator.camJobDependencies(jobUid, timestamp, primaryDependencyJobUid, (TIntSet)set);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void camJobStart(long timestamp, long sequenceNo, int trackUid, int jobUid, int colour, @NonNull String jobName, @NonNull String detailText) {
            try {
                this.aggregator.camJobStart(jobUid, timestamp, trackUid, jobName, colour, detailText);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void camJobStop(long timestamp, long sequenceNo, int jobUid) {
            try {
                this.aggregator.camJobStop(jobUid, timestamp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void camTrackDefinition(long timestamp, long sequenceNo, int parentTrackUid, int trackUid, @NonNull String name) {
        }

        @Override
        public void camViewDefinition(long timestamp, long sequenceNo, int viewUid, @Nullable Integer utid, @NonNull String name) {
        }
    }
}

