/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.ActivityStreamParser;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseActivityReader
extends AbstractDatabaseVmStreamReader<IAnalysisActivityReader.IValue<ProcessingElementReference>, IStreamValue>
implements IAnalysisActivityReader<ProcessingElementReference> {
    private final @NonNull ProcessingElementReference @NonNull [] channels;

    public DatabaseActivityReader(@NonNull ProcessingElementReference @NonNull [] channels, @NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
        this.channels = channels;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public @NonNull List<@NonNull ProcessingElementReference> getChannels() {
        return Arrays.asList(this.channels);
    }

    @Override
    public @Nullable IAnalysisActivityReader.IValue<ProcessingElementReference> read() throws IOException {
        return (IAnalysisActivityReader.IValue)this.doRead();
    }

    @Override
    protected @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> mapStreamValue(@NonNull IStreamValue value) {
        return value.convert(this.channels);
    }

    public static interface IStreamValue
    extends AbstractDatabaseVmStreamReader.IStreamValue {
        public @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> convert(@NonNull ProcessingElementReference @NonNull [] var1);
    }

    public static final class StopStreamValue
    implements IStreamValue {
        private final int activity;
        private final int channelIndex;
        private final long sequenceNo;
        private final long timestamp;
        private final @Nullable Integer utid;

        public StopStreamValue(int channelBase, int deviceNoCount, int deviceNo, long timestamp, long sequenceNo, int activity, @Nullable Integer utid) {
            assert (deviceNo < deviceNoCount);
            this.channelIndex = channelBase + deviceNo;
            this.activity = activity;
            this.timestamp = timestamp;
            this.sequenceNo = sequenceNo;
            this.utid = utid;
        }

        @Override
        public @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> convert(final @NonNull ProcessingElementReference @NonNull [] channels) {
            return new IAnalysisActivityReader.IValue<ProcessingElementReference>(){

                @Override
                public boolean accept(@NonNull IAnalysisActivityReader.IValueVisitor<ProcessingElementReference> visitor) throws IOException {
                    return visitor.stop(channels[channelIndex], timestamp, activity);
                }

                @Override
                public @NonNull ProcessingElementReference getChannel() {
                    return channels[channelIndex];
                }

                @Override
                public int getChannelIndex() {
                    return channelIndex;
                }

                @Override
                public long getTimestamp() {
                    return timestamp;
                }

                @Override
                public boolean isSwitch() {
                    return false;
                }
            };
        }

        @Override
        public long getSequenceNo() {
            return this.sequenceNo;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static final class SwitchStreamValue
    implements IStreamValue {
        private final int activity;
        private final int channelIndex;
        private final int reason;
        private final long sequenceNo;
        private final long timestamp;
        private final @Nullable Integer utid;

        public SwitchStreamValue(int channelBase, int deviceNoCount, int deviceNo, long timestamp, long sequenceNo, int activity, int reason, @Nullable Integer utid) {
            assert (deviceNo < deviceNoCount);
            this.channelIndex = channelBase + deviceNo;
            this.activity = activity;
            this.reason = reason;
            this.timestamp = timestamp;
            this.sequenceNo = sequenceNo;
            this.utid = utid;
        }

        @Override
        public @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> convert(final @NonNull ProcessingElementReference @NonNull [] channels) {
            return new IAnalysisActivityReader.IValue<ProcessingElementReference>(){

                @Override
                public boolean accept(@NonNull IAnalysisActivityReader.IValueVisitor<ProcessingElementReference> visitor) throws IOException {
                    return visitor.swtch(channels[channelIndex], timestamp, utid, activity, reason);
                }

                @Override
                public @NonNull ProcessingElementReference getChannel() {
                    return channels[channelIndex];
                }

                @Override
                public int getChannelIndex() {
                    return channelIndex;
                }

                @Override
                public long getTimestamp() {
                    return timestamp;
                }

                @Override
                public boolean isSwitch() {
                    return false;
                }
            };
        }

        @Override
        public long getSequenceNo() {
            return this.sequenceNo;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static final class VmStream
    implements IThrowingSupplier<IStreamValue, IOException> {
        private final int channelBase;
        private final int deviceNoCount;
        private final @NonNull ActivityStreamParser.IStreamValueVisitor<@NonNull IStreamValue, RuntimeException> factoryVisitor;
        private final @NonNull StreamValueIterator<ActivityStreamParser.IStreamValue> valueIterator;

        public VmStream(final int channelBase, final int deviceNoCount, @NonNull List<@NonNull L0IndexEntry> l0Index, @NonNull IFileDataView dataFileView) throws IOException {
            this.channelBase = channelBase;
            this.deviceNoCount = deviceNoCount;
            this.factoryVisitor = new ActivityStreamParser.IStreamValueVisitor<IStreamValue, RuntimeException>(){

                @Override
                public @NonNull IStreamValue stop(int deviceNo, long timestamp, long sequenceNo, int activity, @Nullable Integer utid) throws RuntimeException {
                    return new StopStreamValue(channelBase, deviceNoCount, deviceNo, timestamp, sequenceNo, activity, utid);
                }

                @Override
                public @NonNull IStreamValue swtch(int deviceNo, long timestamp, long sequenceNo, int activity, int reason, @Nullable Integer utid) throws RuntimeException {
                    return new SwitchStreamValue(channelBase, deviceNoCount, deviceNo, timestamp, sequenceNo, activity, reason, utid);
                }
            };
            this.valueIterator = new StreamValueIterator<ActivityStreamParser.IStreamValue>(dataFileView, L1IndexIterator.createFromL0Index(dataFileView, l0Index), new ActivityStreamParser());
        }

        public @Nullable IStreamValue get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            ActivityStreamParser.IStreamValue value = this.valueIterator.next();
            return value.accept(this.factoryVisitor);
        }
    }
}

