/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseReaderFactoryV3;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class AnalysisDatabaseFactory {
    public static final boolean ENABLE_V3_LOGGING = NullChecking.equalsNullable((Object)System.getenv("STREAMLINE_ENABLE_DBV3_DEMO_LOGGING"), (Object)"true");

    public static @NonNull IAnalysisReaderFactoryV2 create(@NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException, BadXmlException {
        File indexFile = new File(dbDirectory, "index.db");
        File dataFile = new File(dbDirectory, "data.db");
        if (!indexFile.isFile() || !dataFile.isFile()) {
            throw new FileNotFoundException("DB files are missing");
        }
        return new AnalysisDatabaseReaderFactoryV3(dbDirectory, deviceTypeCalculator);
    }

    public static boolean isValidVersion(@NonNull File dbDirectory) {
        File indexFile = new File(dbDirectory, "index.db");
        File dataFile = new File(dbDirectory, "data.db");
        return indexFile.isFile() && dataFile.isFile();
    }
}

