/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueReader;
import com.arm.streamline.analysis.database.stream.chunkwriter.IIndexedChunkStreamReader;
import com.arm.streamline.analysis.database.stream.chunkwriter.IndexedChunkStreamReader;
import com.arm.streamline.analysis.database.stream.chunkwriter.ZeroCompressingCounterValueChunkReader;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseCounterChannelReader;
import com.arm.streamline.analysis.processing.CachingStreamReaderAdapter;
import com.arm.streamline.analysis.processing.CachingStreamReaderAdapterBase;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterChannelReader
implements IDatabaseCounterChannelReader {
    private static final @NonNull IIndexedChunkStreamReader NO_DATA_READER = new IndexedChunkStreamReader((TLongObjectMap<? extends TLongIntIterator>)new TLongObjectHashMap(), new SeekableByteChannel(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public long position() throws IOException {
            return 0L;
        }

        @Override
        public @NonNull SeekableByteChannel position(long newPosition) throws IOException {
            if (newPosition != 0L) {
                throw new IOException();
            }
            return this;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            throw new IOException();
        }

        @Override
        public long size() throws IOException {
            return 0L;
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            throw new IOException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new IOException();
        }
    });
    private final int channelIndex;
    private final boolean deltaCounter;
    private final @NonNull IIndexedChunkStreamReader chunkReader;
    private final @NonNull TLongObjectMap<CachingStreamReaderAdapter<IAnalysisCounterValueReader.Value>> chunkStreams = new TLongObjectHashMap(10, 0.5f, Long.MIN_VALUE);
    private long lastTimestamp = -1L;
    private long sequenceCounter = 0L;
    private boolean first = true;

    public static @NonNull File makeFile(@NonNull File parentPath, long vmUID, int deviceNumber, boolean index) {
        return new File(parentPath, String.format("%d-%d.%s", vmUID, deviceNumber, index ? "ndx" : "bin"));
    }

    private static @NonNull IIndexedChunkStreamReader create(@NonNull File parentPath, long vmUID, int deviceNumber) throws IOException {
        File dataFile = DatabaseCounterChannelReader.makeFile(parentPath, vmUID, deviceNumber, false);
        File indexFile = DatabaseCounterChannelReader.makeFile(parentPath, vmUID, deviceNumber, true);
        if (!indexFile.isFile()) {
            assert (!dataFile.isFile());
            return NO_DATA_READER;
        }
        assert (dataFile.isFile());
        return new IndexedChunkStreamReader(dataFile, indexFile);
    }

    public DatabaseCounterChannelReader(@NonNull File parentPath, boolean deltaCounter, long vmUID, int deviceNumber, int channelIndex) throws IOException {
        this(DatabaseCounterChannelReader.create(parentPath, vmUID, deviceNumber), deltaCounter, channelIndex);
    }

    DatabaseCounterChannelReader(@NonNull IIndexedChunkStreamReader chunkReader, boolean deltaCounter, int channelIndex) {
        this.chunkReader = chunkReader;
        this.channelIndex = channelIndex;
        this.deltaCounter = deltaCounter;
        try {
            long[] lArray = chunkReader.getKeys();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long key = lArray[n2];
                ZeroCompressingCounterValueChunkReader reader = new ZeroCompressingCounterValueChunkReader((IThrowingSupplier<byte[], IOException>)((IThrowingSupplier)() -> chunkReader.next(key)));
                CachingStreamReaderAdapter cacher = new CachingStreamReaderAdapter(reader::next);
                this.chunkStreams.put(key, cacher);
                ++n2;
            }
        }
        catch (Throwable t) {
            try {
                chunkReader.close();
            }
            catch (Throwable t1) {
                t1.addSuppressed(t);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        this.chunkReader.close();
    }

    public @Nullable IAnalysisHardwareCounterReader.Value get() throws IOException {
        if (this.chunkStreams.isEmpty()) {
            return null;
        }
        long bestKey = Long.MIN_VALUE;
        IAnalysisCounterValueReader.Value bestValue = null;
        CachingStreamReaderAdapterBase bestStream = null;
        TLongObjectIterator it = this.chunkStreams.iterator();
        while (it.hasNext()) {
            it.advance();
            long key = it.key();
            CachingStreamReaderAdapter stream = (CachingStreamReaderAdapter)it.value();
            IAnalysisCounterValueReader.Value value = (IAnalysisCounterValueReader.Value)stream.head();
            if (value == null) {
                it.remove();
                continue;
            }
            if (bestValue != null && bestValue.timestamp <= value.timestamp && (bestValue.timestamp != value.timestamp || bestValue.sequenceNo <= value.sequenceNo)) continue;
            bestKey = key;
            bestValue = value;
            bestStream = stream;
        }
        if (bestValue == null) {
            return null;
        }
        assert (bestStream != null);
        bestStream.next();
        @Nullable Integer utid = UtidToLong.unmapUtid(bestKey);
        if (!this.deltaCounter) {
            return new IAnalysisHardwareCounterReader.Value(this.channelIndex, bestValue.timestamp, this.sequenceCounter++, 0L, utid, bestValue.value);
        }
        if (this.first) {
            this.first = false;
            this.lastTimestamp = Math.max(bestValue.timestamp, -1L);
            return new IAnalysisHardwareCounterReader.Value(this.channelIndex, -1L, this.sequenceCounter++, 0L, utid, bestValue.value);
        }
        long prev = this.lastTimestamp >= 0L ? this.lastTimestamp : (long)(bestValue.timestamp >= 0L ? 0 : -1);
        long next = bestValue.timestamp >= 0L || this.lastTimestamp >= 0L ? Math.max(bestValue.timestamp, prev) : -1L;
        long duration = Math.max(next - prev, 0L);
        this.lastTimestamp = next;
        return new IAnalysisHardwareCounterReader.Value(this.channelIndex, prev, this.sequenceCounter++, duration, utid, bestValue.value);
    }
}

