/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.analysis.database.stream.chunkwriter.IIndexedChunkStreamReader;
import com.arm.streamline.analysis.database.stream.chunkwriter.IndexChunkMap;
import com.arm.utils.io.ByteChannelUtils;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.TLongObjectMap;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class IndexedChunkStreamReader
implements IIndexedChunkStreamReader {
    private final @NonNull TLongObjectMap<? extends TLongIntIterator> index;
    private final @NonNull SeekableByteChannel input;

    public IndexedChunkStreamReader(@NonNull File dataFile, @NonNull File indexFile) throws IOException {
        this(IndexChunkMap.create(indexFile), FileChannel.open(dataFile.toPath(), StandardOpenOption.READ));
    }

    public IndexedChunkStreamReader(@NonNull TLongObjectMap<? extends TLongIntIterator> index, @NonNull SeekableByteChannel input) {
        this.index = index;
        this.input = input;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public long @NonNull [] getKeys() {
        return this.index.keys();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public byte @Nullable [] next(long key) throws IOException {
        TLongIntIterator iterator = (TLongIntIterator)this.index.get(key);
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            this.index.remove(key);
            return null;
        }
        iterator.advance();
        long offset = iterator.key();
        int length = iterator.value();
        return this.read(offset, length);
    }

    private final byte @NonNull [] read(long offset, int length) throws IOException {
        return ByteChannelUtils.readNbytes((ByteChannel)this.input.position(offset), (int)length);
    }
}

