/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.ComputedSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ObservablesHelper {
    public static <T> void addInRealm(@NonNull IObservableList<T> observable, T value) {
        observable.getRealm().exec(() -> {
            boolean bl = observable.add(value);
        });
    }

    public static <T> void addInRealm(@NonNull IObservableSet<T> observable, T value) {
        observable.getRealm().exec(() -> {
            boolean bl = observable.add(value);
        });
    }

    public static <T> @NonNull ComputedSet<T> createComputedSet(final @NonNull Supplier<@NonNull Set<T>> supplier) {
        return new ComputedSet<T>(){

            protected Set<T> calculate() {
                return (Set)supplier.get();
            }
        };
    }

    public static <K, V> @NonNull IObservableValue<@Nullable V> createMapValueByKey(@NonNull IObservableMap<@NonNull K, V> observableMap, @NonNull IObservableValue<@Nullable ? extends K> observableKey) {
        return ComputedValue.create(() -> {
            @Nullable Object key = observableKey.getValue();
            @Nullable Object value = observableMap.get(key);
            return value;
        });
    }

    public static <K, V> @NonNull IObservableValue<@Nullable V> observeDetailOfMapValueByKey(@NonNull IObservableMap<@NonNull K, IObservableValue<V>> observableMap, @NonNull IObservableValue<@Nullable ? extends K> observableKey) {
        @NonNull IObservableValue<@Nullable IObservableValue<V>> master = ObservablesHelper.createMapValueByKey(observableMap, observableKey);
        return Properties.observableValue(null).observeDetail(master);
    }

    public static <T> void setInRealm(@NonNull IObservableValue<T> observable, T value) {
        observable.getRealm().exec(() -> observable.setValue(value));
    }

    public static <M, T> @NonNull IObservableValue<T> observeDetail(@NonNull IObservableValue<M> master, @NonNull Function<? super M, ? extends @NonNull IObservableValue<T>> detailGetter, Object detailType) {
        IObservableFactory detailFactory = m -> new DecoratingObservableValue((IObservableValue)detailGetter.apply((Object)m), false);
        return MasterDetailObservables.detailValue(master, (IObservableFactory)detailFactory, (Object)detailType);
    }
}

