/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelGenerator;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AllZoomLevelsGenerator
implements IZoomLevelGenerator {
    private final @NonNull IZoomLevelGenerator @NonNull [] individualZoomLevels;

    public AllZoomLevelsGenerator(int @NonNull [] numberOfTicksPerBin, int @NonNull [] labelsPerBin, @NonNull IZoomLevelGeneratorFactory factory) throws IOException {
        if (labelsPerBin.length != numberOfTicksPerBin.length) {
            throw new IllegalArgumentException();
        }
        this.individualZoomLevels = new IZoomLevelGenerator[labelsPerBin.length];
        try {
            int i = 0;
            while (i < this.individualZoomLevels.length) {
                this.individualZoomLevels[i] = factory.create(numberOfTicksPerBin[i], labelsPerBin[i]);
                ++i;
            }
        }
        catch (Throwable t) {
            Throwing.closeAll((Closeable[])this.individualZoomLevels);
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])this.individualZoomLevels);
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualZoomLevels;
        int n = this.individualZoomLevels.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualZoomLevel = iZoomLevelGeneratorArray[n2];
            individualZoomLevel.consumeCounterValue(channelNumber, utid, value, happenedInBin);
            ++n2;
        }
    }

    @Override
    public void discard() {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualZoomLevels;
        int n = this.individualZoomLevels.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualZoomLevel = iZoomLevelGeneratorArray[n2];
            individualZoomLevel.discard();
            ++n2;
        }
    }

    @Override
    public void nextBaseBin() throws IOException {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualZoomLevels;
        int n = this.individualZoomLevels.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualZoomLevel = iZoomLevelGeneratorArray[n2];
            individualZoomLevel.nextBaseBin();
            ++n2;
        }
    }

    @FunctionalInterface
    public static interface IZoomLevelGeneratorFactory {
        public @NonNull IZoomLevelGenerator create(int var1, int var2) throws IOException;
    }
}

