/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.pe;

import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.utils.NullChecking;
import com.arm.utils.text.NumericStringComparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProcessingElementDescriptor
implements Comparable<ProcessingElementDescriptor> {
    private final int mCpuid;
    private final int mRelativeCoreId;
    private final @NonNull String mLabel;
    private final @Nullable ProcessingElementTopology mTopology;

    public ProcessingElementDescriptor(int cpuid, @NonNull String label, @Nullable ProcessingElementTopology topology) {
        this.mCpuid = cpuid;
        this.mRelativeCoreId = Integer.MAX_VALUE;
        this.mLabel = label;
        this.mTopology = topology;
    }

    public ProcessingElementDescriptor(int cpuid, int relativeCoreId, @NonNull String label, @Nullable ProcessingElementTopology topology) {
        this.mCpuid = cpuid;
        this.mRelativeCoreId = relativeCoreId;
        this.mLabel = label;
        this.mTopology = topology;
    }

    @Override
    public int compareTo(ProcessingElementDescriptor o) {
        boolean thisIsArm = ClusterNameUtils.isArmCortexOrNeoverse((String)this.mLabel);
        boolean thatIsArm = ClusterNameUtils.isArmCortexOrNeoverse((String)o.getLabel());
        if (thisIsArm && thatIsArm) {
            return NumericStringComparator.caselessCompareStrings((String)o.getLabel(), (String)this.mLabel);
        }
        if (!thisIsArm && thatIsArm) {
            return 1;
        }
        if (thisIsArm && !thatIsArm) {
            return -1;
        }
        return NumericStringComparator.caselessCompareStrings((String)this.mLabel, (String)o.getLabel());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcessingElementDescriptor) {
            ProcessingElementDescriptor that = (ProcessingElementDescriptor)obj;
            return this.mCpuid == that.mCpuid && this.mLabel.equals(that.mLabel) && NullChecking.equalsNullable((Object)this.mTopology, (Object)that.mTopology);
        }
        return false;
    }

    public int getCpuid() {
        return this.mCpuid;
    }

    public int getRelativeCoreId() {
        return this.mRelativeCoreId;
    }

    public @NonNull String getLabel() {
        return this.mLabel;
    }

    public @Nullable ProcessingElementTopology getTopology() {
        return this.mTopology;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mCpuid;
        result = 31 * result + this.mLabel.hashCode();
        return result;
    }

    public String toString() {
        return this.mLabel;
    }
}

