/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.collections.Pair;
import com.arm.utils.io.FileUtils;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PathSubstitutionsFile {
    public static final String RELATIVE_PATH_REMAP_BASE = "/UNSPECIFIED";
    private static final String ATTR_PREFIX = "prefix";
    private static final String ATTR_REPLACEMENT = "replacement";
    private static final String STATIC_FILENAME = "../path_overrides.xml";
    private static final String TAG_PATH_SUBSTITUTION = "path_substitution";
    private static final String TAG_PATH_SUBSTITUTIONS = "path_substitutions";
    private final @NonNull Map<@NonNull String, @NonNull String> mDefaultPathSubstitutions = new HashMap<String, String>();
    private final @NonNull Map<@NonNull String, @NonNull String> mPathSubstitutions = new HashMap<String, String>();
    private final @NonNull File reportDirectory;

    public static @NonNull String adjustPathForSubstitutions(@NonNull String path, @NonNull Map<@NonNull String, @NonNull String> substitutions) {
        for (Pair<String, String> entry : PathSubstitutionsFile.getSubstitutionOrder(substitutions)) {
            String key = (String)entry.first;
            String val = (String)entry.second;
            if (!path.startsWith(key)) continue;
            return (String)NullChecking.neverNull((Object)new File(val, path.substring(key.length())).toString());
        }
        return path;
    }

    public static <T> @NonNull List<@NonNull Pair<@NonNull String, T>> getSubstitutionOrder(@NonNull Map<@NonNull String, T> substitutions) {
        ArrayList result = substitutions.entrySet().stream().map(e -> new Pair((Object)((String)e.getKey()), e.getValue())).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(result, (o1, o2) -> {
            String k1 = (String)o1.first;
            String k2 = (String)o2.first;
            if (k1.startsWith(k2)) {
                return -1;
            }
            if (k2.startsWith(k1)) {
                return 1;
            }
            return k1.compareTo(k2);
        });
        return result;
    }

    private static @NonNull Map<@NonNull String, @NonNull String> computeNewDefaultPathSubstitutions(@NonNull Map<@NonNull String, @NonNull TObjectIntMap<@NonNull String>> fromToCount, @NonNull IProgressMonitor monitor) {
        HashMap<String, String> newDefaultPathSubstitutions = new HashMap<String, String>();
        for (Pair<String, TObjectIntMap<String>> entry : PathSubstitutionsFile.getSubstitutionOrder(fromToCount)) {
            String fromPath = (String)entry.first;
            String bestToPath = null;
            int bestCount = 0;
            boolean bestIsDiplicated = false;
            TObjectIntIterator it = ((TObjectIntMap)entry.second).iterator();
            while (it.hasNext()) {
                it.advance();
                String toPath = (String)it.key();
                int count = it.value();
                if (bestToPath == null || bestCount < count) {
                    bestToPath = toPath;
                    bestCount = count;
                    bestIsDiplicated = false;
                    continue;
                }
                if (bestCount != count) continue;
                bestIsDiplicated = true;
            }
            if (!bestIsDiplicated && bestToPath != null) {
                newDefaultPathSubstitutions.put(fromPath, bestToPath);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        return newDefaultPathSubstitutions;
    }

    private static @NonNull Map<@NonNull String, @NonNull TObjectIntMap<@NonNull String>> computePossibleMappings(@NonNull Map<@NonNull String, List<@NonNull SourceFile>> allSourceFileNames, @NonNull Map<@NonNull String, @NonNull Set<@NonNull ObjIntPair<@NonNull Path>>> nameToPossibileMatches, @NonNull IProgressMonitor monitor) {
        HashMap<String, TObjectIntMap<String>> fromToCount = new HashMap<String, TObjectIntMap<String>>();
        for (Map.Entry<String, List<SourceFile>> entry : allSourceFileNames.entrySet()) {
            String sfName = entry.getKey();
            List<SourceFile> sfPaths = entry.getValue();
            Set<ObjIntPair<Path>> possibilities = nameToPossibileMatches.get(sfName);
            if (possibilities == null || possibilities.isEmpty()) continue;
            for (SourceFile sfPath : sfPaths) {
                for (ObjIntPair<Path> possibility : possibilities) {
                    Pair<String, String> mapping = PathSubstitutionsFile.findCommonRoot(sfPath, (Path)possibility.first, possibility.second);
                    if (mapping == null) continue;
                    TObjectIntMap innerMap = fromToCount.computeIfAbsent((String)mapping.first, k -> new TObjectIntHashMap(10, 0.5f, 0));
                    innerMap.adjustOrPutValue((Object)((String)mapping.second), 1, 1);
                }
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        return fromToCount;
    }

    private static @NonNull Map<@NonNull String, @NonNull Set<@NonNull ObjIntPair<@NonNull Path>>> findAllPossibleSourceMatches(@NonNull List<@NonNull File> defaultSearchDirs, final @NonNull Map<@NonNull String, @NonNull List<@NonNull SourceFile>> allSourceFileNames, final @NonNull IProgressMonitor monitor) {
        final HashMap<String, Set<ObjIntPair<Path>>> nameToPossibileMatches = new HashMap<String, Set<ObjIntPair<Path>>>();
        final HashSet allVisitedDirectories = new HashSet();
        for (File searchDir : defaultSearchDirs) {
            try {
                final Path rootDirPath = FileUtils.canonicalise((File)searchDir).toPath();
                Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    private static int splitPathParts(@NonNull Path rootDirPath2, @NonNull Path file) {
                        Path relPath = rootDirPath2.relativize(file);
                        int count = 0;
                        for (Path name : relPath) {
                            String str = name.toString();
                            if (str.isEmpty() || str.contentEquals("..")) {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)"Shouldn't expect .. in relativized path");
                                }
                                return 0;
                            }
                            if (str.contentEquals(".")) {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)"Shouldn't expect . or blank in relativized path");
                                }
                                continue;
                            }
                            ++count;
                        }
                        return count;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        File absFile = FileUtils.canonicalise((File)dir.toFile());
                        if (monitor.isCanceled()) {
                            return FileVisitResult.TERMINATE;
                        }
                        if (!allVisitedDirectories.add(absFile)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        monitor.subTask(absFile.getPath());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        int pathPartsCount;
                        String name = file.getFileName().toString();
                        if (allSourceFileNames.containsKey(name) && (pathPartsCount = 1.splitPathParts(rootDirPath, file)) > 0) {
                            Set set = nameToPossibileMatches.computeIfAbsent(name, k -> new HashSet());
                            set.add(new ObjIntPair((Object)file, pathPartsCount));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                CommonPlugin.warning((String)"Failed scanning default source path due to exception", (Throwable)e);
            }
            monitor.worked(1);
        }
        return nameToPossibileMatches;
    }

    private static @Nullable Pair<@NonNull String, @NonNull String> findCommonRoot(@NonNull SourceFile sourceFile, @NonNull Path possibilePath, int maxParentCount) {
        return PathSubstitutionsFile.findCommonRoot(sourceFile.filePath, possibilePath.toString(), maxParentCount);
    }

    private static @Nullable Pair<@NonNull String, @NonNull String> findCommonRoot(@NonNull String sourcePath, @NonNull String targetPath, int maxParentCount) {
        String targetParent;
        String targetName;
        if (maxParentCount == 0) {
            throw new IllegalArgumentException();
        }
        sourcePath = (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)sourcePath));
        targetPath = (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)targetPath));
        String sourceName = (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)sourcePath));
        if (!sourceName.contentEquals(targetName = (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)targetPath)))) {
            return null;
        }
        String sourceParent = (String)NullChecking.neverNull((Object)FilePath.getParent((String)sourcePath, (boolean)false));
        if (sourceParent.contentEquals(targetParent = (String)NullChecking.neverNull((Object)FilePath.getParent((String)targetPath, (boolean)false)))) {
            return null;
        }
        maxParentCount = maxParentCount > 0 ? maxParentCount - 1 : -1;
        while (maxParentCount != 0 && ((String)NullChecking.neverNull((Object)FilePath.getLeafName((String)sourceParent))).contentEquals(FilePath.getLeafName((String)targetParent))) {
            sourceParent = (String)NullChecking.neverNull((Object)FilePath.getParent((String)sourceParent, (boolean)false));
            targetParent = (String)NullChecking.neverNull((Object)FilePath.getParent((String)targetParent, (boolean)false));
            int n = maxParentCount = maxParentCount > 0 ? maxParentCount - 1 : -1;
        }
        return new Pair((Object)sourceParent, (Object)targetParent);
    }

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    private static boolean updateSubstitutionsBasedOnFile(@NonNull Map<@NonNull String, @NonNull String> pathSubstitutions, @NonNull String sourcePath, @NonNull String targetPath) {
        Pair<String, String> mapping = PathSubstitutionsFile.findCommonRoot(sourcePath, targetPath, -1);
        if (mapping == null) {
            return false;
        }
        pathSubstitutions.put((String)mapping.first, (String)mapping.second);
        return true;
    }

    public PathSubstitutionsFile(@NonNull File reportDirectory, @NonNull IProgressTracker tracker) {
        tracker.setSubTaskTitle(Messages.PATH_SUBSTITUTIONS);
        this.reportDirectory = reportDirectory;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CountedInputStream cin = new CountedInputStream(PathSubstitutionsFile.getFile(reportDirectory));){
                tracker.setProgressProvider((IProgressProvider)cin);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (XMLParser in = XMLParser.create((InputStream)cin);){
                    String tag;
                    while ((tag = in.nextTag()) != null) {
                        if (TAG_PATH_SUBSTITUTIONS.equals(tag)) {
                            String marker = in.getMarker();
                            while ((tag = in.nextTag(marker)) != null) {
                                if (TAG_PATH_SUBSTITUTION.equals(tag)) {
                                    String prefix = in.getAttribute(ATTR_PREFIX, "");
                                    String replacement = in.getAttribute(ATTR_REPLACEMENT, "");
                                    if (prefix.isEmpty()) continue;
                                    this.mPathSubstitutions.put(prefix, replacement);
                                    tracker.update();
                                    continue;
                                }
                                in.skip();
                            }
                        } else {
                            in.skip();
                        }
                        tracker.update();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                tracker.update();
                tracker.setProgressProvider(null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String computeUpdatedPath(@NonNull SourceFile sourceFile) {
        String name = sourceFile.getFileName();
        String dir = FilePath.normalizeFullPath((String)sourceFile.getParentPath());
        assert (dir != null);
        if (dir.isEmpty() || !FilePath.isFullPath((String)dir)) {
            dir = FilePath.getFullPath((String)RELATIVE_PATH_REMAP_BASE, (String)dir);
        }
        if (!this.isSpecialDirectory(dir, false)) {
            String fullPath = FilePath.getFullPath((String)PathSubstitutionsFile.adjustPathForSubstitutions(dir, this.mPathSubstitutions), (String)name);
            File file = new File(fullPath);
            if (file.isFile()) {
                return fullPath;
            }
            Map<String, String> map = this.mDefaultPathSubstitutions;
            synchronized (map) {
                fullPath = FilePath.getFullPath((String)PathSubstitutionsFile.adjustPathForSubstitutions(dir, this.mDefaultPathSubstitutions), (String)name);
                file = new File(fullPath);
                if (file.isFile()) {
                    return fullPath;
                }
            }
        }
        return (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)sourceFile.filePath));
    }

    public @NonNull Map<@NonNull String, @NonNull String> getPathSubstitutions() {
        return this.mPathSubstitutions;
    }

    public boolean isSpecialDirectory(@NonNull String directory, boolean filterApcPaths) {
        String path = FilePath.getFullPath((File)this.reportDirectory);
        if ((directory = (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)directory))).endsWith(FilePath.PATH_SEPARATOR)) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (path.equals(directory)) {
            return true;
        }
        if (filterApcPaths) {
            if (FilePath.getParent((String)path, (boolean)false).equals(directory)) {
                return true;
            }
            String dir = directory.toLowerCase();
            if (dir.contains(".apc/") || dir.endsWith(".apc")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepopulateFrom(@NonNull Set<@NonNull SourceFile> referencedSourceFiles, @NonNull List<@NonNull File> defaultSearchDirs, @NonNull IProgressMonitor monitor) {
        CommonPlugin.info((String)("Updating default source directory mappings for " + this.reportDirectory.getParent()));
        monitor.beginTask("Enumerating source files", -1);
        Map<String, List<SourceFile>> allSourceFileNames = referencedSourceFiles.stream().collect(Collectors.groupingBy(SourceFile::getFileName));
        monitor.beginTask("Scanning filesystem", defaultSearchDirs.size());
        Map<String, Set<ObjIntPair<Path>>> nameToPossibileMatches = PathSubstitutionsFile.findAllPossibleSourceMatches(defaultSearchDirs, allSourceFileNames, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.beginTask("Determining possible mappings", allSourceFileNames.size());
        Map<String, TObjectIntMap<String>> fromToCount = PathSubstitutionsFile.computePossibleMappings(allSourceFileNames, nameToPossibileMatches, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.beginTask("Creating default source path mappings", fromToCount.size());
        Map<String, String> newDefaultPathSubstitutions = PathSubstitutionsFile.computeNewDefaultPathSubstitutions(fromToCount, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        CommonPlugin.info((String)String.format("There are now %d default path substitutions for %s", newDefaultPathSubstitutions.size(), this.reportDirectory.getParent()));
        Map<String, String> map = this.mDefaultPathSubstitutions;
        synchronized (map) {
            this.mDefaultPathSubstitutions.clear();
            this.mDefaultPathSubstitutions.putAll(newDefaultPathSubstitutions);
        }
        return true;
    }

    public void save() {
        block14: {
            try {
                File file = PathSubstitutionsFile.getFile(this.reportDirectory);
                if (this.mPathSubstitutions.isEmpty()) {
                    file.delete();
                    break block14;
                }
                Throwable throwable = null;
                Object var3_5 = null;
                try (XMLGenerator xml = XMLGenerator.create((File)file);){
                    xml.startDocument();
                    xml.startTag(TAG_PATH_SUBSTITUTIONS);
                    if (!this.mPathSubstitutions.isEmpty()) {
                        for (Map.Entry<String, String> entry : this.mPathSubstitutions.entrySet()) {
                            xml.startEmptyTag(TAG_PATH_SUBSTITUTION);
                            xml.addAttribute(ATTR_PREFIX, entry.getKey());
                            xml.addAttribute(ATTR_REPLACEMENT, entry.getValue());
                        }
                    }
                    xml.endTag();
                    xml.endDocument();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    public boolean updateSubstitutionsBasedOnFile(@NonNull String sourcePath, @NonNull String targetPath) {
        if (!PathSubstitutionsFile.updateSubstitutionsBasedOnFile(this.mPathSubstitutions, sourcePath, targetPath)) {
            return false;
        }
        this.save();
        return true;
    }
}

