/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.IndexData;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;

public class BufferedIndexData
implements IndexData {
    private @NonNull LongBuffer buffer;

    public BufferedIndexData(@NonNull File indexFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(indexFile);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FileChannel channel = stream.getChannel();){
                long size = channel.size();
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)size).order(ByteOrder.LITTLE_ENDIAN);
                int i = 0;
                while (i < 10) {
                    channel.read(byteBuffer);
                    if (!byteBuffer.hasRemaining()) break;
                    ++i;
                }
                byteBuffer.flip();
                this.buffer = (LongBuffer)NullChecking.neverNull((Object)byteBuffer.asLongBuffer());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public long readNext() {
        return this.buffer.get();
    }

    @Override
    public void seek(long position) {
        this.buffer.position((int)(position / 8L));
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.limit() - this.buffer.position() >= 2;
    }

    @Override
    public void close() throws IOException {
    }
}

