/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh.sshj;

import com.arm.streamline.deviceconn.ssh.sshj.ISFTPClient;
import com.arm.utils.NullChecking;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyPair;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.AlgorithmsVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUpdateProvider;
import org.eclipse.jdt.annotation.NonNull;

public interface ISSHClient
extends Closeable {
    public static @NonNull ISSHClient wrap(final @NonNull SSHClient session) {
        return new ISSHClient(){

            @Override
            public void addHostKeyVerifier(HostKeyVerifier verifier) {
                session.addHostKeyVerifier(verifier);
            }

            @Override
            public void addAlgorithmsVerifier(AlgorithmsVerifier verifier) {
                session.addAlgorithmsVerifier(verifier);
            }

            @Override
            public void addHostKeyVerifier(String fingerprint) {
                session.addHostKeyVerifier(fingerprint);
            }

            @Override
            public void auth(String username, AuthMethod ... methods) throws UserAuthException, TransportException {
                session.auth(username, methods);
            }

            @Override
            public void auth(String username, Iterable<AuthMethod> methods) throws UserAuthException, TransportException {
                session.auth(username, methods);
            }

            @Override
            public void authPassword(String username, String password) throws UserAuthException, TransportException {
                session.authPassword(username, password);
            }

            @Override
            public void authPassword(String username, char[] password) throws UserAuthException, TransportException {
                session.authPassword(username, password);
            }

            @Override
            public void authPassword(String username, PasswordFinder pfinder) throws UserAuthException, TransportException {
                session.authPassword(username, pfinder);
            }

            @Override
            public void authPassword(String username, PasswordFinder pfinder, PasswordUpdateProvider newPasswordProvider) throws UserAuthException, TransportException {
                session.authPassword(username, pfinder, newPasswordProvider);
            }

            @Override
            public void authPublickey(String username) throws UserAuthException, TransportException {
                session.authPublickey(username);
            }

            @Override
            public void authPublickey(String username, Iterable<KeyProvider> keyProviders) throws UserAuthException, TransportException {
                session.authPublickey(username, keyProviders);
            }

            @Override
            public void authPublickey(String username, KeyProvider ... keyProviders) throws UserAuthException, TransportException {
                session.authPublickey(username, keyProviders);
            }

            @Override
            public void authPublickey(String username, String ... locations) throws UserAuthException, TransportException {
                session.authPublickey(username, locations);
            }

            @Override
            public void setConnectTimeout(int connectTimeout) {
                session.setConnectTimeout(connectTimeout);
            }

            @Override
            public void setTimeout(int timeout) {
                session.setTimeout(timeout);
            }

            @Override
            public void connect(String hostname, int port) throws IOException {
                session.connect(hostname, port);
            }

            @Override
            public void close() throws IOException {
                session.close();
            }

            @Override
            public void disconnect() throws IOException {
                session.disconnect();
            }

            @Override
            public boolean isConnected() {
                return session.isConnected();
            }

            @Override
            public KeyProvider loadKeys(KeyPair kp) {
                return session.loadKeys(kp);
            }

            @Override
            public KeyProvider loadKeys(String location) throws IOException {
                return session.loadKeys(location);
            }

            @Override
            public KeyProvider loadKeys(String location, char[] passphrase) throws IOException {
                return session.loadKeys(location, passphrase);
            }

            @Override
            public KeyProvider loadKeys(String location, PasswordFinder passwordFinder) throws IOException {
                return session.loadKeys(location, passwordFinder);
            }

            @Override
            public KeyProvider loadKeys(String location, String passphrase) throws IOException {
                return session.loadKeys(location, passphrase);
            }

            @Override
            public KeyProvider loadKeys(String privateKey, String publicKey, PasswordFinder passwordFinder) throws IOException {
                return session.loadKeys(privateKey, publicKey, passwordFinder);
            }

            @Override
            public void loadKnownHosts() throws IOException {
                session.loadKnownHosts();
            }

            @Override
            public void loadKnownHosts(File location) throws IOException {
                session.loadKnownHosts(location);
            }

            @Override
            public @NonNull ILocalPortForwarder newLocalPortForwarder(String localHost, int localPort, String remoteHost, int remotePort, ServerSocket serverSocket) {
                return this.newLocalPortForwarder(new Parameters(localHost, localPort, remoteHost, remotePort), serverSocket);
            }

            @Override
            public @NonNull ILocalPortForwarder newLocalPortForwarder(Parameters parameters, ServerSocket serverSocket) {
                return ILocalPortForwarder.wrap((LocalPortForwarder)NullChecking.neverNull((Object)session.newLocalPortForwarder(parameters, serverSocket)));
            }

            @Override
            public @NonNull ISFTPClient newSFTPClient() throws IOException {
                return (ISFTPClient)NullChecking.neverNull((Object)ISFTPClient.wrap(session.newSFTPClient()));
            }

            @Override
            public Session startSession() throws ConnectionException, TransportException {
                return (Session)NullChecking.neverNull((Object)session.startSession());
            }
        };
    }

    public void addHostKeyVerifier(HostKeyVerifier var1);

    public void addAlgorithmsVerifier(AlgorithmsVerifier var1);

    public void addHostKeyVerifier(String var1);

    public void auth(String var1, AuthMethod ... var2) throws UserAuthException, TransportException;

    public void auth(String var1, Iterable<AuthMethod> var2) throws UserAuthException, TransportException;

    public void authPassword(String var1, String var2) throws UserAuthException, TransportException;

    public void authPassword(String var1, char[] var2) throws UserAuthException, TransportException;

    public void authPassword(String var1, PasswordFinder var2) throws UserAuthException, TransportException;

    public void authPassword(String var1, PasswordFinder var2, PasswordUpdateProvider var3) throws UserAuthException, TransportException;

    public void authPublickey(String var1) throws UserAuthException, TransportException;

    public void authPublickey(String var1, Iterable<KeyProvider> var2) throws UserAuthException, TransportException;

    public void authPublickey(String var1, KeyProvider ... var2) throws UserAuthException, TransportException;

    public void authPublickey(String var1, String ... var2) throws UserAuthException, TransportException;

    public void setTimeout(int var1);

    public void setConnectTimeout(int var1);

    public void connect(String var1, int var2) throws IOException;

    @Override
    public void close() throws IOException;

    public void disconnect() throws IOException;

    public boolean isConnected();

    public KeyProvider loadKeys(KeyPair var1);

    public KeyProvider loadKeys(String var1) throws IOException;

    public KeyProvider loadKeys(String var1, char[] var2) throws IOException;

    public KeyProvider loadKeys(String var1, PasswordFinder var2) throws IOException;

    public KeyProvider loadKeys(String var1, String var2) throws IOException;

    public KeyProvider loadKeys(String var1, String var2, PasswordFinder var3) throws IOException;

    public void loadKnownHosts() throws IOException;

    public void loadKnownHosts(File var1) throws IOException;

    public @NonNull ILocalPortForwarder newLocalPortForwarder(String var1, int var2, String var3, int var4, ServerSocket var5);

    public @NonNull ILocalPortForwarder newLocalPortForwarder(Parameters var1, ServerSocket var2);

    public @NonNull ISFTPClient newSFTPClient() throws IOException;

    public @NonNull Session startSession() throws ConnectionException, TransportException;

    public static interface ILocalPortForwarder
    extends Closeable {
        public static @NonNull ILocalPortForwarder wrap(final @NonNull LocalPortForwarder localPortForwarder) {
            return new ILocalPortForwarder(){

                @Override
                public void listen(Thread runningThread) throws IOException {
                    localPortForwarder.listen(runningThread);
                }

                @Override
                public void listen() throws IOException {
                    localPortForwarder.listen();
                }

                @Override
                public boolean isRunning() {
                    return localPortForwarder.isRunning();
                }

                @Override
                public void close() throws IOException {
                    localPortForwarder.close();
                }
            };
        }

        public void listen() throws IOException;

        public boolean isRunning();

        public void listen(Thread var1) throws IOException;
    }
}

