/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.ssh.BasicSshDeviceConnection;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SshDeviceConfiguration {
    public static final int PORT = 22;
    private final @NonNull BasicSshDeviceConnection.SshSessionCredentials sessionCredentials;

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull File keyfile, @Nullable String passphrase) throws FileNotFoundException {
        if (!keyfile.exists() || !keyfile.isFile()) {
            throw new FileNotFoundException("PrivateKey file could not be found at path: " + keyfile.getPath());
        }
        this.sessionCredentials = new BasicSshDeviceConnection.SshSessionCredentials(hostname, port, username, null, keyfile);
    }

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull String password) {
        this.sessionCredentials = new BasicSshDeviceConnection.SshSessionCredentials(hostname, port, username, password, null);
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull File keyfile, @Nullable String passphrase) throws FileNotFoundException {
        this(hostname, 22, username, keyfile, passphrase);
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull String password) {
        this(hostname, 22, username, password);
    }

    public @NonNull BasicSshDeviceConnection.SshSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public boolean isRoot() {
        return "root".contentEquals(this.sessionCredentials.username());
    }
}

