/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.ITerminalConnection;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncInputStreamLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.EscapeUtils;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.LineBuffer;
import com.arm.streamline.deviceconn.ssh.BasicSshPortForwarderThread;
import com.arm.streamline.deviceconn.ssh.IBasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.deviceconn.ssh.sshj.ISFTPClient;
import com.arm.streamline.deviceconn.ssh.sshj.ISSHClient;
import com.arm.streamline.deviceconn.ssh.sshj.SSHClientFactory;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BasicSshDeviceConnection
implements IBasicSshDeviceConnection {
    private static final int SSH_TIMEOUT = 6000;
    private final @NonNull SshSessionCredentials sessionCredentials;
    private final @NonNull ISSHClient sshClient;
    private final @NonNull List<@NonNull BasicSshPortForwarderThread> forwardedPorts;
    private final @NonNull TIntIntMap remoteToLocalForward;

    public static boolean test(@NonNull SshDeviceConfiguration configuration) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BasicSshDeviceConnection connection = new BasicSshDeviceConnection(configuration, null, (TIntIntMap)new TIntIntHashMap());){
                String string = connection.getUserHome();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BasicSshDeviceConnection(@NonNull SshDeviceConfiguration configuration, @Nullable File logDirectory, @NonNull TIntIntMap portsToForward) throws IOException {
        this.forwardedPorts = new ArrayList<BasicSshPortForwarderThread>(portsToForward.size());
        this.remoteToLocalForward = new TIntIntHashMap(portsToForward.size(), 1.0f, 0, 0);
        this.sessionCredentials = configuration.getSessionCredentials();
        this.sshClient = SSHClientFactory.createClient();
        try {
            this.sshClient.setConnectTimeout(6000);
            this.sshClient.setTimeout(6000);
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            try {
                this.sshClient.connect(this.sessionCredentials.hostname(), this.sessionCredentials.port());
            }
            catch (UnknownHostException e) {
                throw new UnknownHostException("Could not reach:" + e.getMessage());
            }
            if (this.sessionCredentials.usePassword()) {
                this.sshClient.authPassword(this.sessionCredentials.username(), this.sessionCredentials.password());
            } else {
                KeyProvider keyProvider = this.sshClient.loadKeys(((File)NullChecking.neverNull((Object)this.sessionCredentials.keyFile())).getAbsolutePath());
                this.sshClient.authPublickey(this.sessionCredentials.username(), keyProvider);
            }
            TIntIntIterator it = portsToForward.iterator();
            while (it.hasNext()) {
                it.advance();
                int remote = it.key();
                int local = it.value();
                this.forwardLocalPort(local, remote);
            }
        }
        catch (Throwable t) {
            Throwing.closeAll((Iterable[])new Iterable[]{this.forwardedPorts, Arrays.asList(this.sshClient)});
            throw t;
        }
    }

    @Override
    public int getLocalPortForRemoteForward(int remote) {
        return this.remoteToLocalForward.get(remote);
    }

    @Override
    public int forwardLocalPort(int local, int remote) throws IOException {
        BasicSshPortForwarderThread thread = new BasicSshPortForwarderThread(this.sshClient, "127.0.0.1", local, "127.0.0.1", remote);
        try {
            this.forwardedPorts.add(thread);
            this.remoteToLocalForward.put(remote, thread.getLocalPort());
            return thread.getLocalPort();
        }
        catch (Throwable t) {
            try {
                thread.close();
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sshClient.isConnected()) {
            try {
                this.sshClient.disconnect();
            }
            catch (Throwable throwable) {
                Throwing.closeAll((Iterable[])new Iterable[]{this.forwardedPorts, Arrays.asList(this.sshClient)});
                throw throwable;
            }
            Throwing.closeAll((Iterable[])new Iterable[]{this.forwardedPorts, Arrays.asList(this.sshClient)});
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public @NonNull String getUserHome() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            String string;
            Session.Command cmd;
            Session sshSession;
            block17: {
                block16: {
                    sshSession = this.sshClient.startSession();
                    cmd = sshSession.exec("echo $HOME");
                    cmd.join();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(cmd.getInputStream()));
                    String result = reader.readLine();
                    if (cmd.getExitSignal() != null || result == null) {
                        throw new IOException("Couldn't get home directory for target " + this.sessionCredentials.hostname());
                    }
                    string = result;
                    if (cmd == null) break block16;
                    cmd.close();
                }
                if (sshSession == null) break block17;
                sshSession.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (cmd != null) {
                            cmd.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (sshSession != null) {
                            sshSession.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConnected() {
        return this.sshClient.isConnected();
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull IBasicSshDeviceConnection.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull InteractiveCommand interactiveCommand = this.runInteractiveCommand(wrapMode, command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull InteractiveCommand runInteractiveCommand(@NonNull IBasicSshDeviceConnection.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        assert (wrapMode == IBasicSshDeviceConnection.WrapMode.DEFAULT);
        StringBuilder commandString = new StringBuilder();
        commandString.append(EscapeUtils.escapeArg(command));
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            commandString.append(' ').append(EscapeUtils.escapeArg(argument));
            ++n2;
        }
        Session session = this.sshClient.startSession();
        Session.Command sshCommand = session.exec(commandString.toString());
        if (sshCommand == null) {
            throw new IOException("SSH session couldn't run command: " + commandString.toString());
        }
        return new InteractiveCommand(session, sshCommand);
    }

    private static @NonNull File ensureLocalDir(File localDir) throws IOException {
        if (!localDir.exists() && !localDir.mkdirs()) {
            throw new IOException("Failed to create local directory: " + String.valueOf(localDir));
        }
        return localDir;
    }

    private static void scpPullDir(@NonNull ISFTPClient sftpClient, @NonNull File localDir, @NonNull String remotePath) throws IOException {
        List<RemoteResourceInfo> entries = sftpClient.ls(remotePath);
        for (RemoteResourceInfo entry : entries) {
            String name = entry.getName();
            if (".".equals(name) || "..".equals(name)) continue;
            String childRemote = remotePath.endsWith("/") ? remotePath + name : remotePath + "/" + name;
            File childLocal = new File(localDir, name);
            switch (entry.getAttributes().getMode().getType()) {
                case REGULAR: {
                    BasicSshDeviceConnection.scpPullFile(sftpClient, childLocal, childRemote);
                    break;
                }
                case DIRECTORY: {
                    BasicSshDeviceConnection.scpPullDir(sftpClient, BasicSshDeviceConnection.ensureLocalDir(childLocal), childRemote);
                    break;
                }
            }
        }
    }

    private static void scpPullFile(@NonNull ISFTPClient sftpClient, @NonNull File localFile, @NonNull String remotePath) throws IOException {
        sftpClient.get(remotePath, localFile.getCanonicalPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull File scpPull(boolean recursive, @NonNull File localFile, @NonNull String remotePath) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ISFTPClient sftpClient = this.sshClient.newSFTPClient();){
            FileAttributes attrs = sftpClient.lstat(remotePath);
            FileMode.Type type = attrs.getMode().getType();
            switch (type) {
                case DIRECTORY: {
                    if (localFile.isFile()) {
                        throw new IOException(String.format("SFTP pull failed because remote path (%s) is a directory while local path (%s) is a file", remotePath, localFile.getPath()));
                    }
                    BasicSshDeviceConnection.ensureLocalDir(localFile);
                    if (!recursive) return localFile;
                    BasicSshDeviceConnection.scpPullDir(sftpClient, localFile, remotePath);
                    return localFile;
                }
                case REGULAR: {
                    BasicSshDeviceConnection.scpPullFile(sftpClient, localFile, remotePath);
                    return localFile;
                }
            }
            return localFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public @NonNull String scpPush(@NonNull File localFile, @NonNull String remotePath) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ISFTPClient sftpClient = this.sshClient.newSFTPClient();){
            sftpClient.put(localFile.getCanonicalPath(), remotePath);
            String canonicalRemotePath = sftpClient.canonicalize(remotePath);
            return (String)NullChecking.neverNullOr((Object)canonicalRemotePath, (Object)remotePath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final class InteractiveCommand
    implements IProcessInteractiveCommand {
        private final @NonNull StringBuilder logOut = new StringBuilder();
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdErr;
        private final @NonNull OutputStream processStdIn;
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdOut;
        private final @NonNull LineBuffer stdErrBuffer = new LineBuffer();
        private final @NonNull LineBuffer stdOutBuffer = new LineBuffer();
        private final @NonNull Session session;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Session.Command command;

        private static @NonNull IBasicInteractiveShell.CommandStatus decodeExitStatus(int exitStatus) {
            if ((exitStatus & 0xFF) == exitStatus) {
                return IBasicInteractiveShell.CommandStatus.exited((byte)exitStatus);
            }
            return IBasicInteractiveShell.CommandStatus.unknown("ssh session out of range exit code: " + exitStatus);
        }

        public InteractiveCommand(@NonNull Session session, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Session.Command command) {
            this.processStdIn = (OutputStream)NullChecking.neverNull((Object)command.getOutputStream());
            this.processStdOut = new AsyncInputStreamLineReaderAndLogger("ssh-exec-out", Charset.defaultCharset(), (InputStream)NullChecking.neverNull((Object)command.getInputStream()), null, true, this.stdOutBuffer);
            this.processStdErr = new AsyncInputStreamLineReaderAndLogger("ssh-exec-err", Charset.defaultCharset(), (InputStream)NullChecking.neverNull((Object)command.getErrorStream()), null, true, this.stdErrBuffer);
            this.session = session;
            this.command = command;
        }

        @Override
        public @NonNull List<@NonNull String> collectAllRemainingOutputAndWaitForExit() throws IOException {
            ITerminalConnection.TerminalLine line;
            this.waitForExit();
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdOutBuffer.nextLine()) != null || this.processStdOut.isRunning() || this.processStdErr.isRunning()) {
                if (line != null && line.complete) {
                    result.add(line.line);
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public @Nullable List<@NonNull String> getErrorLines() {
            ITerminalConnection.TerminalLine line;
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdErrBuffer.nextLine()) != null) {
                if (!line.complete) continue;
                result.add(line.line);
            }
            return result;
        }

        @Override
        public @Nullable IBasicInteractiveShell.CommandStatus getExitCode() {
            if (this.isConnected()) {
                return null;
            }
            return InteractiveCommand.decodeExitStatus(NullChecking.neverNullOr((Integer)this.command.getExitStatus(), (int)0));
        }

        @Override
        public @NonNull IBasicInteractiveShell.CommandStatus waitForExitInterruptible() throws InterruptedException {
            while (this.isConnected()) {
                Thread.sleep(100L);
            }
            return InteractiveCommand.decodeExitStatus(NullChecking.neverNullOr((Integer)this.command.getExitStatus(), (int)0));
        }

        @Override
        public boolean isConnected() {
            return this.command.isOpen() || !this.command.isEOF();
        }

        @Override
        public @Nullable ITerminalConnection.TerminalLine nextLine() throws IOException {
            return this.stdOutBuffer.nextLine();
        }

        @Override
        public void send(@NonNull String text) throws IOException {
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN) {
                int nl;
                this.logOut.append(text);
                int from = 0;
                while ((nl = this.logOut.indexOf("\n", from)) >= 0) {
                    System.out.printf("[OUT]: %s%n", this.logOut.substring(from, nl));
                    from = nl + 1;
                }
                if (from > 0) {
                    this.logOut.replace(0, from, "");
                }
            }
            this.processStdIn.write(text.getBytes());
            this.processStdIn.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.command.isOpen()) {
                    this.command.close();
                }
                if (this.session.isOpen()) {
                    this.session.close();
                }
            }
            catch (Throwable throwable) {
                Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
                throw throwable;
            }
            Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
        }

        @Override
        public void interrupt() throws TransportException {
            this.command.signal(Signal.INT);
        }

        @Override
        public void kill() throws TransportException {
            this.command.signal(Signal.KILL);
        }
    }

    public record SshSessionCredentials(@NonNull String hostname, int port, @NonNull String username, @Nullable String password, @Nullable File keyFile) {
        public boolean usePassword() {
            return this.password != null;
        }
    }
}

