/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.lib.ISelfCleaningSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public class AdbSelfCleaningSession
implements ISelfCleaningSession {
    private final @NonNull IAdbCommandRunner.WrapMode wrapMode;
    private final @NonNull IAdbCommandRunner commandRunner;
    private final @NonNull List<Runnable> cleanupActions;
    private final @NonNull Set<String> propertiesTouched;
    private final @NonNull Consumer<String> nonFatalErrorLogger;
    private static final String REMOTE_TMP_ROOT = "/data/local/tmp/";

    public AdbSelfCleaningSession(@NonNull IAdbCommandRunner commandRunner, @NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull Consumer<String> nonFatalErrorLogger) {
        this.commandRunner = commandRunner;
        this.wrapMode = wrapMode;
        this.nonFatalErrorLogger = nonFatalErrorLogger;
        this.cleanupActions = new ArrayList<Runnable>();
        this.propertiesTouched = new HashSet<String>();
    }

    @Override
    public @NonNull ISelfCleaningSession.IRemoteExecutable pushExecutable(@NonNull File exe, @NonNull String name) throws IOException, ISelfCleaningSession.CommandFailedException {
        String packageExePath = this.pushFileAndSetPermissions(exe, name, "0777");
        return new RemoteExecutable(packageExePath);
    }

    @Override
    public @NonNull ISelfCleaningSession.IRemoteExecutable pushExecutable(@NonNull File exe) throws IOException, ISelfCleaningSession.CommandFailedException {
        return this.pushExecutable(exe, exe.getName());
    }

    @Override
    public void pushFile(@NonNull File file, @NonNull String name) throws IOException, ISelfCleaningSession.CommandFailedException {
        this.pushFileAndSetPermissions(file, name, "0666");
    }

    @Override
    public void pushFile(@NonNull File file) throws IOException, ISelfCleaningSession.CommandFailedException {
        this.pushFile(file, file.getName());
    }

    private @NonNull String pushFileAndSetPermissions(@NonNull File file, @NonNull String name, @NonNull String permissions) throws IOException, ISelfCleaningSession.CommandFailedException {
        String remotePath = this.commandRunner.adbPush(file, REMOTE_TMP_ROOT + name);
        this.cleanupActions.add(() -> this.removeRemoteFile(remotePath));
        IBasicInteractiveShell.InteractiveCommandResult chmodResult = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "chmod", permissions, remotePath);
        if (!chmodResult.status.isSuccessful()) {
            throw new ISelfCleaningSession.CommandFailedException("Failed to set permissions of file on remote device", chmodResult);
        }
        return remotePath;
    }

    private void removeRemoteFile(@NonNull String file) {
        try {
            IBasicInteractiveShell.InteractiveCommandResult result = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "rm", "-f", file);
            if (!result.status.isSuccessful()) {
                this.nonFatalErrorLogger.accept("Error removing remote file \"" + file + "\": " + result.errorsAndOutputJoined());
            }
        }
        catch (IOException e) {
            this.nonFatalErrorLogger.accept("Error removing remote file \"" + file + "\": " + e.getMessage());
        }
    }

    public void setProperty(@NonNull String property, @NonNull String value) throws IOException, ISelfCleaningSession.CommandFailedException {
        String originalValue;
        IBasicInteractiveShell.InteractiveCommandResult result;
        if (!this.propertiesTouched.contains(property)) {
            result = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "getprop", property);
            if (!result.status.isSuccessful() || result.output.size() != 1) {
                throw new ISelfCleaningSession.CommandFailedException("Failed to get value of property \"" + property + "\"", result);
            }
            originalValue = result.output.get(0);
            this.propertiesTouched.add(property);
        } else {
            originalValue = null;
        }
        result = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "setprop", property, value);
        if (result.status.isSuccessful()) {
            if (originalValue != null) {
                this.cleanupActions.add(() -> this.restoreProperty(property, originalValue));
            }
        } else {
            throw new ISelfCleaningSession.CommandFailedException("Failed to set value of property \"" + property + "\"", result);
        }
    }

    private void restoreProperty(@NonNull String property, @NonNull String value) {
        String errorMessage = "Error restoring value of property ";
        try {
            IBasicInteractiveShell.InteractiveCommandResult result = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "setprop", property, value);
            if (!result.status.isSuccessful()) {
                this.nonFatalErrorLogger.accept("Error restoring value of property  \"" + property + "\": " + result.errorsAndOutputJoined());
            }
        }
        catch (IOException e) {
            this.nonFatalErrorLogger.accept("Error restoring value of property  \"" + property + "\": " + e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanUp(() -> {});
    }

    @Override
    public int getNumberOfCleanUpActions() {
        return this.cleanupActions.size();
    }

    @Override
    public void cleanUp(Runnable actionCallback) {
        for (Runnable action : this.cleanupActions) {
            action.run();
            actionCallback.run();
        }
        this.cleanupActions.clear();
    }

    private class RemoteExecutable
    implements ISelfCleaningSession.IRemoteExecutable {
        private final @NonNull String exePath;

        private RemoteExecutable(String exePath) {
            this.exePath = exePath;
        }

        @Override
        public @NonNull IInteractiveCommand runExe(String ... args) throws IOException {
            return AdbSelfCleaningSession.this.commandRunner.runInteractiveCommand(AdbSelfCleaningSession.this.wrapMode, this.exePath, args);
        }

        @Override
        public @NonNull String getPath() {
            return this.exePath;
        }
    }
}

