/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.AdbPackageCommandRunner;
import com.arm.streamline.deviceconn.adb.AdbProcessRunner;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbPackageCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.adb.utils.AdbRedirects;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.EscapeUtils;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.ITerminalWrapperCommandRunner;
import com.arm.streamline.deviceconn.lib.TerminalWrapperCommandRunner;
import com.arm.streamline.deviceconn.lib.TerminalWrapperConstants;
import com.arm.streamline.deviceconn.lib.TerminalWrapperDecoderInteractiveCommandAdapter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiFunction;
import com.arm.utils.function.IThrowingBiPredicate;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingPredicate;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.io.FileUtils;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AdbCommandRunner
implements IAdbCommandRunner {
    protected static final @NonNull String DATA_LOCAL_TMP = "/data/local/tmp";
    protected static final @NonNull String TERMINAL_WRAPPER = "terminal_wrapper";
    protected static final @NonNull String TERMINAL_WRAPPER_CMD = "/data/local/tmp/terminal_wrapper";
    private static final @NonNull Object wrapperSetupLock = new Object();
    private final @NonNull IAdbProcessRunner commandRunner;
    private @Nullable AdbDeviceRootMode detectedRootMode = null;
    private final @NonNull Object detectedRootModeLock = new Object();
    private final @NonNull String deviceSerial;
    private final @NonNull ITerminalWrapperCommandRunner<IAdbCommandRunner.WrapMode> terminalWrapperCommandRunner;

    public static @NonNull IBasicInteractiveShell.InteractiveCommandResult adbRunCommandAndGetOutput(@NonNull IAdbProcessRunner commandRunner, @NonNull String deviceSerial, @NonNull String command, String ... arguments) throws IOException {
        @NonNull String @NonNull [] args = new String[arguments.length + 3];
        args[0] = "-s";
        args[1] = deviceSerial;
        args[2] = command;
        System.arraycopy(arguments, 0, args, 3, arguments.length);
        return commandRunner.runCommandAndGetOutput(args);
    }

    protected static @NonNull IProcessInteractiveCommand runWrappedCommand(@NonNull IAdbProcessRunner commandRunner, @NonNull String deviceSerial, @NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        return commandRunner.runInteractiveCommand(AdbCommandRunner.makeCommandAndArguments(deviceSerial, wrapMode, command, arguments));
    }

    private static @NonNull String @NonNull [] injectSu0(@NonNull String command, String ... arguments) {
        @NonNull String @NonNull [] result = new String[2 + arguments.length];
        result[0] = "0";
        result[1] = command;
        System.arraycopy(arguments, 0, result, 2, arguments.length);
        return result;
    }

    private static @NonNull String @NonNull [] injectSuC(@NonNull String command, String ... arguments) {
        @NonNull String @NonNull [] result = new String[2 + arguments.length];
        result[0] = "-c";
        result[1] = command;
        System.arraycopy(arguments, 0, result, 2, arguments.length);
        return result;
    }

    private static @NonNull String @NonNull [] makeCommandAndArguments(@NonNull String deviceSerial, @NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull String command, String ... arguments) {
        if (switch (wrapMode) {
            case IAdbCommandRunner.WrapMode.PLAIN -> false;
            case IAdbCommandRunner.WrapMode.DEFAULT -> true;
            case IAdbCommandRunner.WrapMode.SU_0 -> {
                arguments = AdbCommandRunner.injectSu0(command, arguments);
                command = "su";
                yield true;
            }
            case IAdbCommandRunner.WrapMode.SU_C -> {
                arguments = AdbCommandRunner.injectSuC(command, arguments);
                command = "su";
                yield true;
            }
            default -> throw new AssertionError((Object)wrapMode);
        }) {
            @NonNull String cmdString = EscapeUtils.escapeAdbShellExecArg(command, arguments);
            @NonNull String @NonNull [] result = new String[]{"-s", deviceSerial, "shell", TERMINAL_WRAPPER_CMD, "-d", DATA_LOCAL_TMP, "sh", "-c", cmdString};
            return result;
        }
        @NonNull String @NonNull [] result = new String[7 + arguments.length];
        result[0] = "-s";
        result[1] = deviceSerial;
        result[2] = "shell";
        result[3] = TERMINAL_WRAPPER_CMD;
        result[4] = "-d";
        result[5] = DATA_LOCAL_TMP;
        result[6] = command;
        System.arraycopy(arguments, 0, result, 7, arguments.length);
        return result;
    }

    private static  @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller makeKiller(final @NonNull IAdbCommandRunner.WrapMode wrapMode, final @NonNull IAdbProcessRunner commandRunner, final @NonNull String deviceSerial, final @NonNull IProcessInteractiveCommand command) {
        return new TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller(){

            @Override
            public void interrupt(int pid) throws Exception {
                if (pid == 0) {
                    command.interrupt();
                } else {
                    switch (wrapMode) {
                        case DEFAULT: 
                        case PLAIN: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "kill", Integer.toString(pid));
                            break;
                        }
                        case SU_0: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "0", "kill", Integer.toString(pid));
                            break;
                        }
                        case SU_C: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "-c", "kill", Integer.toString(pid));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)wrapMode);
                        }
                    }
                }
            }

            @Override
            public void kill(int pid) throws Exception {
                if (pid == 0) {
                    command.kill();
                } else {
                    switch (wrapMode) {
                        case DEFAULT: 
                        case PLAIN: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "kill", "-9", Integer.toString(-pid));
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "kill", "-9", Integer.toString(pid));
                            break;
                        }
                        case SU_0: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "0", "kill", "-9", Integer.toString(-pid));
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "0", "kill", "-9", Integer.toString(pid));
                            break;
                        }
                        case SU_C: {
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "-c", "kill", "-9", Integer.toString(-pid));
                            AdbCommandRunner.adbRunCommandAndGetOutput(commandRunner, deviceSerial, "shell", "su", "-c", "kill", "-9", Integer.toString(pid));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)wrapMode);
                        }
                    }
                }
            }
        };
    }

    public AdbCommandRunner(@NonNull File adbPath, @NonNull String deviceSerial) throws IOException {
        this(adbPath, deviceSerial, new File(System.getProperty("user.home")), null);
    }

    public AdbCommandRunner(@NonNull File adbPath, @NonNull String deviceSerial, @NonNull File workingDirectory, @Nullable File logDirectory) throws IOException {
        this(new AdbProcessRunner(adbPath, workingDirectory, logDirectory), deviceSerial);
    }

    public AdbCommandRunner(@NonNull IAdbProcessRunner commandRunner, @NonNull String deviceSerial) throws IOException {
        this(commandRunner, deviceSerial, new TerminalWrapperCommandRunner<IAdbCommandRunner.WrapMode, IProcessInteractiveCommand>((wrapMode, command, arguments) -> AdbCommandRunner.runWrappedCommand(commandRunner, deviceSerial, wrapMode, command, arguments), (wrapMode, command) -> AdbCommandRunner.makeKiller(wrapMode, commandRunner, deviceSerial, command)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AdbCommandRunner(@NonNull IAdbProcessRunner commandRunner, @NonNull String deviceSerial, @NonNull ITerminalWrapperCommandRunner<IAdbCommandRunner.WrapMode> terminalWrapperCommandRunner) throws IOException {
        this.deviceSerial = deviceSerial;
        this.commandRunner = commandRunner;
        this.terminalWrapperCommandRunner = terminalWrapperCommandRunner;
        Object object = wrapperSetupLock;
        synchronized (object) {
            String failure = TerminalWrapperConstants.pushTerminalWrapper(TERMINAL_WRAPPER_CMD, (IThrowingSupplier<IBasicInteractiveShell.InteractiveCommandResult, IOException>)((IThrowingSupplier)() -> this.adbRunCommandAndGetOutput("shell", "uname", "-m")), (IThrowingFunction<File, String, IOException>)((IThrowingFunction)this::pushAsTempFile), (IThrowingPredicate<String, IOException>)((IThrowingPredicate)d -> this.adbRunCommandAndGetOutput((String)"shell", (String[])new String[]{"chmod", "755", d}).status.isSuccessful()), (IThrowingBiPredicate<String, String, IOException>)((IThrowingBiPredicate)(t, d) -> this.adbRunCommandAndGetOutput((String)"shell", (String[])new String[]{"mv", t, d}).status.isSuccessful()));
            if (failure != null) {
                throw new IOException("Failed to setup terminal wrapper on " + deviceSerial + " - " + failure);
            }
        }
    }

    @Override
    public @NonNull File adbPull(boolean recursive, @NonNull File localFile, @NonNull String remotePath) throws IOException {
        if (recursive && !localFile.mkdirs() && !localFile.isDirectory()) {
            throw new FileNotFoundException(String.format("%s is not a directory", localFile.getAbsolutePath()));
        }
        if (remotePath.endsWith("/") && !recursive) {
            throw new FileNotFoundException(String.format("%s is not a file path", remotePath));
        }
        if (!remotePath.startsWith("/")) {
            remotePath = String.format("%s/%s", DATA_LOCAL_TMP, remotePath);
        }
        @NonNull String cannonicalPath = FileUtils.canonicalisePath((File)localFile);
        @NonNull IBasicInteractiveShell.InteractiveCommandResult result = this.adbRunCommandAndGetOutput("pull", remotePath, cannonicalPath);
        if (!result.status.isSuccessful()) {
            throw new AdbCommandIOException(String.format("adb pull '%s' '%s' failed", remotePath, cannonicalPath), result);
        }
        if (localFile.isDirectory() && !remotePath.endsWith("/")) {
            @NonNull File remotePathFile = new File(remotePath);
            return new File(localFile, remotePathFile.getName());
        }
        return localFile;
    }

    @Override
    public @NonNull String adbPush(@NonNull File localFile, @NonNull String remotePath) throws IOException {
        @NonNull String cannonicalPath = FileUtils.canonicalisePath((File)localFile);
        @NonNull IBasicInteractiveShell.InteractiveCommandResult result = this.adbRunCommandAndGetOutput("push", cannonicalPath, remotePath);
        if (!result.status.isSuccessful()) {
            throw new AdbCommandIOException(String.format("adb push '%s' '%s' failed", cannonicalPath, remotePath), result);
        }
        return remotePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull AdbDeviceRootMode detectRootMode() throws IOException {
        Object object = this.detectedRootModeLock;
        synchronized (object) {
            AdbDeviceRootMode detectedRootMode = this.detectedRootMode;
            if (detectedRootMode == null) {
                this.detectedRootMode = detectedRootMode = IAdbCommandRunner.detectRootMode(this);
            }
            return detectedRootMode;
        }
    }

    @Override
    public @NonNull IAdbProcessRunner getAdbProcessRunner() {
        return this.commandRunner;
    }

    @Override
    public @NonNull String getDeviceSerial() {
        return this.deviceSerial;
    }

    @Override
    public boolean isRootAs(@NonNull IAdbCommandRunner.WrapMode wrapMode) throws IOException {
        switch (wrapMode) {
            case DEFAULT: 
            case PLAIN: {
                AdbDeviceRootMode rootMode = this.detectRootMode();
                switch (rootMode) {
                    case DEFAULTS_TO_ROOT: {
                        return true;
                    }
                    case NONE: 
                    case USE_SU_0: 
                    case USE_SU_C: {
                        return false;
                    }
                }
                throw new AssertionError((Object)rootMode);
            }
            case SU_0: 
            case SU_C: {
                return true;
            }
        }
        throw new AssertionError((Object)wrapMode);
    }

    @Override
    public @Nullable String pushAsTempFile(@NonNull File localFile) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult tempPath = this.adbRunCommandAndGetOutput("shell", "mktemp", "-q", "-p", DATA_LOCAL_TMP);
        if (!tempPath.status.isSuccessful()) {
            return null;
        }
        if (tempPath.output.size() != 1) {
            return null;
        }
        return this.adbPush(localFile, tempPath.output.get(0));
    }

    @Override
    public @NonNull IAdbPackageCommandRunner runAs(final @NonNull String packageName) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult cpWrapperResult = this.runCommandAndGetOutput(IAdbCommandRunner.WrapMode.PLAIN, "run-as", packageName, "cp", TERMINAL_WRAPPER_CMD, ".");
        if (!cpWrapperResult.status.isSuccessful()) {
            throw new AdbCommandIOException("run-as " + packageName + " cp /data/local/tmp/terminal_wrapper .", cpWrapperResult);
        }
        IBasicInteractiveShell.InteractiveCommandResult pwdResult = this.runCommandAndGetOutput(IAdbCommandRunner.WrapMode.PLAIN, "run-as", packageName, "pwd");
        if (pwdResult.output.isEmpty() || !pwdResult.status.isSuccessful()) {
            throw new AdbCommandIOException("run-as " + packageName + " pwd", pwdResult);
        }
        String packageDirectory = pwdResult.output.get(0);
        String terminalWrapperCommand = String.format("%s/%s", packageDirectory, TERMINAL_WRAPPER);
        TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller remoteKiller = new TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller(){

            @Override
            public void interrupt(int pid) throws Exception {
                if (!$assertionsDisabled && pid == 0) {
                    throw new AssertionError();
                }
                AdbCommandRunner.adbRunCommandAndGetOutput(AdbCommandRunner.this.commandRunner, AdbCommandRunner.this.deviceSerial, "shell", "run-as", packageName, "kill", Integer.toString(pid));
            }

            @Override
            public void kill(int pid) throws Exception {
                if (!$assertionsDisabled && pid == 0) {
                    throw new AssertionError();
                }
                AdbCommandRunner.adbRunCommandAndGetOutput(AdbCommandRunner.this.commandRunner, AdbCommandRunner.this.deviceSerial, "shell", "run-as", packageName, "kill", "-9", Integer.toString(-pid));
                AdbCommandRunner.adbRunCommandAndGetOutput(AdbCommandRunner.this.commandRunner, AdbCommandRunner.this.deviceSerial, "shell", "run-as", packageName, "kill", "-9", Integer.toString(pid));
            }
        };
        return new AdbPackageCommandRunner(packageName, packageDirectory, terminalWrapperCommand, remoteKiller, (IThrowingBiFunction<String, String[], IProcessInteractiveCommand, IOException>)((IThrowingBiFunction)(c, a) -> this.runInteractiveCommand(IAdbCommandRunner.WrapMode.PLAIN, (String)c, (String)a)));
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull String command, String ... arguments) throws IOException {
        return this.runCommandAndGetOutput(IAdbCommandRunner.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommand(wrapMode, command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull String command, String ... arguments) throws IOException {
        return this.runCommandAndGetOutputAsStream(IAdbCommandRunner.WrapMode.DEFAULT, stdOutConsumerFactory, command, arguments);
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runCommandAndGetOutputAsStream(wrapMode, stdOutConsumerFactory, command, arguments);
    }

    @Override
    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull String command, String ... arguments) throws IOException {
        return this.runCommandAsync(IAdbCommandRunner.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runCommandAsync(wrapMode, command, arguments);
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull String command, String ... arguments) throws IOException {
        return this.runInteractiveCommand(IAdbCommandRunner.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runInteractiveCommand(wrapMode, command, arguments);
    }

    @Override
    public void setPortForwards(@NonNull TIntIntMap portsToForward) throws IOException {
        AdbRedirects.removeAllForDevice(this.commandRunner, this.deviceSerial);
        TIntIntIterator it = portsToForward.iterator();
        while (it.hasNext()) {
            it.advance();
            int remote = it.key();
            int local = it.value();
            AdbRedirects.forward(this.commandRunner, this.deviceSerial, local, remote);
        }
    }

    private @NonNull IBasicInteractiveShell.InteractiveCommandResult adbRunCommandAndGetOutput(@NonNull String command, String ... arguments) throws IOException {
        return AdbCommandRunner.adbRunCommandAndGetOutput(this.commandRunner, this.deviceSerial, command, arguments);
    }
}

