/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ITerminalConnection
extends Closeable {
    public boolean isConnected();

    public @Nullable TerminalLine nextLine() throws IOException;

    default public @Nullable TerminalLine nextLineOrWait() throws IOException {
        @Nullable TerminalLine result = this.nextLine();
        if (result == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    public void send(@NonNull String var1) throws IOException;

    default public void sendfmt(@NonNull String fmt, Object ... objects) throws IOException {
        this.send(String.format(fmt, objects));
    }

    default public void sendln() throws IOException {
        this.send("\n");
    }

    default public void sendln(@NonNull String line) throws IOException {
        this.send(line);
        this.sendln();
    }

    default public @NonNull TerminalLine waitForCompleteLine() throws IOException {
        TerminalLine line;
        do {
            line = this.waitForNextLine();
        } while (!line.complete);
        return line;
    }

    default public @NonNull TerminalLine waitForLineContaining(boolean allowPartials, @NonNull String text) throws IOException {
        TerminalLine line;
        do {
            line = this.waitForNextLine();
        } while (!line.complete && !allowPartials || !line.line.contains(text));
        return line;
    }

    default public @NonNull TerminalLine waitForLineEquals(boolean allowPartials, @NonNull String text) throws IOException {
        TerminalLine line;
        do {
            line = this.waitForNextLine();
        } while (!line.complete && !allowPartials || !line.line.equals(text));
        return line;
    }

    default public @NonNull TerminalLine waitForLineMatching(boolean allowPartials, @NonNull Pattern pattern, boolean matches) throws IOException {
        return this.waitForLineMatching(allowPartials, pattern, matches, null);
    }

    default public @NonNull TerminalLine waitForLineMatching(boolean allowPartials, @NonNull Pattern pattern, boolean matches, @Nullable Consumer<@NonNull Matcher> matcherConsumer) throws IOException {
        return this.waitForLineMatching(allowPartials, pattern, matches, matcherConsumer, null);
    }

    default public @NonNull TerminalLine waitForLineMatching(boolean allowPartials, @NonNull Pattern pattern, boolean matches, @Nullable Consumer<@NonNull Matcher> matcherConsumer, @Nullable IWaitForLineDelayConsumer delayConsumer) throws IOException {
        long timeDelta;
        TerminalLine line;
        long startTime = System.nanoTime();
        do {
            line = this.waitForNextLine();
            @NonNull Matcher matcher = pattern.matcher(line.line);
            if (!line.complete && !allowPartials || (!matches || !matcher.matches()) && (matches || !matcher.find())) continue;
            if (matcherConsumer != null) {
                matcherConsumer.accept(matcher);
            }
            return line;
        } while (delayConsumer == null || !delayConsumer.stillWaiting(line, timeDelta = System.nanoTime() - startTime));
        return line;
    }

    default public @NonNull TerminalLine waitForNextLine() throws IOException {
        while (this.isConnected()) {
            @Nullable TerminalLine result = this.nextLineOrWait();
            if (result == null) continue;
            return result;
        }
        throw new EOFException();
    }

    @FunctionalInterface
    public static interface IWaitForLineDelayConsumer {
        public boolean stillWaiting(@NonNull TerminalLine var1, long var2) throws IOException;
    }

    public static final class TerminalLine {
        public final boolean complete;
        public final @NonNull String line;

        public TerminalLine(boolean complete, @NonNull String line) {
            this.complete = complete;
            this.line = line;
        }
    }
}

