/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractSpeEventProperties
implements Comparable<SpeFilterEventProperties> {
    private final @NonNull String speEventName;
    private final @Nullable String description;
    private final int bitPosition;
    private final @NonNull Set<@NonNull ValidOpType> validOpTypes;
    public static final int MAX_BIT_POSITION = 63;

    public AbstractSpeEventProperties(@NonNull String speEventName, String description, int bitPosition, @NonNull Set<@NonNull ValidOpType> validOpTypes) {
        this.speEventName = speEventName;
        this.description = description;
        if (bitPosition < 0 || bitPosition > 63) {
            throw new IllegalArgumentException("Bit position is only in the range from 0 - 63");
        }
        this.bitPosition = bitPosition;
        this.validOpTypes = validOpTypes;
    }

    public @NonNull String getName() {
        return this.speEventName;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    public String toString() {
        return this.speEventName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSpeEventProperties)) {
            return false;
        }
        AbstractSpeEventProperties that = (AbstractSpeEventProperties)obj;
        return that.getBitPosition() == this.getBitPosition();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.getBitPosition();
        return result;
    }

    @Override
    public int compareTo(SpeFilterEventProperties event) {
        return this.getName().compareTo(event.getName());
    }

    public @NonNull Set<@NonNull ValidOpType> getValidOpTypes() {
        return Collections.unmodifiableSet(this.validOpTypes);
    }

    public static final class ValidOpType {
        public final @NonNull SpeOperationTypeClass opTypeClass;
        public final byte subclassMask;
        public final byte subclassTest;

        public ValidOpType(@NonNull SpeOperationTypeClass opTypeClass, byte subclassTest, byte subclassMask) {
            if ((byte)(subclassTest & subclassMask) != subclassTest) {
                throw new IllegalArgumentException(String.format("operation type subclass test (%s) should not have any bits set out side of the mask (%s)", Integer.toBinaryString(Byte.toUnsignedInt(subclassTest)), Integer.toBinaryString(Byte.toUnsignedInt(subclassMask))));
            }
            this.opTypeClass = opTypeClass;
            this.subclassTest = subclassTest;
            this.subclassMask = subclassMask;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ValidOpType) {
                ValidOpType that = (ValidOpType)obj;
                return this.opTypeClass == that.opTypeClass && this.subclassTest == that.subclassTest && this.subclassMask == that.subclassMask;
            }
            return false;
        }

        public int hashCode() {
            return (this.opTypeClass.hashCode() * 31 + this.subclassTest) * 31 + this.subclassMask;
        }

        public String toString() {
            return String.format("{%s 0x%02x & 0x%02x}", new Object[]{this.opTypeClass, this.subclassTest, this.subclassMask});
        }

        public boolean matches(@NonNull SpeOperationTypeClass opTypeClass, byte subClass) {
            return opTypeClass == this.opTypeClass && (subClass & this.subclassMask) == this.subclassTest;
        }
    }
}

