/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeParsingException;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.common.xml.spe.SpeXMLParser;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class Events {
    private static final String GPU_TIMELINE_CATEGORY_NAME = "Mali Timeline";
    private final @NonNull List<@NonNull Category> categories;
    private final @NonNull Map<@NonNull String, @NonNull StockCounter.Combination> sourceNameToCombinationMap = new HashMap<String, StockCounter.Combination>();
    private final @NonNull Map<String, StockCounter> stockCounterMap = new HashMap<String, StockCounter>();
    private final @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap;
    private @NonNull Optional<@NonNull String> maliDdkVersion = Optional.empty();

    public Events() {
        this(Collections.emptyList(), Collections.emptyMap());
    }

    public Events(@NonNull List<@NonNull Category> categories, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap) {
        this.categories = categories;
        this.speTargetDescritionMap = speTargetDescritionMap;
        categories.stream().flatMap(Collection::stream).forEach(counter -> {
            for (String key : counter.getAllTargetCountersKeys()) {
                if (this.stockCounterMap.put(key, (StockCounter)counter) == null || key.startsWith("ARM_ARM11MPCore_cnt")) continue;
                CommonPlugin.error(String.format("Key collision for '%s'", key));
            }
            counter.getAllCombinations().forEach(combo -> {
                this.sourceNameToCombinationMap.put(combo.getUniqueSourceName(), (StockCounter.Combination)combo);
                combo.getActivityAliases().forEach(a -> {
                    StockCounter.Combination combination2 = this.sourceNameToCombinationMap.put((String)a, (StockCounter.Combination)combo);
                });
            });
        });
        this.grabDdkVersionFromCategories();
    }

    public static @NonNull Events createWithAllEventsWithoutClusterInfo(@NonNull InputStream ins) throws IOException {
        return Events.create(ins, c -> true, s -> true, (TIntObjectMap<String>)new TIntObjectHashMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @NonNull Events create(@NonNull InputStream ins, @NonNull Predicate<@NonNull String> validCounterPredicate, @NonNull Predicate<@NonNull String> validSpesPredicate, @NonNull TIntObjectMap<String> clusters) throws IOException {
        HashMap<String, CounterSet> counterSets = new HashMap<String, CounterSet>();
        @NonNull ArrayList<@NonNull Category> categories = new ArrayList<Category>();
        @NonNull HashMap<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap = new HashMap<String, SpeTargetDescription>();
        Throwable throwable = null;
        Object var8_9 = null;
        try (XMLParser in = new XMLParser(ins);){
            block11: while (true) {
                String tag;
                if ((tag = in.nextTag()) == null) {
                    try {
                        @NonNull Consumer<@NonNull Throwable> errorHandler = e -> CommonPlugin.error(e);
                        SpeXMLParser.validate(speTargetDescritionMap, errorHandler);
                    }
                    catch (SpeParsingException exception) {
                        CommonPlugin.error(exception.getMessage());
                    }
                    break;
                }
                if ("events".equals(tag)) {
                    String marker = in.getMarker();
                    while (true) {
                        if ((tag = in.nextTag(marker)) == null) continue block11;
                        if ("counter_set".equals(tag)) {
                            try {
                                CounterSet set = new CounterSet(in, validCounterPredicate);
                                if (set.isEmpty()) continue;
                                counterSets.put(set.getName(), set);
                            }
                            catch (BadXmlException exception) {
                                CommonPlugin.error(exception);
                            }
                            continue;
                        }
                        if ("category".equals(tag)) {
                            Category category = new Category(in, validCounterPredicate, counterSets, clusters);
                            if (category.isEmpty()) continue;
                            categories.add(category);
                            continue;
                        }
                        if ("spe".equals(tag)) {
                            try {
                                SpeTargetDescription speHardwareConfiguration = SpeXMLParser.parseSpeEventsXML(in, speTargetDescritionMap, validSpesPredicate);
                                speTargetDescritionMap.put(speHardwareConfiguration.getId(), speHardwareConfiguration);
                            }
                            catch (SpeParsingException exception) {
                                CommonPlugin.error(exception.getMessage());
                            }
                            continue;
                        }
                        in.skip();
                    }
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        Collections.sort(categories);
        return new Events(categories, speTargetDescritionMap);
    }

    public @NonNull List<@NonNull Category> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public @NonNull Map<@NonNull String, @NonNull StockCounter.Combination> getSourceToComboMap() {
        return Collections.unmodifiableMap(this.sourceNameToCombinationMap);
    }

    public @NonNull Map<String, StockCounter> getStockCounterMap() {
        return Collections.unmodifiableMap(this.stockCounterMap);
    }

    public @NonNull String getUniqueDisplayTitle(@NonNull StockCounter counter, boolean perCategory) {
        return this.makeUniqueDisplayTitle(counter.getDisplayTitle(), counter, perCategory);
    }

    public @NonNull String getUniqueDisplayTitle(@NonNull TargetCounter counter, boolean perCategory) {
        return this.makeUniqueDisplayTitle(counter.getDisplayTitle(), counter.getDerivedFrom(), perCategory);
    }

    public boolean hasEbsCounter() {
        return this.categories.stream().flatMap(Collection::stream).anyMatch(StockCounter::supportsEventBasedSampling);
    }

    private @NonNull String makeUniqueDisplayTitle(@NonNull String displayTitle, @NonNull StockCounter counter, boolean perCategory) {
        boolean hasDeviceInstance;
        @NonNull String stockDisplayTitle = counter.getDisplayTitle();
        Stream<@NonNull Category> categories = perCategory ? Stream.of(counter.getCategory()) : this.categories.stream();
        boolean isDuplicate = categories.flatMap(Collection::stream).anyMatch(s -> s.getDisplayTitle().equals(stockDisplayTitle) && !s.equals(counter));
        String cluster = counter.getCluster();
        String deviceInstance = counter.getDeviceInstance();
        boolean hasCluster = cluster != null && !cluster.isEmpty();
        boolean bl = hasDeviceInstance = deviceInstance != null && !deviceInstance.isEmpty();
        assert (!hasCluster || !hasDeviceInstance || NullChecking.equalsNullable((Object)cluster, (Object)deviceInstance));
        if (isDuplicate && hasCluster) {
            StringBuilder buffer = new StringBuilder(displayTitle);
            buffer.append(" (");
            buffer.append(cluster);
            buffer.append(")");
            return buffer.toString();
        }
        if (isDuplicate && hasDeviceInstance) {
            StringBuilder buffer = new StringBuilder(displayTitle);
            buffer.append(" (");
            buffer.append(hasDeviceInstance);
            buffer.append(")");
            return buffer.toString();
        }
        return displayTitle;
    }

    public @NonNull Collection<@NonNull SpeTargetDescription> getAvailableSpeTargetDescriptions() {
        return Collections.unmodifiableList(this.speTargetDescritionMap.values().stream().filter(spe -> spe.isAvailableInTarget()).collect(Collectors.toList()));
    }

    public @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> getAllSpeTargetDescriptions() {
        return Collections.unmodifiableMap(this.speTargetDescritionMap);
    }

    public @NonNull Map<@NonNull String, @NonNull TIntSet> getSourceToClusterIdMap() {
        HashMap<@NonNull String, @NonNull TIntSet> sourceToClusterIdMap = new HashMap<String, TIntSet>();
        this.getCategories().stream().flatMap(Collection::stream).filter(c -> c.getClusterId() != null).flatMap(StockCounter::getAllCombinations).forEach(combo -> sourceToClusterIdMap.computeIfAbsent(combo.getUniqueSourceNameIgnoringCluster(), ignore -> new TIntHashSet()).add(((Integer)NullChecking.neverNull((Object)combo.stockCounter.getClusterId())).intValue()));
        return sourceToClusterIdMap;
    }

    public void grabDdkVersionFromCategories() {
        for (Category category : this.categories) {
            if (!GPU_TIMELINE_CATEGORY_NAME.equals(category.getName())) continue;
            this.maliDdkVersion = Optional.ofNullable(category.getMaliDdkVersion());
        }
    }

    public @NonNull Optional<@NonNull String> getMaliDdkVersion() {
        return this.maliDdkVersion;
    }
}

