/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.text;

import com.arm.utils.NullChecking;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaMethodNameDemangler {
    private static final Pattern OUTER_CLASS_NAME = Pattern.compile("L(.+?);.+?\\(");
    private static final Pattern ARGUMENT_CLASS_NAME = Pattern.compile("L(.+?);");
    private static final Pattern METHOD_NAME = Pattern.compile(";(.+)\\(");
    private static final Pattern ARGUMENTS = Pattern.compile("\\((.*?)\\)");

    public static boolean matchesMangledJavaSignature(String sig) {
        return sig.matches("L.+?;.+?\\(.*?\\).+");
    }

    private static String parseSymbol(String symbol) throws IllegalArgumentException {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        char[] cArray = chars = symbol.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '[': {
                    sb.append("[]");
                    break;
                }
                case 'I': {
                    sb.insert(0, "int");
                    break;
                }
                case 'C': {
                    sb.insert(0, "char");
                    break;
                }
                case 'S': {
                    sb.insert(0, "short");
                    break;
                }
                case 'B': {
                    sb.insert(0, "byte");
                    break;
                }
                case 'J': {
                    sb.insert(0, "long");
                    break;
                }
                case 'F': {
                    sb.insert(0, "float");
                    break;
                }
                case 'D': {
                    sb.insert(0, "double");
                    break;
                }
                case 'Z': {
                    sb.insert(0, "boolean");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unexpected character: '%c' in the perf Java method argument symbol: %s", Character.valueOf(c), symbol));
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String parseMethodSignature(String sig) throws IllegalArgumentException {
        Matcher classMatcher = OUTER_CLASS_NAME.matcher(sig);
        Matcher methodMatcher = METHOD_NAME.matcher(sig);
        Matcher argMatcher = ARGUMENTS.matcher(sig);
        if (!(classMatcher.find() && methodMatcher.find() && argMatcher.find())) {
            throw new IllegalArgumentException(String.format("Invalid method signature: %s", sig));
        }
        StringBuilder sb = new StringBuilder("class " + classMatcher.group(1) + " " + methodMatcher.group(1) + "(");
        String args = (String)NullChecking.neverNull((Object)argMatcher.group(1));
        char[] chars = args.toCharArray();
        Object symbol = "";
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '[') {
                symbol = (String)symbol + c;
            } else if (c == 'L') {
                StringBuilder classBuilder = new StringBuilder();
                try {
                    while (c != ';') {
                        c = chars[i];
                        classBuilder.append(c);
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException(String.format("Invalid method signature (classname argument should be terminated by ;): %s", sig));
                }
                Matcher argClassMatcher = ARGUMENT_CLASS_NAME.matcher(classBuilder.toString());
                if (!argClassMatcher.find()) {
                    throw new IllegalArgumentException(String.format("Invalid method signature (unrecognised argument): %s", sig));
                }
                sb.append(argClassMatcher.group(1));
                if (((String)symbol).contains("[")) {
                    char[] symChars;
                    char[] cArray = symChars = ((String)symbol).toCharArray();
                    int n = symChars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char symChar = cArray[n2];
                        if (symChar == '[') {
                            sb.append("[]");
                        }
                        ++n2;
                    }
                    symbol = "";
                }
                if (i >= chars.length - 1) break;
                sb.append(", ");
                --i;
            } else {
                String parsed = JavaMethodNameDemangler.parseSymbol((String)(symbol = (String)symbol + c));
                if (parsed.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Unrecognised symbol in Java method name: %s", symbol));
                }
                sb.append(JavaMethodNameDemangler.parseSymbol((String)symbol));
                if (i == chars.length - 1) break;
                sb.append(", ");
                symbol = "";
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

