/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.model.VariableReplacerConstants;
import com.arm.streamline.common.model.chart.ActivityChartUtils;
import com.arm.streamline.common.model.chart.SeriesAliasUtils;
import com.arm.streamline.common.model.chart.SeriesComparator;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.ModelMessages;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiFunction;
import com.arm.utils.text.BasicTextFilter;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterRecord
implements Comparable<CounterRecord> {
    private static final @NonNull String ATTR_ACTIVITY = "activity";
    private static final @NonNull String ATTR_ACTIVITY_COLOR = "activity_color";
    private static final @NonNull String ATTR_ALIGNMENT = "alignment";
    private static final @NonNull String ATTR_ARG = "arg";
    private static final @NonNull String ATTR_AVERAGE_CORES = "average_cores";
    private static final @NonNull String ATTR_AVERAGE_SELECTION = "average_selection";
    private static final @NonNull String ATTR_CLASS = "class";
    private static final @NonNull String ATTR_CLUSTER = "cluster";
    private static final @NonNull String ATTR_COLOR = "color";
    private static final @NonNull String ATTR_CORES = "cores";
    private static final @NonNull String ATTR_COUNT = "count";
    private static final @NonNull String ATTR_COUNTER = "counter";
    private static final @NonNull String ATTR_DERIVED = "derived";
    private static final @NonNull String ATTR_DESCRIPTION = "description";
    private static final @NonNull String ATTR_DEVICE_INSTANCE = "device_instance";
    private static final @NonNull String ATTR_DISPLAY = "display";
    private static final @NonNull String ATTR_DYNAMIC = "dynamic";
    private static final @NonNull String ATTR_EVENT = "event";
    private static final @NonNull String ATTR_EXPRESSION = "expression";
    private static final @NonNull String ATTR_FROM_FTRACE = "from_ftrace";
    private static final @NonNull String ATTR_HIDE_BY_DEFAULT = "hide_by_default";
    private static final @NonNull String ATTR_HIGH_RESOLUTION = "high_resolution";
    private static final @NonNull String ATTR_IS_AVAILABLE_LIVE = "is_available_live";
    private static final @NonNull String ATTR_KEY = "key";
    private static final @NonNull String ATTR_METRIC = "metric";
    private static final @NonNull String ATTR_MODE = "mode";
    private static final @NonNull String ATTR_MULTIPLIER = "multiplier";
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String ATTR_ORDER = "order";
    private static final @NonNull String ATTR_PER_CPU = "per_cpu";
    private static final @NonNull String ATTR_PERCENTAGE = "percentage";
    private static final @NonNull String ATTR_PROC = "proc";
    private static final @NonNull String ATTR_REGEX = "regex";
    private static final @NonNull String ATTR_RENDERING_TYPE = "rendering_type";
    private static final @NonNull String ATTR_SELECTED = "selected";
    private static final @NonNull String ATTR_SERIES_COMPOSITION = "series_composition";
    private static final @NonNull String ATTR_TITLE = "title";
    private static final @NonNull String ATTR_TRACEPOINT = "tracepoint";
    private static final @NonNull String ATTR_TYPE = "type";
    private static final @NonNull String ATTR_UNITS = "units";
    private static final @NonNull String EMPTY_STRING = "";
    private static final @NonNull String TAG_CHANNEL = "channel-descriptor";
    private static final boolean IS_AVALIABLE_LIVE_DEFAULT = true;
    public static final @NonNull String ATRACE_DYNAMIC_COUNTER_PREFIX = "atrace_dynamic_counter_";
    static final Pattern CNT_AND_CCNT_REGEX = Pattern.compile("(.+)(_cnt[0-9]+|_ccnt)$");
    private @NonNull ProcessingElementReference @Nullable [] channelDescriptions = null;
    private @NonNull List<@NonNull String> mActivity = Collections.emptyList();
    private @NonNull TIntArrayList mActivityColor = new TIntArrayList();
    private boolean mAlignmentSupported;
    private String mArg;
    private boolean mAverageCores;
    private boolean mAverageSelection;
    private int mChannel;
    private CounterClass mClass;
    private Integer mCluster;
    private Integer mColor;
    private int mCores = -1;
    private @Nullable String mCounter;
    private boolean mDerived;
    private String mDescription;
    private DeviceType mDevice;
    private CounterDisplay mDisplay;
    private boolean mDynamic;
    private @Nullable Long mEvent = null;
    private int mEventCount;
    private String mExpression;
    private boolean mFromFtrace = false;
    private boolean mHideByDefault = false;
    private boolean mHighResolution;
    private boolean mIgnore;
    private boolean mIsAvailableLive = true;
    private int mKey = -1;
    private double mMultiplier = 1.0;
    private String mName;
    private boolean mPercentage;
    private @NonNull Ternary mProc = Ternary.MAYBE;
    private String mRegex;
    private GraphRenderingType mRenderingType;
    private boolean mSelected = true;
    private SeriesComposition mSeriesComposition;
    private String mTitle;
    private String mTracepoint;
    private String mUnits;
    private @NonNull CounterMode mMode = CounterMode.SYSTEM_WIDE;
    private @Nullable String mDeviceInstance;
    private int order;
    private boolean mMetric;

    public static @NonNull String getAlias(String title, String name, @Nullable Integer cluster, @Nullable String deviceInstance) {
        if (cluster != null) {
            assert (deviceInstance == null);
            return SeriesAliasUtils.createAlias(title, name, (int)cluster);
        }
        if (deviceInstance != null) {
            return SeriesAliasUtils.createAlias(title, name, deviceInstance);
        }
        return SeriesAliasUtils.createAlias(title, name);
    }

    private static boolean counterTextEquals(@Nullable String a, @Nullable String b) {
        a = a != null ? a.replaceAll("[^0-9A-Za-z]+", EMPTY_STRING).toLowerCase() : EMPTY_STRING;
        b = b != null ? b.replaceAll("[^0-9A-Za-z]+", EMPTY_STRING).toLowerCase() : EMPTY_STRING;
        return a.contentEquals(b);
    }

    public CounterRecord() {
    }

    public CounterRecord(CounterRecord counter) {
        this(counter, counter.mCounter, counter.mKey);
    }

    public CounterRecord(CounterRecord capturedCounter, StockCounter stockCounter, String name) {
        this(capturedCounter.getCounter(), stockCounter.getTitle(), name, stockCounter.getDescription(), null, null, null, capturedCounter.getKey(), CounterClass.getCounterClass(stockCounter.getCounterClass()), CounterDisplay.getDisplay(stockCounter.getDisplay(), CounterClass.getCounterClass(stockCounter.getCounterClass())), stockCounter.isAverageSelection(), stockCounter.getDeviceInstance());
        this.mMetric = stockCounter.getMetricProperties() != null;
        this.mAverageCores = stockCounter.isAverageCores();
        this.mDerived = stockCounter.isDerived();
        this.mProc = stockCounter.isProc();
        this.mEvent = capturedCounter.getEvent();
        this.mEventCount = capturedCounter.getEventCount();
        this.mPercentage = stockCounter.isPercentage();
        this.mMode = stockCounter.isPerCPU() ? CounterMode.PER_CORE : CounterMode.SYSTEM_WIDE;
        this.mRenderingType = GraphRenderingType.get(stockCounter.getRenderingType());
        this.mSeriesComposition = SeriesComposition.get(stockCounter.getSeriesComposition());
        this.mUnits = stockCounter.getUnits();
        if (this.mUnits.length() == 0) {
            this.mUnits = null;
        }
        this.mMultiplier = stockCounter.getMultiplier();
        this.mCores = capturedCounter.getCores();
        this.mColor = stockCounter.getColor();
        this.mTracepoint = stockCounter.getTracepoint();
        this.mRegex = stockCounter.getRegex();
        this.mArg = stockCounter.getArg();
        this.mActivity = stockCounter.getActivity();
        this.mActivityColor = stockCounter.getActivityColor();
        this.mFromFtrace = this.mCounter != null && this.mCounter.startsWith("ftrace_");
        this.mDevice = capturedCounter.mDevice;
    }

    public CounterRecord(CounterRecord counter, String counterName, int key) {
        this.mAlignmentSupported = counter.mAlignmentSupported;
        this.mAverageCores = counter.mAverageCores;
        this.mAverageSelection = counter.mAverageSelection;
        this.mClass = counter.mClass;
        this.mCluster = counter.mCluster;
        this.mColor = counter.mColor;
        this.mCounter = counterName;
        this.mDerived = counter.mDerived;
        this.mProc = counter.mProc;
        this.mDescription = counter.mDescription;
        this.mDevice = counter.mDevice;
        this.mDisplay = counter.mDisplay;
        this.mEvent = counter.mEvent;
        this.mEventCount = counter.mEventCount;
        this.mExpression = counter.mExpression;
        this.mHighResolution = counter.mHighResolution;
        this.mKey = key;
        this.mName = counter.mName;
        this.mPercentage = counter.mPercentage;
        this.mMode = counter.mMode;
        this.mRenderingType = counter.mRenderingType;
        this.mSelected = counter.mSelected;
        this.mSeriesComposition = counter.mSeriesComposition;
        this.mTitle = counter.mTitle;
        this.mUnits = counter.mUnits;
        this.mMultiplier = counter.mMultiplier;
        this.mChannel = counter.mChannel;
        this.mCores = counter.mCores;
        this.mRegex = counter.mRegex;
        this.mTracepoint = counter.mTracepoint;
        this.mArg = counter.mArg;
        this.mActivity = counter.mActivity;
        this.mActivityColor = counter.mActivityColor;
        this.mIgnore = counter.mIgnore;
        this.mFromFtrace = counter.mFromFtrace;
        this.mDynamic = counter.mDynamic;
        this.mHideByDefault = counter.mHideByDefault;
        this.mDeviceInstance = counter.mDeviceInstance;
        this.mMetric = counter.mMetric;
    }

    public CounterRecord(StockCounter stockCounter, String counter, String name, int key) {
        this(counter, stockCounter.getTitle(), name, stockCounter.getDescription(), null, null, null, key, CounterClass.getCounterClass(stockCounter.getCounterClass()), CounterDisplay.getDisplay(stockCounter.getDisplay(), CounterClass.getCounterClass(stockCounter.getCounterClass())), stockCounter.isAverageSelection(), stockCounter.getDeviceInstance());
        this.mMetric = stockCounter.getMetricProperties() != null;
        this.mAverageCores = stockCounter.isAverageCores();
        this.mDerived = stockCounter.isDerived();
        this.mProc = stockCounter.isProc();
        this.mEvent = stockCounter.getEvent();
        this.mEventCount = 0;
        this.mPercentage = stockCounter.isPercentage();
        this.mMode = stockCounter.isPerCPU() ? CounterMode.PER_CORE : CounterMode.SYSTEM_WIDE;
        this.mRenderingType = GraphRenderingType.get(stockCounter.getRenderingType());
        this.mSeriesComposition = SeriesComposition.get(stockCounter.getSeriesComposition());
        this.mUnits = stockCounter.getUnits();
        if (this.mUnits.length() == 0) {
            this.mUnits = null;
        }
        this.mMultiplier = stockCounter.getMultiplier();
        this.mCores = stockCounter.getCores();
        this.mColor = stockCounter.getColor();
        this.mTracepoint = stockCounter.getTracepoint();
        this.mRegex = stockCounter.getRegex();
        this.mArg = stockCounter.getArg();
        this.mActivity = stockCounter.getActivity();
        this.mActivityColor = stockCounter.getActivityColor();
        this.mFromFtrace = this.mCounter != null && this.mCounter.startsWith("ftrace_");
        this.mCluster = stockCounter.getClusterId();
    }

    public CounterRecord(String counter, String title, String name, String description, String deviceInstance) {
        this.mCounter = counter;
        this.mDescription = description;
        this.mDeviceInstance = deviceInstance;
        this.mName = name;
        this.mMetric = false;
        if (BasicTextFilter.isEmpty((String)this.mName)) {
            this.mName = ModelMessages.UNNAMED;
        }
        this.mTitle = title;
        if (BasicTextFilter.isEmpty((String)this.mTitle)) {
            this.mTitle = ModelMessages.UNTITLED;
        }
        if (this.mClass == null) {
            this.mClass = CounterClass.DELTA;
        }
        if (this.mRenderingType == null) {
            this.mRenderingType = GraphRenderingType.DEFAULT;
        }
        if (this.mSeriesComposition == null) {
            this.mSeriesComposition = SeriesComposition.DEFAULT;
        }
    }

    public CounterRecord(String counter, String title, String name, String description, String deviceInstance, int key) {
        this(counter, title, name, description, deviceInstance);
        this.mKey = key;
    }

    public CounterRecord(String counter, String title, String name, String description, String deviceInstance, int key, @NonNull DeviceType deviceType) {
        this(counter, title, name, description, deviceInstance);
        this.mKey = key;
        this.mDevice = deviceType;
    }

    public CounterRecord(String counter, String title, String name, String description, String deviceInstance, long event, int key) {
        this(counter, title, name, description, deviceInstance, key);
        this.mEvent = event;
    }

    public CounterRecord(String counter, String title, String name, String description, String units, Integer color, int key, CounterClass cclass, CounterDisplay display, boolean averageSelection, @NonNull CounterMode mode, double multiplier, SeriesComposition seriesComposition, GraphRenderingType renderingType, boolean averageCores, boolean percentage, @NonNull List<@NonNull String> activity, @NonNull TIntArrayList activityColor, int cores, boolean fromFtrace, boolean dynamic, @NonNull Ternary proc, String deviceInstance) {
        this(counter, title, name, description, units, null, color, key, cclass, display, averageSelection, deviceInstance);
        this.mMode = mode;
        this.mMultiplier = multiplier;
        this.mSeriesComposition = seriesComposition;
        this.mRenderingType = renderingType;
        this.mAverageCores = averageCores;
        this.mPercentage = percentage;
        this.mActivity = activity;
        this.mActivityColor = activityColor;
        this.mCores = cores;
        this.mFromFtrace = fromFtrace;
        this.mProc = proc;
        this.mDynamic = dynamic;
    }

    public CounterRecord(XMLParser in) throws IOException, BadXmlException {
        this(in, (IThrowingBiFunction<XMLParser, DeviceType, ProcessingElementReference[], IOException>)((IThrowingBiFunction)CounterRecord::parseChannelsTag));
    }

    private static @NonNull ProcessingElementReference @Nullable [] parseChannelsTag(@NonNull XMLParser in, @NonNull DeviceType deviceType) throws IOException {
        String tag;
        ArrayList<@NonNull ProcessingElementReference> channelDescriptors = new ArrayList<ProcessingElementReference>();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_CHANNEL.equals(tag)) {
                ProcessingElementReference peReference = new ProcessingElementReference(in);
                if (!peReference.deviceType.equals(deviceType)) {
                    peReference = ProcessingElementReference.create(deviceType, peReference.vmUID, peReference.deviceNumber);
                }
                assert (peReference.deviceType.equals(deviceType));
                channelDescriptors.add(peReference);
                continue;
            }
            in.skip();
        }
        return !channelDescriptors.isEmpty() ? channelDescriptors.toArray(new ProcessingElementReference[channelDescriptors.size()]) : null;
    }

    public CounterRecord(XMLParser in, @NonNull IThrowingBiFunction<@NonNull XMLParser, @NonNull DeviceType, @NonNull ProcessingElementReference @Nullable [], IOException> channelDescriptionsParser) throws IOException, BadXmlException {
        DeviceType deviceType;
        this.mAlignmentSupported = in.isAttributeSet(ATTR_ALIGNMENT, false);
        this.mAverageCores = in.isAttributeSet(ATTR_AVERAGE_CORES, false);
        this.mAverageSelection = in.isAttributeSet(ATTR_AVERAGE_SELECTION, false);
        if (in.hasAttribute(ATTR_CLUSTER)) {
            this.mCluster = in.getIntegerAttribute(ATTR_CLUSTER);
        }
        this.mColor = in.hasAttribute(ATTR_COLOR) ? Integer.valueOf(in.getIntegerAttribute(ATTR_COLOR, 0)) : null;
        this.mCounter = in.getAttribute(ATTR_COUNTER);
        if (this.mCounter == null || ((String)NullChecking.neverNull((Object)this.mCounter)).isEmpty()) {
            this.mCounter = in.getAttribute(ATTR_TYPE);
        }
        this.mDerived = in.isAttributeSet(ATTR_DERIVED, false);
        this.mProc = in.getAttribute(ATTR_PROC, Ternary.MAYBE);
        this.mDescription = in.getAttribute(ATTR_DESCRIPTION, EMPTY_STRING);
        this.mDeviceInstance = in.getAttribute(ATTR_DEVICE_INSTANCE);
        this.mClass = CounterClass.getCounterClass(in.getAttribute(ATTR_CLASS));
        this.mDisplay = CounterDisplay.getDisplay(in.getAttribute(ATTR_DISPLAY), this.mClass);
        this.mUnits = in.getAttribute(ATTR_UNITS, EMPTY_STRING);
        this.mMultiplier = in.getDoubleAttribute(ATTR_MULTIPLIER, 1.0);
        this.mEvent = in.hasAttribute(ATTR_EVENT) ? Long.valueOf(in.getLongAttribute(ATTR_EVENT)) : null;
        this.mEventCount = in.getIntegerAttribute(ATTR_COUNT, 0);
        this.mExpression = in.getAttribute(ATTR_EXPRESSION);
        this.mHighResolution = in.isAttributeSet(ATTR_HIGH_RESOLUTION, false);
        this.mKey = in.getIntegerAttribute(ATTR_KEY, -1);
        this.mName = in.getAttribute(ATTR_NAME);
        this.mPercentage = in.isAttributeSet(ATTR_PERCENTAGE, false);
        this.mRenderingType = GraphRenderingType.get(in.getAttribute(ATTR_RENDERING_TYPE));
        this.mSelected = in.isAttributeSet(ATTR_SELECTED, true);
        this.mSeriesComposition = SeriesComposition.get(in.getAttribute(ATTR_SERIES_COMPOSITION));
        this.mTitle = in.getAttribute(ATTR_TITLE);
        this.mRegex = in.getAttribute(ATTR_REGEX);
        this.mTracepoint = in.getAttribute(ATTR_TRACEPOINT);
        this.mArg = in.getAttribute(ATTR_ARG);
        this.order = in.getIntegerAttribute(ATTR_ORDER);
        this.mFromFtrace = in.isAttributeSet(ATTR_FROM_FTRACE, false);
        this.mDynamic = in.isAttributeSet(ATTR_DYNAMIC, false);
        this.mIsAvailableLive = in.isAttributeSet(ATTR_IS_AVAILABLE_LIVE, true);
        this.mMetric = in.isAttributeSet(ATTR_METRIC);
        boolean perCPU = in.isAttributeSet(ATTR_PER_CPU, false);
        CounterMode mode = CounterMode.read(in.getAttribute(ATTR_MODE), perCPU);
        this.mDevice = deviceType = DeviceType.read(in, !perCPU);
        if (CounterClass.CONSTANT.equals((Object)this.mClass) && (mode == null || this.mDevice == null)) {
            throw new BadXmlException("Class is constant but either mode or device was not present");
        }
        this.mHideByDefault = CounterClass.CONSTANT.equals((Object)this.mClass) || in.isAttributeSet(ATTR_HIDE_BY_DEFAULT, false);
        this.mMode = mode != null ? mode : CounterMode.SYSTEM_WIDE;
        this.mCores = in.getIntegerAttribute(ATTR_CORES, CounterClass.ACTIVITY.equals((Object)this.mClass) ? 1 : -1);
        if (in.hasAttribute("activity1")) {
            this.mActivity = new ArrayList<String>();
        }
        int activityId = 1;
        while (in.hasAttribute(ATTR_ACTIVITY + activityId)) {
            this.mActivity.add(in.getAttribute(ATTR_ACTIVITY + activityId, "#" + activityId));
            ++activityId;
        }
        activityId = 1;
        while (in.hasAttribute(ATTR_ACTIVITY_COLOR + activityId)) {
            this.mActivityColor.add(in.getIntegerAttribute(ATTR_ACTIVITY_COLOR + activityId));
            ++activityId;
        }
        this.channelDescriptions = (ProcessingElementReference[])channelDescriptionsParser.apply((Object)in, (Object)deviceType);
    }

    private CounterRecord(String counter, String title, String name, String description, String units, String expression, Integer color, int key, CounterClass cclass, CounterDisplay display, boolean averageSelection, String deviceInstance) {
        this(counter, title, name, description, deviceInstance);
        this.mUnits = units;
        this.mExpression = expression;
        this.mColor = color;
        this.mClass = cclass;
        this.mDisplay = display;
        this.mKey = key;
        this.mAverageSelection = averageSelection;
        this.mHideByDefault = cclass.isConstant() || this.mHideByDefault;
    }

    @Override
    public int compareTo(CounterRecord that) {
        return SeriesComparator.compareSeries(this.getOrder(), this.getTitleFormat(), this.getName(), this.getCounterClass().isActivity(), that.getOrder(), that.getTitleFormat(), that.getName(), that.getCounterClass().isActivity());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CounterRecord other = (CounterRecord)obj;
        if (this.mMetric != other.mMetric) {
            return false;
        }
        if (!this.mActivity.equals(other.mActivity)) {
            return false;
        }
        if (!this.mActivityColor.equals((Object)other.mActivityColor)) {
            return false;
        }
        if (this.mAlignmentSupported != other.mAlignmentSupported) {
            return false;
        }
        if (!Objects.equals(this.mArg, other.mArg)) {
            return false;
        }
        if (this.mAverageCores != other.mAverageCores) {
            return false;
        }
        if (this.mAverageSelection != other.mAverageSelection) {
            return false;
        }
        if (this.mChannel != other.mChannel) {
            return false;
        }
        if (this.mClass != other.mClass) {
            return false;
        }
        if (!Objects.equals(this.mCluster, other.mCluster)) {
            return false;
        }
        if (!Objects.equals(this.mColor, other.mColor)) {
            return false;
        }
        if (this.mCores != other.mCores) {
            return false;
        }
        if (this.mCounter == null ? other.mCounter != null : !((String)NullChecking.neverNull((Object)this.mCounter)).equals(other.mCounter)) {
            return false;
        }
        if (this.mDerived != other.mDerived) {
            return false;
        }
        if (!Objects.equals(this.mDescription, other.mDescription)) {
            return false;
        }
        if (!Objects.equals(this.mDevice, other.mDevice)) {
            return false;
        }
        if (!NullChecking.equalsNullable((Object)this.mDeviceInstance, (Object)other.mDeviceInstance)) {
            return false;
        }
        if (this.mDisplay != other.mDisplay) {
            return false;
        }
        if (this.mDynamic != other.mDynamic) {
            return false;
        }
        if (!NullChecking.equalsNullable((Object)this.mEvent, (Object)other.mEvent)) {
            return false;
        }
        if (this.mEventCount != other.mEventCount) {
            return false;
        }
        if (!Objects.equals(this.mExpression, other.mExpression)) {
            return false;
        }
        if (this.mFromFtrace != other.mFromFtrace) {
            return false;
        }
        if (this.mHideByDefault != other.mHideByDefault) {
            return false;
        }
        if (this.mHighResolution != other.mHighResolution) {
            return false;
        }
        if (this.mIgnore != other.mIgnore) {
            return false;
        }
        if (this.mIsAvailableLive != other.mIsAvailableLive) {
            return false;
        }
        if (this.mKey != other.mKey) {
            return false;
        }
        if (Double.doubleToLongBits(this.mMultiplier) != Double.doubleToLongBits(other.mMultiplier)) {
            return false;
        }
        if (!Objects.equals(this.mName, other.mName)) {
            return false;
        }
        if (this.mMode != other.mMode) {
            return false;
        }
        if (this.mPercentage != other.mPercentage) {
            return false;
        }
        if (this.mProc != other.mProc) {
            return false;
        }
        if (!Objects.equals(this.mRegex, other.mRegex)) {
            return false;
        }
        if (this.mRenderingType != other.mRenderingType) {
            return false;
        }
        if (this.mSelected != other.mSelected) {
            return false;
        }
        if (this.mSeriesComposition != other.mSeriesComposition) {
            return false;
        }
        if (!Objects.equals(this.mTitle, other.mTitle)) {
            return false;
        }
        if (!Objects.equals(this.mTracepoint, other.mTracepoint)) {
            return false;
        }
        return Objects.equals(this.mUnits, other.mUnits);
    }

    public @NonNull List<@NonNull String> getActivity() {
        return this.mActivity;
    }

    public @NonNull TIntArrayList getActivityColor() {
        return this.mActivityColor;
    }

    public @NonNull String getAlias() {
        return this.getAlias(false);
    }

    public @NonNull String getAlias(boolean ignoreCluster) {
        return CounterRecord.getAlias(this.mTitle, this.mName, ignoreCluster ? null : this.getCluster(), this.mDeviceInstance);
    }

    public String getArg() {
        return this.mArg;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public @NonNull ProcessingElementReference @Nullable [] getChannelDescriptions() {
        return this.channelDescriptions;
    }

    public Integer getCluster() {
        return this.mCluster;
    }

    public @Nullable Integer getColor() {
        return this.mColor;
    }

    public int getCores() {
        @Nullable DeviceType device = this.mDevice;
        if (device != null && device.supportsMultipleCores()) {
            return Math.max(1, this.mCores);
        }
        return this.mCores;
    }

    public String getCounter() {
        return this.mCounter;
    }

    public CounterClass getCounterClass() {
        return this.mClass;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public @Nullable DeviceType getDeviceType() {
        return this.mDevice;
    }

    public @NonNull DeviceType getDeviceTypeOrDefault() {
        return (DeviceType)NullChecking.neverNullOr((Object)this.mDevice, (Object)(switch (this.mMode) {
            case CounterMode.PER_CORE -> this.mCores > 0 ? DeviceType.CPU : DeviceType.SYSTEM_WIDE;
            case CounterMode.SYSTEM_WIDE -> DeviceType.SYSTEM_WIDE;
            default -> throw new AssertionError((Object)("Invalid CounterMode: " + String.valueOf((Object)this.mMode)));
        }));
    }

    public @NonNull CounterDisplay getDisplay() {
        return (CounterDisplay)((Object)NullChecking.neverNullOr((Object)((Object)this.mDisplay), (Object)((Object)CounterDisplay.getDefault())));
    }

    public @Nullable Long getEvent() {
        return this.mEvent;
    }

    public int getEventCount() {
        return this.mEventCount;
    }

    public @NonNull String getExpression() {
        return "$" + this.getAlias();
    }

    public int getKey() {
        return this.mKey;
    }

    public double getMultiplier() {
        return this.mMultiplier;
    }

    public String getName() {
        return this.mName;
    }

    public CounterMode getMode() {
        return this.mMode;
    }

    public String getRegex() {
        return this.mRegex;
    }

    public GraphRenderingType getRenderingType() {
        return this.mRenderingType;
    }

    public SeriesComposition getSeriesComposition() {
        return this.mSeriesComposition;
    }

    public String getTitle() {
        String mDeviceInstance = this.mDeviceInstance;
        if (mDeviceInstance == null) {
            return this.mTitle;
        }
        assert (this.mCluster == null);
        return String.format("%s (%s)", this.mTitle, mDeviceInstance);
    }

    public String getTitleFormat() {
        @Nullable Integer cluster = this.getCluster();
        if (cluster == null) {
            return this.getTitle();
        }
        assert (this.mDeviceInstance == null);
        return String.format("%s%s", this.mTitle, VariableReplacerConstants.clusterTitleId(cluster));
    }

    public String getTracepoint() {
        return this.mTracepoint;
    }

    public @NonNull String getUniqueAtraceKey() {
        StringBuilder result = new StringBuilder();
        String type = this.mCounter;
        if (type != null) {
            result.append(type).append('|');
        }
        result.append(this.mTitle);
        @Nullable Integer cluster = this.mCluster;
        if (cluster != null) {
            result.append(VariableReplacerConstants.clusterVarId(cluster));
        }
        result.append('|').append(this.mName);
        return result.toString();
    }

    public String getUnits() {
        return this.mUnits;
    }

    public int hashCode() {
        return this.mKey;
    }

    public boolean hideByDefault() {
        return this.mHideByDefault;
    }

    public boolean ignore() {
        return this.mIgnore;
    }

    public boolean isAlignmentSupported() {
        return this.mAlignmentSupported;
    }

    public boolean isAvailableLive() {
        return this.mIsAvailableLive;
    }

    public boolean isAverageCores() {
        return this.mAverageCores;
    }

    public boolean isAverageSelection() {
        return this.mAverageSelection;
    }

    public boolean isCPUActivitySystem() {
        return ActivityChartUtils.isCPUActivitySystem(this.getTitle(), this.getName());
    }

    public boolean isCPUActivityUser() {
        return ActivityChartUtils.isCPUActivityUser(this.getTitle(), this.getName());
    }

    public boolean isDerived() {
        return this.mDerived;
    }

    public boolean isDynamic() {
        return this.mDynamic;
    }

    public boolean isFromFtrace() {
        return this.mFromFtrace;
    }

    public boolean isMetric() {
        return this.mMetric;
    }

    public boolean isInStockCounterMap(@NonNull Map<@NonNull String, @NonNull String> idToCounterSetMap, @NonNull BiFunction<@NonNull String, @Nullable Long, @Nullable StockCounter> mapLookup) {
        String counterNameToUse;
        @NonNull Matcher matcher = CNT_AND_CCNT_REGEX.matcher(this.mCounter);
        if (this.mDevice.isCPU() && matcher.matches()) {
            @NonNull String prefix = (String)NullChecking.neverNull((Object)matcher.group(1));
            @NonNull String suffix = (String)NullChecking.neverNull((Object)matcher.group(2));
            @Nullable String counterSet = idToCounterSetMap.get(prefix);
            counterNameToUse = counterSet != null ? String.format("%s%s", counterSet, suffix) : (String)NullChecking.neverNull((Object)this.mCounter);
        } else if (this.mDevice.isGPU()) {
            counterNameToUse = (String)NullChecking.neverNull((Object)this.mCounter);
        } else {
            return true;
        }
        StockCounter stockCounter = mapLookup.apply(counterNameToUse, this.mEvent);
        if (stockCounter == null) {
            return false;
        }
        return CounterRecord.counterTextEquals(this.mTitle, stockCounter.getTitle()) && CounterRecord.counterTextEquals(this.mName, stockCounter.getName()) && CounterRecord.counterTextEquals(this.mDescription, stockCounter.getDescription()) && NullChecking.equalsNullable((Object)this.mEvent, (Object)stockCounter.getEvent()) && CounterRecord.counterTextEquals(this.mDeviceInstance, stockCounter.getDeviceInstance());
    }

    public boolean isInStockCounterMap(@NonNull Map<String, StockCounter> stockCounterMap, @NonNull Map<@NonNull String, @NonNull String> idToCounterSetMap) {
        return this.isInStockCounterMap(idToCounterSetMap, (String counter, Long event) -> (StockCounter)NullChecking.applyIfNonNull((Object)TargetCounter.find(stockCounterMap, counter, event), TargetCounter::getDerivedFrom));
    }

    public boolean isMemoryUsed() {
        return "Memory".contentEquals(this.mTitle) && "Used".contentEquals(this.mName);
    }

    public boolean isPercentage() {
        return this.mPercentage;
    }

    public boolean isPerCPU() {
        switch (this.mMode) {
            case PER_CORE: {
                return true;
            }
            case SYSTEM_WIDE: {
                return false;
            }
        }
        throw new AssertionError((Object)("Invalid CounterMode: " + String.valueOf((Object)this.mMode)));
    }

    public @NonNull Ternary isProc() {
        return this.mProc;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setAlignmentSupported(boolean supported) {
        this.mAlignmentSupported = supported;
    }

    public void setAverageCores(boolean averageCores) {
        this.mAverageCores = averageCores;
    }

    public void setAverageSelection(boolean averageSelection) {
        this.mAverageSelection = averageSelection;
    }

    public void setChannel(int channel) {
        this.mChannel = channel;
    }

    public void setChannelDescriptions(@NonNull ProcessingElementReference @Nullable [] channelDescriptions) {
        this.channelDescriptions = channelDescriptions;
        if (this.channelDescriptions != null) {
            Arrays.sort(this.channelDescriptions, Comparator.naturalOrder());
        }
    }

    public void setCluster(Integer cluster) {
        this.mCluster = cluster;
    }

    public void setColor(@Nullable Integer color) {
        this.mColor = color;
    }

    public void setCores(int cores) {
        this.mCores = cores;
    }

    public void setCounter(String counter) {
        this.mCounter = counter;
    }

    public void setCounterClass(CounterClass counterClass) {
        this.mClass = counterClass;
    }

    public void setDerived(boolean derived) {
        this.mDerived = derived;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setDeviceType(DeviceType device) {
        this.mDevice = device;
    }

    public void setDisplay(CounterDisplay display) {
        this.mDisplay = display;
    }

    public void setDynamic(boolean dynamic) {
        this.mDynamic = dynamic;
    }

    public void setEventCount(int eventCount) {
        this.mEventCount = eventCount;
    }

    public void setFromFtrace(boolean fromFtrace) {
        this.mFromFtrace = fromFtrace;
    }

    public void setHideByDefault(boolean hideByDefault) {
        this.mHideByDefault = hideByDefault;
    }

    public void setIgnore() {
        this.mIgnore = true;
    }

    public void setIsAvailableLive(boolean isAvailableLive) {
        this.mIsAvailableLive = isAvailableLive;
    }

    public void setKey(int key) {
        this.mKey = key;
    }

    public void setMode(@NonNull CounterMode mode) {
        this.mMode = mode;
    }

    public void setMultiplier(double multiplier) {
        this.mMultiplier = multiplier;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setPercentage(boolean percentage) {
        this.mPercentage = percentage;
    }

    public void setProc(@NonNull Ternary isProc) {
        this.mProc = isProc;
    }

    public void setRenderingType(GraphRenderingType renderingType) {
        this.mRenderingType = renderingType;
    }

    public void setSelected(boolean selected) {
        this.mSelected = selected;
    }

    public void setSeriesComposition(SeriesComposition seriesComposition) {
        this.mSeriesComposition = seriesComposition;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setTracepoint(String tracepoint) {
        this.mTracepoint = tracepoint;
    }

    public void setUnits(String units) {
        this.mUnits = units;
    }

    public String toString() {
        return String.format("%d (%s) '%s'.'%s' :: '%s' / %s / %s", new Object[]{this.mKey, this.mCounter, this.mTitle, this.mName, this.mDescription, this.mDynamic, this.mClass});
    }

    public void write(XMLGenerator xml) throws IOException {
        this.write(xml, true);
    }

    public void write(XMLGenerator xml, boolean writeEventProperties) throws IOException {
        this.write(xml, writeEventProperties, this.mCores);
    }

    public void write(XMLGenerator xml, int cores) throws IOException {
        this.write(xml, true, cores);
    }

    private void write(XMLGenerator xml, boolean writeEventProperties, int cores) throws IOException {
        ProcessingElementReference[] channelDescriptions;
        if (this.mKey >= 0) {
            xml.addAttribute(ATTR_KEY, "0x" + Integer.toHexString(this.mKey));
        }
        xml.addAttributeNotEmpty(ATTR_TYPE, this.mCounter);
        if (this.mEvent != null) {
            xml.addAttribute(ATTR_EVENT, "0x" + Long.toHexString(this.mEvent));
        }
        xml.addAttributeNot(ATTR_COUNT, this.mEventCount, 0);
        if (cores > 0) {
            xml.addAttribute(ATTR_CORES, cores);
        }
        xml.addAttributeNot(ATTR_METRIC, this.mMetric, false);
        if (writeEventProperties || CounterClass.CONSTANT.equals((Object)this.mClass)) {
            xml.addAttributeNotEmpty(ATTR_TITLE, this.mTitle);
            xml.addAttributeNotEmpty(ATTR_NAME, this.mName);
            xml.addAttributeNotEmpty(ATTR_DESCRIPTION, this.mDescription);
            if (this.mDeviceInstance != null) {
                xml.addAttributeNotEmpty(ATTR_DEVICE_INSTANCE, this.mDeviceInstance);
            }
            if (this.mColor != null) {
                xml.addAttribute(ATTR_COLOR, String.format("0x%08X", this.mColor));
            }
            if (this.mCluster != null) {
                xml.addAttribute(ATTR_CLUSTER, this.mCluster);
            }
            xml.addAttributeNot(ATTR_ALIGNMENT, this.mAlignmentSupported, false);
            xml.addAttributeNotEmpty(ATTR_CLASS, this.mClass != null ? this.mClass.toString() : null);
            if (this.mDevice != null) {
                this.mDevice.write(xml);
            }
            xml.addAttributeNotEmpty(ATTR_DISPLAY, this.mDisplay != null ? this.mDisplay.toString() : null);
            xml.addAttributeNotEmpty(ATTR_UNITS, this.mUnits);
            if (Double.compare(this.mMultiplier, 1.0) != 0) {
                xml.addAttribute(ATTR_MULTIPLIER, this.mMultiplier);
            }
            xml.addAttributeNotEmpty(ATTR_EXPRESSION, this.mExpression);
            xml.addAttributeNot(ATTR_AVERAGE_CORES, this.mAverageCores, false);
            xml.addAttributeNot(ATTR_AVERAGE_SELECTION, this.mAverageSelection, false);
            xml.addAttributeNot(ATTR_PERCENTAGE, this.mPercentage, false);
            xml.addAttributeNot(ATTR_DERIVED, this.mDerived, false);
            xml.addAttributeNot(ATTR_HIDE_BY_DEFAULT, this.mHideByDefault, false);
            xml.addAttributeNot(ATTR_IS_AVAILABLE_LIVE, this.mIsAvailableLive, true);
            xml.addAttributeNot(ATTR_PROC, this.mProc, Ternary.MAYBE);
            xml.addAttributeNotEmpty(ATTR_RENDERING_TYPE, this.mRenderingType.toString());
            xml.addAttributeNotEmpty(ATTR_SERIES_COMPOSITION, this.mSeriesComposition.toString());
            xml.addAttributeNot(ATTR_HIGH_RESOLUTION, this.mHighResolution, false);
            xml.addAttributeNotEmpty(ATTR_MODE, this.mMode.xmlValue);
            xml.addAttributeNot(ATTR_FROM_FTRACE, this.mFromFtrace, false);
            xml.addAttributeNot(ATTR_DYNAMIC, this.mDynamic, false);
            xml.addAttributeNot(ATTR_SELECTED, this.mSelected, true);
            xml.addAttributeNotEmpty(ATTR_REGEX, this.mRegex);
            xml.addAttributeNotEmpty(ATTR_TRACEPOINT, this.mTracepoint);
            xml.addAttributeNotEmpty(ATTR_ARG, this.mArg);
            xml.addAttributeNot(ATTR_ORDER, this.order, 0);
            int i = 0;
            while (i < this.mActivity.size()) {
                xml.addAttribute(ATTR_ACTIVITY + (i + 1), this.mActivity.get(i));
                ++i;
            }
            i = 0;
            while (i < this.mActivityColor.size()) {
                xml.addAttribute(ATTR_ACTIVITY_COLOR + (i + 1), "0x" + Integer.toHexString(this.mActivityColor.get(i)));
                ++i;
            }
        }
        if ((channelDescriptions = this.channelDescriptions) != null && channelDescriptions.length > 0) {
            ProcessingElementReference[] processingElementReferenceArray = channelDescriptions;
            int n = channelDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessingElementReference peReference = processingElementReferenceArray[n2];
                xml.startEmptyTag(TAG_CHANNEL);
                peReference.write(xml);
                ++n2;
            }
        }
    }

    public boolean isAtraceCounter() {
        return this.mCounter != null && this.mCounter.startsWith(ATRACE_DYNAMIC_COUNTER_PREFIX);
    }

    public boolean isSourceFilterable() {
        return this.isProc() == Ternary.TRUE || this.isProc() == Ternary.MAYBE && this.isPerCPU() && !this.getCounterClass().isAbsolute() && this.getDeviceTypeOrDefault().isCPU() || this.getCounterClass().isActivity() && this.getDeviceTypeOrDefault().isGPU();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

