/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.databinding.validation;

import com.arm.streamline.common.databinding.validation.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;

public class ApcOutputPathValidator
implements IValidator<String> {
    private @NonNull IFileSystem filesystem;

    public ApcOutputPathValidator(@NonNull IFileSystem filesystem) {
        this.filesystem = filesystem;
    }

    public @NonNull IStatus validate(String captureLocationValue) {
        if (captureLocationValue == null || captureLocationValue.isEmpty()) {
            return ValidationStatus.error((String)Messages.VALID_CAPTURE_LOCATION_REQUIRED);
        }
        boolean captureAlreadyExists = this.filesystem.getStore((IPath)new Path(captureLocationValue)).fetchInfo().exists();
        if (captureAlreadyExists) {
            return ValidationStatus.error((String)Messages.ERROR_CAPTURE_ALREADY_EXISTS);
        }
        if (!captureLocationValue.endsWith(".apc")) {
            return ValidationStatus.error((String)String.format(Messages.APC_EXTENSION_REQUIRED, ".apc"));
        }
        return ValidationStatus.ok();
    }
}

