/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.UnsupportedProtocolException;
import com.arm.util.libs.FileURLResolver;
import com.arm.util.libs.IURLResolver;
import com.arm.util.libs.JarURLResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class URLResolver {
    private static Set<File> roPaths = new HashSet<File>();
    private static Map<String, IURLResolver> urlResolvers = new HashMap<String, IURLResolver>();

    static {
        URLResolver.addURLResolver(new FileURLResolver());
        URLResolver.addURLResolver(new JarURLResolver());
        ServiceLoader<IURLResolver> loader = ServiceLoader.load(IURLResolver.class);
        loader.iterator().forEachRemaining(URLResolver::addURLResolver);
    }

    public static synchronized boolean addFileSource(File folder) {
        return roPaths.add(folder);
    }

    public static void addURLResolver(IURLResolver resolver) {
        urlResolvers.put(resolver.getSupportedProtocol(), resolver);
    }

    public static synchronized Set<File> getAllFileSources() {
        return Collections.unmodifiableSet(roPaths);
    }

    public static Collection<IURLResolver> getAllURLResolvers() {
        return Collections.unmodifiableCollection(urlResolvers.values());
    }

    public static IURLResolver getURLResolver(URL url) throws UnsupportedProtocolException {
        IURLResolver result = urlResolvers.get(url.getProtocol());
        if (result == null) {
            throw new UnsupportedProtocolException("unsupported protocol: " + url.getProtocol() + "; supported protocols are " + String.valueOf(urlResolvers.keySet()));
        }
        return result;
    }

    public static synchronized boolean removeFileSource(File folder) {
        return roPaths.remove(folder);
    }

    public static boolean removeURLResolver(IURLResolver resolver) {
        return urlResolvers.remove(resolver.getSupportedProtocol()) != null;
    }

    public static synchronized File resolve(URL url) throws UnsupportedProtocolException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL to resolve is invalid");
        }
        IURLResolver resolver = URLResolver.getURLResolver(url);
        String relPath = resolver.getPhysicalPath(url);
        for (File root : roPaths) {
            File file = new File(root, relPath);
            if (!file.exists()) continue;
            return file;
        }
        return resolver.resolve(url);
    }

    public static File resolve(URL url, File targetDir) throws UnsupportedProtocolException, IOException {
        return URLResolver.getURLResolver(url).resolve(url, targetDir);
    }
}

