/*
 * Decompiled with CFR 0.152.
 */
package com.arm.ini;

import com.arm.ini.IniFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class IniFileParser {
    public static IniFile parse(File input) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]));){
            return IniFileParser.parse(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IniFile parse(InputStream input) throws IOException {
        return IniFileParser.parse(input, false);
    }

    public static IniFile parse(InputStream input, boolean keepFirst) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(input, StandardCharsets.US_ASCII));
        IniFile file = new IniFile();
        IniFile.Section currentSection = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            switch (line.charAt(0)) {
                case '[': {
                    int last = line.indexOf(93);
                    if (last < 0) {
                        throw new IOException(String.format("INI format error: Missing section delimiter on line %d", reader.getLineNumber()));
                    }
                    String section = IniFileParser.parseLine(line, 1, last);
                    currentSection = file.getSection(section);
                    break;
                }
                case '#': 
                case ';': {
                    break;
                }
                default: {
                    int index = line.indexOf(61);
                    String key = null;
                    String value = null;
                    if (index < 0) {
                        key = IniFileParser.parseLine(line, 0, line.length());
                    } else {
                        key = IniFileParser.parseLine(line, 0, index);
                        value = IniFileParser.parseLine(line, index + 1, line.length());
                    }
                    if (currentSection == null) {
                        currentSection = file.getSection("");
                    }
                    currentSection.setProperty(key, value, keepFirst);
                }
            }
        }
        return file;
    }

    private static String parseLine(String line, int start, int end) {
        StringBuilder builder = new StringBuilder(end - start);
        int lastNonWSIndex = -1;
        int quoteCount = 0;
        boolean escaped = false;
        int i = start;
        while (i < end) {
            block6: {
                char c;
                block5: {
                    block4: {
                        c = line.charAt(i);
                        if ((c == ';' || c == '#') && !escaped) break;
                        if (!Character.isWhitespace(c)) break block4;
                        if (lastNonWSIndex >= 0) break block5;
                        break block6;
                    }
                    lastNonWSIndex = builder.length();
                }
                if (c == '\"') {
                    escaped = ++quoteCount % 2 > 0;
                }
                builder.append(c);
            }
            ++i;
        }
        if (lastNonWSIndex + 1 < builder.length()) {
            builder.delete(lastNonWSIndex + 1, builder.length());
        }
        if (quoteCount == 2 && builder.charAt(0) == '\"' && builder.charAt(builder.length() - 1) == '\"') {
            builder.deleteCharAt(0);
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private IniFileParser() {
    }
}

