/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.vm;

import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.LandingPageSceneViewModel;
import java.io.File;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LandingPageSshSubViewViewModel
implements ILandingPageSshSubViewViewModel {
    private final @NonNull ILandingPageActionHandler actionsHandler;
    private final @NonNull ObjectBinding<@Nullable ISshTargetLauncher> activeTargetLauncher;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull SimpleObjectProperty<@NonNull String> commandPathText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleBooleanProperty commandStopOnExit = new SimpleBooleanProperty(true);
    private final @NonNull SimpleObjectProperty<@NonNull String> commandUserNameText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleObjectProperty<@NonNull String> commandWorkingDirText = new SimpleObjectProperty((Object)"");
    private final @NonNull ObservableList<@NonNull ISshTargetLauncher> detectedDevices = FXCollections.observableArrayList();
    private final @NonNull BooleanBinding disableDeviceTableSelection;
    private final @NonNull LandingPageSceneViewModel.ISshTargetLauncherFactory launcherFactory;
    private final @NonNull SimpleObjectProperty<@Nullable ISshTargetLauncher> selectedDetectedDevice = new SimpleObjectProperty();

    public LandingPageSshSubViewViewModel(@NonNull ILandingPageActionHandler actionsHandler, @NonNull LandingPageSceneViewModel.ISshTargetLauncherFactory launcherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel) {
        this.actionsHandler = actionsHandler;
        this.launcherFactory = launcherFactory;
        this.adbPathModel = adbPathModel;
        this.disableDeviceTableSelection = Bindings.isEmpty(this.detectedDevices);
        this.loadDevicesFromCache();
        this.activeTargetLauncher = Bindings.createObjectBinding(this::calculateActiveTargetLauncher, (Observable[])new Observable[]{this.selectedDetectedDevice, this.commandPathText, this.commandWorkingDirText, this.commandUserNameText, this.commandStopOnExit});
        this.detectedDevices.addListener((ListChangeListener)new ListChangeListener<ISshTargetLauncher>(){

            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull ISshTargetLauncher> change) {
                if (LandingPageSshSubViewViewModel.this.detectedDevices.isEmpty()) {
                    LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set(null);
                } else if (LandingPageSshSubViewViewModel.this.detectedDevices.size() == 1) {
                    LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set((Object)((ISshTargetLauncher)LandingPageSshSubViewViewModel.this.detectedDevices.get(0)));
                }
            }
        });
    }

    private void loadDevicesFromCache() {
        Object[] targets = this.actionsHandler.getCachedTargets();
        if (targets != null) {
            this.detectedDevices.addAll(targets);
        }
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable ISshTargetLauncher> activeTargetLauncherProperty() {
        return this.activeTargetLauncher;
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable File> adbToolPathProperty() {
        return this.adbPathModel.adbToolPathProperty();
    }

    @Override
    public boolean canFocusOnDeviceTableEntry(@Nullable ISshTargetLauncher currentTableSelection) {
        if (currentTableSelection == null) {
            return false;
        }
        return this.detectedDevices.contains((Object)currentTableSelection);
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandPathTextProperty() {
        return this.commandPathText;
    }

    @Override
    public @NonNull BooleanProperty commandStopOnExitProperty() {
        return this.commandStopOnExit;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandUserNameTextProperty() {
        return this.commandUserNameText;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandWorkingDirTextProperty() {
        return this.commandWorkingDirText;
    }

    @Override
    public @NonNull ObservableList<@NonNull ISshTargetLauncher> detectedDevicesProperty() {
        return this.detectedDevices;
    }

    @Override
    public @NonNull ObservableBooleanValue disableDeviceTableSelectionProperty() {
        return this.disableDeviceTableSelection;
    }

    @Override
    public void doShowAdbPathConfigurationPreference() {
        this.adbPathModel.doShowAdbPathConfigurationPreference();
    }

    @Override
    public void resetAdbPathToDefault() {
        this.adbPathModel.resetAdbPathToDefault();
    }

    @Override
    public void doShowAndroidTargetHelp() {
        this.actionsHandler.showAndroidTargetHelp();
    }

    @Override
    public void doShowStreamlineMeTargetHelp() {
        this.actionsHandler.showStreamlineMeTargetHelp();
    }

    @Override
    public void doShowLinuxTargetHelp() {
        this.actionsHandler.showLinuxTargetHelp();
    }

    @Override
    public @NonNull ObservableBooleanValue hasValidAdbToolPathSetProperty() {
        return this.adbPathModel.hasValidAdbToolPathSetProperty();
    }

    @Override
    public @NonNull ObjectProperty<@Nullable ISshTargetLauncher> selectedDetectedDeviceProperty() {
        return this.selectedDetectedDevice;
    }

    private @Nullable ISshTargetLauncher calculateActiveTargetLauncher() {
        ISshTargetLauncher selectedDetectedDevice = (ISshTargetLauncher)this.selectedDetectedDevice.get();
        if (selectedDetectedDevice != null) {
            return this.launcherFactory.create(selectedDetectedDevice.getTargetAddress(), (String)this.commandPathText.get(), (String)this.commandWorkingDirText.get(), (String)this.commandUserNameText.get(), selectedDetectedDevice.getProfileName(), selectedDetectedDevice.getUserName(), selectedDetectedDevice.getPassword(), selectedDetectedDevice.getPassKey(), selectedDetectedDevice.getSshPort(), selectedDetectedDevice.getGatorPort(), selectedDetectedDevice.getGatorPath(), this.commandStopOnExit.get());
        }
        return null;
    }

    @Override
    public void setSelectedDeviceIfPresent(@NonNull ISshTargetLauncher targetDevice) {
        Optional<@NonNull ISshTargetLauncher> findSameDeviceInSshView = this.detectedDevicesProperty().stream().filter(SshViewDevice -> SshViewDevice.getTargetAddress().equals(targetDevice.getTargetAddress())).findFirst();
        if (findSameDeviceInSshView.isPresent()) {
            this.selectedDetectedDeviceProperty().set((Object)findSameDeviceInSshView.get());
        } else {
            this.selectedDetectedDeviceProperty().set(null);
        }
    }

    @Override
    public void doShowSSHConfiguration(ISshTargetLauncher sshTarget) {
        this.actionsHandler.showSSHConfiguration(this.detectedDevices, sshTarget);
    }

    @Override
    public void removeDevices(ObservableList<ISshTargetLauncher> observableList) {
        this.detectedDevices.removeAll(observableList);
    }

    @Override
    public void updateDevices(ObservableList<@NonNull ISshTargetLauncher> observableList) {
        this.detectedDevices.setAll(observableList);
    }
}

