/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.utils;

import com.arm.streamline.ui.Images;
import com.arm.streamline.ui.controls.SvgImage;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SvgImageUtility {
    public static @Nullable SvgImage mapStatusToSvgImage( @NonNull ITcpTargetDevice.Status status) {
        switch (status) {
            case AVAILABLE: {
                return Images.LANDING_PAGE_ICON_AVAILABLE.get();
            }
            case UNAVAILABLE_INVALID_VERSION: {
                return Images.LANDING_PAGE_ICON_UNAVAILABLE_INVALID_VERSION.get();
            }
            case UNAVAILABLE_OTHER: {
                return Images.LANDING_PAGE_ICON_UNAVAILABLE_OTHER.get();
            }
        }
        throw new AssertionError((Object)status);
    }

    public static @Nullable SvgImage mapStatusToSvgImage( @NonNull IAndroidTargetDevice.Status status) {
        @NonNull SvgImage image = switch (status) {
            case IAndroidTargetDevice.Status.AVAILABLE -> Images.LANDING_PAGE_ICON_AVAILABLE.get();
            case IAndroidTargetDevice.Status.UNAVAILABLE_INVALID_VERSION_KILLABLE -> Images.LANDING_PAGE_ICON_UNAVAILABLE_INVALID_VERSION_KILLABLE.get();
            case IAndroidTargetDevice.Status.UNAVAILABLE_INVALID_VERSION_UNKILLABLE -> Images.LANDING_PAGE_ICON_UNAVAILABLE_INVALID_VERSION_UNKILLABLE.get();
            case IAndroidTargetDevice.Status.UNAVAILABLE_OTHER -> Images.LANDING_PAGE_ICON_UNAVAILABLE_OTHER.get();
            case IAndroidTargetDevice.Status.UNAVAILABLE_GATORD_RUNNING -> Images.LANDING_PAGE_ICON_UNAVAILABLE_GATORD_RUNNING.get();
            case IAndroidTargetDevice.Status.UNAUTHORIZED -> Images.LANDING_PAGE_ICON_UNAUTHORIZED.get();
            case IAndroidTargetDevice.Status.AVAILABLE_GATORD_RUNNING_PACKAGE -> Images.LANDING_PAGE_ICON_AVAILABLE_GATORD_RUNNING_PACKAGE.get();
            case IAndroidTargetDevice.Status.AVAILABLE_BUT_OUTDATED_CONFIGURATION_XML -> Images.LANDING_PAGE_ICON_AVAILABLE_BUT_OUTDATED_CONFIGURATION_XML.get();
            default -> throw new AssertionError((Object)status);
        };
        image.setPrefWidth(20.0);
        image.setPrefHeight(20.0);
        return image;
    }

    public static @Nullable SvgImage mapRootStatusToImage(boolean isRooted) {
        @NonNull SvgImage image = isRooted ? Images.LANDING_PAGE_ICON_AVAILABLE.get() : Images.LANDING_PAGE_ICON_UNAUTHORIZED.get();
        image.setPrefWidth(20.0);
        image.setPrefHeight(20.0);
        return image;
    }

    public static @Nullable SvgImage mapPackageStatusToSvgImage( @NonNull IAndroidPackage.Status status) {
        @NonNull SvgImage image = switch (status) {
            case IAndroidPackage.Status.DEBUGGABLE -> Images.LANDING_PAGE_ICON_PACKAGE_DEBUGGABLE.get();
            case IAndroidPackage.Status.NON_DEBUGGABLE -> Images.LANDING_PAGE_ICON_PACKAGE_NON_DEBUGGABLE.get();
            default -> throw new AssertionError((Object)status);
        };
        image.setPrefWidth(20.0);
        image.setPrefHeight(20.0);
        return image;
    }
}

