/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.utils;

import com.arm.utils.ListUtils;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.scene.control.FocusModel;
import javafx.scene.control.SelectionModel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public final class ObservableUtils<T> {
    public static <T> @NonNull IDisposable bindSingleSelectionBidirectional(@NonNull ObjectProperty<@Nullable T> selectedValue, @NonNull SelectionModel<T> selectionModel) {
        final IDisposable valueToModelListener = ObservableUtils.onChange(selectedValue, (T n) -> {
            if (n == null) {
                selectionModel.clearSelection();
            } else {
                selectionModel.select(n);
            }
        });
        final IDisposable modelToValueListener = ObservableUtils.onChange(selectionModel.selectedItemProperty(), (T n) -> selectedValue.set(n));
        return new IDisposable(){

            public void dispose() {
                valueToModelListener.dispose();
                modelToValueListener.dispose();
            }
        };
    }

    public static <T> @NonNull IDisposable bindSingleSelectionHiddenFocus(@NonNull SelectionModel<T> selectionModel, @NonNull FocusModel<T> focusModel, @NonNull Predicate<T> predicate) {
        return ObservableUtils.bindSingleSelectionHiddenFocus(Platform::runLater, selectionModel, focusModel, predicate);
    }

    public static <V> @NonNull IDisposable hideChild(@NonNull ObservableBooleanValue hiddenProperty, @NonNull List<@NonNull V> childList, @NonNull V child) {
        return ObservableUtils.onChange(hiddenProperty, (T hidden) -> {
            if (hidden.booleanValue()) {
                childList.clear();
            } else {
                ListUtils.addOrSetAtIndexZero((List)childList, (Object)child);
            }
        });
    }

    public static <T, R> @NonNull IDisposable mapValue(@NonNull ObservableValue<T> input, @NonNull WritableValue<R> output, @NonNull Function<T, R> mapper) {
        return ObservableUtils.onChange(input, (T n) -> output.setValue(mapper.apply(n)));
    }

    public static <T> @NonNull IDisposable onChange(@NonNull ObservableValue<T> input, @NonNull BiConsumer<@Nullable T, T> consumer) {
        return new OnChangeBiConsumer<T>(input, consumer);
    }

    public static <T> @NonNull IDisposable onChange(@NonNull ObservableValue<T> input, @NonNull Consumer<T> consumer) {
        return ObservableUtils.onChange(input, (T o, T n) -> consumer.accept(n));
    }

    static <T> @NonNull IDisposable bindSingleSelectionHiddenFocus(@NonNull Consumer<@NonNull Runnable> runLater, @NonNull SelectionModel<T> selectionModel, @NonNull FocusModel<T> focusModel, @NonNull Predicate<T> predicate) {
        final IDisposable focusIndexListener = ObservableUtils.onChange(focusModel.focusedIndexProperty(), (T i) -> runLater.accept(() -> {
            if (!predicate.test(selectionModel.selectedItemProperty().get())) {
                focusModel.focus(-1);
            }
        }));
        final IDisposable selectionIndexListener = ObservableUtils.onChange(selectionModel.selectedItemProperty(), (T i) -> runLater.accept(() -> {
            if (!predicate.test(i)) {
                focusModel.focus(-1);
            }
        }));
        return new IDisposable(){

            public void dispose() {
                focusIndexListener.dispose();
                selectionIndexListener.dispose();
            }
        };
    }

    private static final class OnChangeBiConsumer<T>
    implements IDisposable,
    ChangeListener<T> {
        private final @NonNull BiConsumer<@Nullable T, T> consumer;
        private final @NonNull ObservableValue<T> input;
        private final @NonNull WeakChangeListener<T> weakListener;

        public OnChangeBiConsumer(@NonNull ObservableValue<T> input, @NonNull BiConsumer<@Nullable T, T> consumer) {
            this.input = input;
            this.consumer = consumer;
            this.weakListener = new WeakChangeListener((ChangeListener)this);
            input.addListener(this.weakListener);
            consumer.accept(null, input.getValue());
        }

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            this.consumer.accept(oldValue, newValue);
        }

        public void dispose() {
            this.input.removeListener(this.weakListener);
        }
    }
}

