/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.controls.table.SvgImageTableCell;
import com.arm.streamline.ui.controls.table.TooltipTableRow;
import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.utils.BidirectionalKeyedToggleGroup;
import com.arm.streamline.ui.utils.NodeUtils;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.utils.SvgImageUtility;
import com.arm.streamline.ui.vm.ILandingPageTcpSubViewViewModel;
import com.arm.streamline.ui.vm.ITargetDevice;
import com.arm.streamline.ui.vm.ITcpTargetDevice;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ui.services.IDisposable;

public final class LandingPageTcpSubView {
    @FXML
    private RadioButton btnEnterTargetDetails;
    @FXML
    private RadioButton btnPickExistingTarget;
    @FXML
    private TableColumn<ITcpTargetDevice, String> colAddress;
    @FXML
    private TableColumn<ITcpTargetDevice, String> colDetails;
    @FXML
    private TableColumn<ITcpTargetDevice, ITcpTargetDevice.Status> colStatus;
    @FXML
    private HBox hbxMissingAdbLabel;
    @FXML
    private Hyperlink lnkPlacholder_Android;
    @FXML
    private Hyperlink lnkPlacholder_Linux;
    @FXML
    private Hyperlink lnkShowAdbLocationPref;
    private final @NonNull VBox rootNode;
    @FXML
    private TableView<ITcpTargetDevice> tblExistingTargets;
    @FXML
    private TextFlow txfMissingAdbLabel;
    @FXML
    private TextField txtRunCommand;
    @FXML
    private TextField txtTargetAddress;
    @FXML
    private TextField txtWorkingDir;
    @FXML
    private TextField txtUserName;
    @FXML
    private CheckBox cbxStopOnExit;
    private final @NonNull IDisposable selectionChangeListener;
    private final @NonNull IDisposable hasValidAdbToolPathSetChangeListener;
    private final @NonNull BidirectionalKeyedToggleGroup<ILandingPageTcpSubViewViewModel.ActiveAddressSource, RadioButton> toggleGroup;
    private final @NonNull IDisposable focusSelectionListener;

    public LandingPageTcpSubView(@NonNull ILandingPageTcpSubViewViewModel viewModel, boolean licenseSupportsAndroid, boolean licenseSupportsLinux) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(LandingPageScene.class.getResource("/resources/fxml/landing-page-tcp-target-subview.fxml"));
        fxmlLoader.setResources(ResourceBundle.getBundle("com.arm.streamline.ui.part.LandingPageFxmlMessages"));
        fxmlLoader.setController((Object)this);
        this.rootNode = (VBox)fxmlLoader.load();
        this.toggleGroup = BidirectionalKeyedToggleGroup.create(viewModel.activeAddressSourceProperty(), Map.of(ILandingPageTcpSubViewViewModel.ActiveAddressSource.ADDRESS_INPUT, (RadioButton)NullChecking.neverNull((Object)this.btnEnterTargetDetails), ILandingPageTcpSubViewViewModel.ActiveAddressSource.TARGET_TABLE, (RadioButton)NullChecking.neverNull((Object)this.btnPickExistingTarget)));
        this.btnPickExistingTarget.disableProperty().bind((ObservableValue)viewModel.disableDeviceTableSelectionProperty());
        this.colStatus.setCellFactory(c -> new SvgImageTableCell(true, SvgImageUtility::mapStatusToSvgImage, s -> null, s -> null));
        this.colStatus.setCellValueFactory(d -> new SimpleObjectProperty((Object)((ITcpTargetDevice)d.getValue()).getStatus()));
        this.colAddress.setCellValueFactory(d -> new SimpleStringProperty(((ITcpTargetDevice)d.getValue()).getTargetAddress()));
        this.colDetails.setCellValueFactory(d -> new SimpleStringProperty(((ITcpTargetDevice)d.getValue()).getDescription()));
        this.tblExistingTargets.setRowFactory(v -> TooltipTableRow.fromUnobservable(ITargetDevice::getTooltip));
        this.tblExistingTargets.setItems(viewModel.detectedDevicesProperty());
        TableView.TableViewFocusModel focusModel = this.tblExistingTargets.getFocusModel();
        TableView.TableViewSelectionModel selectionModel = this.tblExistingTargets.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.SINGLE);
        this.selectionChangeListener = ObservableUtils.bindSingleSelectionBidirectional(viewModel.selectedDetectedDeviceProperty(), selectionModel);
        this.focusSelectionListener = ObservableUtils.bindSingleSelectionHiddenFocus(selectionModel, focusModel, viewModel::canFocusOnDeviceTableEntry);
        this.txtTargetAddress.textProperty().bindBidirectional(viewModel.addressInputTextProperty());
        this.txtRunCommand.textProperty().bindBidirectional(viewModel.commandPathTextProperty());
        this.txtWorkingDir.textProperty().bindBidirectional(viewModel.commandWorkingDirTextProperty());
        this.txtUserName.textProperty().bindBidirectional(viewModel.commandUserNameTextProperty());
        this.cbxStopOnExit.selectedProperty().bindBidirectional((Property)viewModel.commandStopOnExitProperty());
        this.hasValidAdbToolPathSetChangeListener = ObservableUtils.hideChild(viewModel.hasValidAdbToolPathSetProperty(), this.hbxMissingAdbLabel.getChildren(), this.txfMissingAdbLabel);
        this.lnkShowAdbLocationPref.setOnAction(e -> viewModel.doShowAdbPathConfigurationPreference());
        if (licenseSupportsAndroid) {
            this.lnkPlacholder_Android.setOnAction(e -> viewModel.doShowAndroidTargetHelp());
        } else {
            this.lnkPlacholder_Android.setDisable(true);
        }
        if (licenseSupportsLinux) {
            this.lnkPlacholder_Linux.setOnAction(e -> viewModel.doShowLinuxTargetHelp());
        } else {
            this.lnkPlacholder_Linux.setDisable(true);
        }
        NodeUtils.createTooltipBoundToPromptText(this.txtTargetAddress);
        NodeUtils.createTooltipBoundToPromptText(this.txtRunCommand);
        NodeUtils.createTooltipBoundToPromptText(this.txtWorkingDir);
        NodeUtils.createTooltipBoundToPromptText(this.txtUserName);
    }

    public @NonNull Node getNode() {
        return this.rootNode;
    }
}

