/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.utils.NodeUtils;
import com.arm.streamline.ui.vm.ILandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class LandingPageSshSubView {
    @FXML
    private RadioButton btnEnterTargetDetails;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colName;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colHost;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colUser;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colSshPort;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colGatorPort;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colEdit;
    @FXML
    private Button btnAddTarget;
    @FXML
    private Button btnModify;
    @FXML
    private Button btnDelete;
    private final @NonNull VBox rootNode;
    @FXML
    private TableView<ISshTargetLauncher> tblExistingTargetsSsh;
    @FXML
    private TextFlow txfMissingAdbLabel;
    @FXML
    private TextField txtRunCommand;
    @FXML
    private TextField txtWorkingDir;
    @FXML
    private TextField txtUserName;
    @FXML
    private CheckBox cbxStopOnExit;

    public LandingPageSshSubView(@NonNull ILandingPageSshSubViewViewModel viewModel) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(LandingPageScene.class.getResource("/resources/fxml/landing-page-ssh-target-subview.fxml"));
        fxmlLoader.setResources(ResourceBundle.getBundle("com.arm.streamline.ui.part.LandingPageFxmlMessages"));
        fxmlLoader.setController((Object)this);
        this.rootNode = (VBox)fxmlLoader.load();
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("profileName"));
        this.colHost.setCellValueFactory((Callback)new PropertyValueFactory("targetAddress"));
        this.colUser.setCellValueFactory((Callback)new PropertyValueFactory("userName"));
        this.colSshPort.setCellValueFactory((Callback)new PropertyValueFactory("sshPort"));
        this.colGatorPort.setCellValueFactory((Callback)new PropertyValueFactory("gatorPort"));
        this.txtRunCommand.textProperty().bindBidirectional(viewModel.commandPathTextProperty());
        this.txtWorkingDir.textProperty().bindBidirectional(viewModel.commandWorkingDirTextProperty());
        this.txtUserName.textProperty().bindBidirectional(viewModel.commandUserNameTextProperty());
        this.cbxStopOnExit.selectedProperty().bindBidirectional((Property)viewModel.commandStopOnExitProperty());
        NodeUtils.createTooltipBoundToPromptText(this.txtRunCommand);
        NodeUtils.createTooltipBoundToPromptText(this.txtWorkingDir);
        NodeUtils.createTooltipBoundToPromptText(this.txtUserName);
        this.tblExistingTargetsSsh.setItems(viewModel.detectedDevicesProperty());
        TableView.TableViewSelectionModel selectionModel = this.tblExistingTargetsSsh.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.SINGLE);
        this.btnModify.setDisable(true);
        this.btnDelete.setDisable(true);
        this.tblExistingTargetsSsh.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            this.btnModify.setDisable(false);
            this.btnDelete.setDisable(false);
            for (ISshTargetLauncher sshTarget : this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems()) {
                if (sshTarget == null) continue;
                viewModel.setSelectedDeviceIfPresent(sshTarget);
            }
        });
        this.btnAddTarget.setOnMouseClicked(e -> {
            viewModel.doShowSSHConfiguration(null);
            if (!this.tblExistingTargetsSsh.getItems().isEmpty()) {
                int lastAdded = this.tblExistingTargetsSsh.getItems().size() - 1;
                this.tblExistingTargetsSsh.requestFocus();
                this.tblExistingTargetsSsh.getSelectionModel().select(lastAdded);
                this.tblExistingTargetsSsh.getFocusModel().focus(lastAdded);
            }
        });
        this.btnModify.setOnMouseClicked(e -> {
            for (ISshTargetLauncher sshTarget : this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems()) {
                if (sshTarget == null) continue;
                int pos = this.tblExistingTargetsSsh.getItems().indexOf((Object)sshTarget);
                viewModel.doShowSSHConfiguration(sshTarget);
                viewModel.setSelectedDeviceIfPresent(sshTarget);
                this.tblExistingTargetsSsh.getSelectionModel().select(pos);
                this.tblExistingTargetsSsh.getFocusModel().focus(pos);
                break;
            }
            this.tblExistingTargetsSsh.refresh();
        });
        this.btnDelete.setOnMouseClicked(e -> {
            viewModel.removeDevices((ObservableList<ISshTargetLauncher>)this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems());
            if (this.tblExistingTargetsSsh.getItems().isEmpty()) {
                this.btnModify.setDisable(true);
                this.btnDelete.setDisable(true);
                viewModel.selectedDetectedDeviceProperty().set(null);
            } else {
                int lastElem = this.tblExistingTargetsSsh.getItems().size() - 1;
                this.tblExistingTargetsSsh.getSelectionModel().select(lastElem);
                this.tblExistingTargetsSsh.getFocusModel().focus(lastElem);
            }
        });
    }

    private static @Nullable Shell getShell() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return null;
        }
        return aww.getShell();
    }

    public @NonNull Node getNode() {
        return this.rootNode;
    }
}

