/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls;

import com.arm.streamline.ui.controls.SimpleSvgObjectModelFactory;
import com.arm.streamline.ui.controls.SimpleSvgParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.layout.Region;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.SVGPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SvgImage
extends Region {
    private @NonNull SimpleBooleanProperty preserveAspectRatio = new SimpleBooleanProperty(true);
    private @NonNull ObservableList<@NonNull SVGPath> svgPaths = FXCollections.observableArrayList();
    private @NonNull SimpleDoubleProperty viewPortHeight = new SimpleDoubleProperty(0.0);
    private @NonNull SimpleDoubleProperty viewPortWidth = new SimpleDoubleProperty(0.0);

    public static @NonNull SvgImage load(@NonNull File file) throws IOException {
        SimpleSvgVisitorFactory visitorFactory = new SimpleSvgVisitorFactory();
        SimpleSvgParser.load(file, (SimpleSvgParser.ISimpleSvgVisitorFactory)visitorFactory);
        return visitorFactory.newImage;
    }

    public static @NonNull SvgImage load(@NonNull InputStream stream) throws IOException {
        SimpleSvgVisitorFactory visitorFactory = new SimpleSvgVisitorFactory();
        SimpleSvgParser.load(stream, (SimpleSvgParser.ISimpleSvgVisitorFactory)visitorFactory);
        return visitorFactory.newImage;
    }

    public static @NonNull SvgImage load(@NonNull SimpleSvgObjectModelFactory.SimpleSvg svg) {
        SimpleSvgVisitorFactory visitorFactory = new SimpleSvgVisitorFactory();
        svg.accept(visitorFactory);
        return visitorFactory.newImage;
    }

    private static double calcLayout(double nodeLength, double viewportLength) {
        return nodeLength / 2.0 - viewportLength / 2.0;
    }

    private static double calcScale(double nodeLength, double viewportLength) {
        return viewportLength > 0.0 ? nodeLength / viewportLength : 0.0;
    }

    private static void update(double ndWidth, double ndHeight, double vpWidth, double vpHeight, boolean preserve, @NonNull List<? extends SVGPath> paths) {
        double scaleWidth = SvgImage.calcScale(ndWidth, vpWidth);
        double scaleHeight = SvgImage.calcScale(ndHeight, vpHeight);
        double layoutWidth = SvgImage.calcLayout(ndWidth, vpWidth);
        double layoutHeight = SvgImage.calcLayout(ndHeight, vpHeight);
        if (preserve) {
            double scale = Math.min(scaleWidth, scaleHeight);
            paths.forEach(p -> {
                assert (p != null);
                p.setManaged(false);
                p.setScaleX(scale);
                p.setScaleY(scale);
                p.setLayoutX(layoutWidth);
                p.setLayoutY(layoutHeight);
            });
        } else {
            paths.forEach(p -> {
                assert (p != null);
                p.setManaged(false);
                p.setScaleX(scaleWidth);
                p.setScaleY(scaleHeight);
                p.setLayoutX(layoutWidth);
                p.setLayoutY(layoutHeight);
            });
        }
    }

    public SvgImage() {
        this.preserveAspectRatio.addListener((a, b, c) -> SvgImage.update(this.getWidth(), this.getHeight(), this.viewPortWidth.get(), this.viewPortHeight.get(), c, this.svgPaths));
        this.viewPortWidth.addListener((a, b, c) -> SvgImage.update(this.getWidth(), this.getHeight(), c.doubleValue(), this.viewPortHeight.get(), this.preserveAspectRatio.get(), this.svgPaths));
        this.viewPortHeight.addListener((a, b, c) -> SvgImage.update(this.getWidth(), this.getHeight(), this.viewPortWidth.get(), c.doubleValue(), this.preserveAspectRatio.get(), this.svgPaths));
        this.widthProperty().addListener((a, b, c) -> SvgImage.update(c.doubleValue(), this.getHeight(), this.viewPortWidth.get(), this.viewPortHeight.get(), this.preserveAspectRatio.get(), this.svgPaths));
        this.heightProperty().addListener((a, b, c) -> SvgImage.update(this.getWidth(), c.doubleValue(), this.viewPortWidth.get(), this.viewPortHeight.get(), this.preserveAspectRatio.get(), this.svgPaths));
        this.svgPaths.addListener(change -> {
            double ndWidth = this.getWidth();
            double ndHeight = this.getHeight();
            double vpWidth = this.viewPortWidth.get();
            double vpHeight = this.viewPortHeight.get();
            boolean preserve = this.preserveAspectRatio.get();
            while (change.next()) {
                if (!change.wasAdded()) continue;
                SvgImage.update(ndWidth, ndHeight, vpWidth, vpHeight, preserve, change.getAddedSubList());
            }
        });
        Bindings.bindContent((List)this.getChildren(), this.svgPaths);
    }

    public boolean getPreserveAspectRatio() {
        return this.preserveAspectRatio.get();
    }

    public @NonNull ObservableList<@NonNull SVGPath> getSvgPaths() {
        return this.svgPaths;
    }

    public String getTypeSelector() {
        return "SvgImage";
    }

    public double getViewPortHeight() {
        return this.viewPortHeight.get();
    }

    public double getViewPortWidth() {
        return this.viewPortWidth.get();
    }

    public @NonNull BooleanProperty preserveAspectRatioProperty() {
        return this.preserveAspectRatio;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio.set(preserveAspectRatio);
    }

    public void setSvgPaths(@NonNull List<@NonNull SVGPath> svgPaths) {
        this.svgPaths.setAll(svgPaths);
    }

    public void setViewPortHeight(double viewPortHeight) {
        this.viewPortHeight.set(viewPortHeight);
    }

    public void setViewPortWidth(double viewPortWidth) {
        this.viewPortWidth.set(viewPortWidth);
    }

    public @NonNull ObservableList<@NonNull SVGPath> svgPathsProperty() {
        return this.svgPaths;
    }

    public @NonNull DoubleProperty viewPortHeightProperty() {
        return this.viewPortHeight;
    }

    public @NonNull DoubleProperty viewPortWidthProperty() {
        return this.viewPortWidth;
    }

    public static final class SimpleSvgVisitorFactory
    implements SimpleSvgParser.ISimpleSvgVisitorFactory {
        public final @NonNull SvgImage newImage = new SvgImage();

        @Override
        public @NonNull SimpleSvgParser.ISimpleSvgVisitor create(@NonNull Set<@NonNull String> classes, @NonNull String width, @NonNull String height, final @Nullable Bounds viewBox, @NonNull String fill) {
            if (viewBox != null) {
                this.newImage.viewPortWidthProperty().set(viewBox.getWidth());
                this.newImage.viewPortHeightProperty().set(viewBox.getHeight());
            }
            return new SimpleSvgParser.ISimpleSvgVisitor(){

                @Override
                public void path(@NonNull String fillRule, @NonNull String fill, @NonNull String d) {
                    SVGPath p = new SVGPath();
                    p.setManaged(false);
                    p.setFillRule("evenodd".contentEquals(fillRule) ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
                    if (viewBox != null) {
                        p.setContent(String.format("M %s %s M %s %s Z %s", viewBox.getMinX(), viewBox.getMinY(), viewBox.getMaxX(), viewBox.getMaxY(), d));
                    } else {
                        p.setContent(d);
                    }
                    newImage.svgPathsProperty().add((Object)p);
                }
            };
        }
    }
}

