/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf.viewmodel;

import com.arm.streamline.astf.ASTFClusterInfo;
import com.arm.streamline.astf.ASTFCoreInfo;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import com.arm.utils.collections.Pair;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class ASTFImportUtility {
    private static final String CLUSTER_CORE_REGEX = "(?i)(?:^|[_\\.])(?<type>cluster|core|cpu)(?<num>\\d+)(?=$|[_\\.])";
    private static final String ASTF_EXTENSION = ".astf";

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull ASTFClusterInfo> getClusterInfos(@NonNull List<@NonNull ASTFImportFileModel> astfFiles) throws IOException {
        HashMap<Integer, @NonNull ASTFClusterInfo> clusterMap = new HashMap<Integer, ASTFClusterInfo>();
        HashMap<K, @NonNull V> clusterCoreMap = new HashMap();
        AtomicInteger coreCounter = new AtomicInteger(0);
        AtomicInteger cpuCounterID = new AtomicInteger(1);
        for (ASTFImportFileModel file : astfFiles) {
            Integer clusterId = file.getClusterId();
            Integer coreId = file.getCoreId();
            if (clusterId == null) {
                throw new IOException(MessageFormat.format(Messages.ImportASTF_ClusterIdNull, file.getFileName()));
            }
            if (coreId == null) {
                throw new IOException(MessageFormat.format(Messages.ImportASTF_CoreIdNull, clusterId, file.getFileName()));
            }
            ASTFClusterInfo clusterInfo = clusterMap.computeIfAbsent(clusterId, id -> {
                String clusterName = String.format("Cluster %d", id);
                ASTFClusterInfo cluster = new ASTFClusterInfo(clusterName, (int)id);
                clusterCoreMap.put(id, new HashMap());
                return cluster;
            });
            @NonNull Map coreMap = (Map)clusterCoreMap.get(clusterId);
            if (coreMap == null) continue;
            ASTFCoreInfo coreInfo = coreMap.computeIfAbsent(coreId, relativeId -> {
                String coreName = String.format("Core %d", coreCounter.get());
                ASTFCoreInfo core = new ASTFCoreInfo(coreName, coreCounter.getAndIncrement(), cpuCounterID.getAndIncrement(), (int)relativeId);
                clusterInfo.addCore(core);
                return core;
            });
            coreInfo.addAstfDataFile(file.getFilePath());
        }
        return new ArrayList<ASTFClusterInfo>(clusterMap.values());
    }

    public static @NonNull Pair<Integer, Integer> parseClusterAndCoreFromFileName(@NonNull String filename) {
        Integer cluster = null;
        Integer core = null;
        String lower = filename.toLowerCase();
        if (!lower.endsWith(ASTF_EXTENSION)) {
            return new Pair(cluster, core);
        }
        String base = lower.substring(0, lower.length() - ASTF_EXTENSION.length());
        Pattern pattern = Pattern.compile(CLUSTER_CORE_REGEX);
        Matcher matcher = pattern.matcher(base);
        while (matcher.find()) {
            String type = matcher.group("type");
            String numStr = matcher.group("num");
            try {
                Integer num = Integer.valueOf(numStr);
                if ("cluster".equalsIgnoreCase(type)) {
                    cluster = num;
                    continue;
                }
                if (!"core".equalsIgnoreCase(type) && !"cpu".equalsIgnoreCase(type)) continue;
                core = num;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Pair(cluster, core);
    }
}

