/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BlockRowSorter
implements Comparator<BlockRow> {
    private BlockColumn[] mSortingOrder;

    public static Set<BlockRow> collectContainerRows(List<BlockRow> rows, Set<BlockRow> containers) {
        for (BlockRow row : rows) {
            if (!row.canHaveChildren()) continue;
            containers.add(row);
            if (!row.hasChildren()) continue;
            BlockRowSorter.collectContainerRows(row.getChildren(), containers);
        }
        return containers;
    }

    public static void sort(List<BlockColumn> columns, List<BlockRow> rows) {
        BlockRowSorter.sort(columns, rows, false);
    }

    public static void sort(List<BlockColumn> columns, List<BlockRow> rows, boolean internal) {
        for (BlockColumn column : columns) {
            if (column.getSortSequence() == -1) continue;
            BlockRowSorter rowSorter = new BlockRowSorter(columns);
            Collections.sort(rows, rowSorter);
            if (internal) {
                for (BlockRow row : BlockRowSorter.collectContainerRows(rows, new HashSet<BlockRow>())) {
                    if (!row.hasChildren()) continue;
                    Collections.sort(row.getChildList(), rowSorter);
                }
            }
            return;
        }
    }

    private BlockRowSorter(List<BlockColumn> columns) {
        int count = columns.size();
        BlockColumn[] orig = new BlockColumn[count];
        int pos = -1;
        this.mSortingOrder = new BlockColumn[count];
        int i = 0;
        while (i < count) {
            BlockColumn column = columns.get(i);
            int order = column.getSortSequence();
            if (order >= 0 && order < count) {
                this.mSortingOrder[order] = column;
            } else {
                orig[i] = column;
                if (pos == -1) {
                    pos = i;
                }
            }
            ++i;
        }
        if (pos != -1) {
            i = 0;
            while (i < count) {
                if (this.mSortingOrder[i] == null) {
                    this.mSortingOrder[i] = orig[pos++];
                    while (pos < count && orig[pos] == null) {
                        ++pos;
                    }
                    if (pos >= count) break;
                }
                ++i;
            }
        }
    }

    @Override
    public int compare(BlockRow rowOne, BlockRow rowTwo) {
        if (rowOne.getParent() == rowTwo.getParent()) {
            BlockColumn[] blockColumnArray = this.mSortingOrder;
            int n = this.mSortingOrder.length;
            int n2 = 0;
            while (n2 < n) {
                BlockColumn column = blockColumnArray[n2];
                if (column == null) {
                    return 0;
                }
                int result = column.getRowCell(null).compare(column, rowOne, rowTwo);
                if (result != 0) {
                    return column.isSortAscending() ? result : -result;
                }
                ++n2;
            }
        } else {
            if (rowOne.isDescendentOf(rowTwo)) {
                return 1;
            }
            if (rowTwo.isDescendentOf(rowOne)) {
                return -1;
            }
            BlockRow[] oneParents = rowOne.getPath();
            BlockRow[] twoParents = rowTwo.getPath();
            int max = Math.min(oneParents.length, twoParents.length);
            int i = 0;
            while (i < max) {
                if (oneParents[i] != twoParents[i]) break;
                ++i;
            }
            return this.compare(oneParents[i], twoParents[i]);
        }
        return 0;
    }
}

