/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import com.arm.streamline.widget.outline.PercentageCell;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockPercentageCell
implements IBlockCell {
    private final int mMinimumBarWidth;
    private final boolean mWholeNumbersOnly;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference mColourPreference;
    private final @Nullable Integer mUserRGB;

    public static void draw(GC gc, Font font, Rectangle bounds, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer mUserRGB) {
        PercentageCell.drawPercentage(gc, font, bounds, percentage, wholeNumbersOnly, selected, active, colourPreference, mUserRGB);
    }

    public static int getMinimumContentWidth(Font font, boolean wholeNumbersOnly) {
        return FontInfo.get((Font)font).getExtent((String)NumberUtils.formatPercentage((double)99.999, (boolean)wholeNumbersOnly)).x + 8;
    }

    public BlockPercentageCell(boolean wholeNumbersOnly) {
        this(100, wholeNumbersOnly);
    }

    public BlockPercentageCell(int minimumBarWidth, boolean wholeNumbersOnly) {
        this(minimumBarWidth, wholeNumbersOnly, IColumnDescriptor.ColourPreference.lower_is_better, null);
    }

    public BlockPercentageCell(int minimumBarWidth, boolean wholeNumbersOnly, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        this.mMinimumBarWidth = minimumBarWidth;
        this.mWholeNumbersOnly = wholeNumbersOnly;
        this.mColourPreference = colourPreference;
        this.mUserRGB = userRGB;
    }

    @Override
    public int compare(BlockColumn column, BlockRow one, BlockRow two) {
        double p2;
        double p1 = this.getPercentage(one, column);
        if (p1 < (p2 = this.getPercentage(two, column))) {
            return -1;
        }
        if (p1 > p2) {
            return 1;
        }
        return 0;
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, BlockRow row, BlockColumn column, boolean selected, boolean active) {
        BlockPercentageCell.draw(gc, Fonts.getNormal(), bounds, this.getPercentage(row, column), this.mWholeNumbersOnly, selected, active, this.mColourPreference, this.mUserRGB);
    }

    @Override
    public int getMinimumContentWidth() {
        return WorkspaceUtils.isHeadless() ? 0 : BlockPercentageCell.getMinimumContentWidth(Fonts.getNormal(), this.mWholeNumbersOnly);
    }

    public double getPercentage(BlockRow row, BlockColumn column) {
        return row.getDataAsDouble(column);
    }

    @Override
    public Point getPreferredSize(GC gc, BlockRow row, BlockColumn column) {
        gc.setFont(Fonts.getNormal());
        Point size = gc.stringExtent(NumberUtils.formatPercentage((double)99.999, (boolean)this.mWholeNumbersOnly));
        size.x += this.mMinimumBarWidth + 12;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(BlockOutline outline, BlockRow row, BlockColumn column) {
        return null;
    }
}

