/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.BlockRowSorter;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineModelListener;
import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.StdSelection;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class BlockOutlineModel
implements IStdSelectionOwner {
    private List<IBlockOutlineModelListener> mListeners = new ArrayList<IBlockOutlineModelListener>();
    private List<BlockColumn> mColumns = new ArrayList<BlockColumn>();
    private List<BlockRow> mRows = new ArrayList<BlockRow>();
    private List<BlockRow> mTopLevelRows;
    private Set<BlockRow> mRowSet = new HashSet<BlockRow>();
    private TObjectIntHashMap<BlockRow> mRowIndexes;
    private StdSelection mSelection = new StdSelection(this);
    private boolean mNotifyOfSelections = true;
    private BlockRow mSavedAnchorRow;
    private List<BlockRow> mSavedSelection;
    private boolean mShowIndent;
    private boolean mShowOutline = true;
    private int mIndentWidth;
    private int mRowHeight;
    private Object mUserRef;
    private boolean mExporting;
    private boolean mAccumulateRowOpens;
    private Set<BlockRow> mRowsToOpen;
    private int mPreservationDepth = 0;

    public void addColumn(BlockColumn column) {
        this.mColumns.add(column);
        column.getHeaderCell().setOutlineModel(this);
    }

    public void addColumn(int index, BlockColumn column) {
        this.mColumns.add(index, column);
        column.getHeaderCell().setOutlineModel(this);
    }

    public void addColumns(List<BlockColumn> columns) {
        for (BlockColumn column : columns) {
            this.addColumn(column);
        }
    }

    public void addListener(IBlockOutlineModelListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void addNonHierarchicalRowsFast(Collection<? extends @NonNull BlockRow> rows, boolean clearSort) {
        this.mTopLevelRows = null;
        for (BlockRow blockRow : rows) {
            blockRow.setOwner(this);
        }
        this.preserveSelection();
        this.mRowIndexes = null;
        this.mRows.addAll(rows);
        this.mRowSet.addAll(rows);
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowAdditions(rows.toArray(new BlockRow[rows.size()]));
        if (clearSort) {
            this.clearSort();
        }
    }

    public void addRow(BlockRow row) {
        this.addRow(row, false);
    }

    public void addRow(BlockRow row, boolean includeChildren) {
        this.addRow(this.getRowCount(), row, includeChildren);
    }

    public void addRow(int index, BlockRow row) {
        this.addRow(index, row, false);
    }

    public void addRow(int index, BlockRow row, boolean includeChildren) {
        ArrayList<BlockRow> list = new ArrayList<BlockRow>();
        this.mTopLevelRows = null;
        if (includeChildren) {
            this.collectRowsAndSetOwner(list, row, false);
        } else {
            list.add(row);
            row.setOwner(this);
        }
        this.preserveSelection();
        this.mRowIndexes = null;
        this.mRows.addAll(index, list);
        this.mRowSet.addAll(list);
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowAdditions(list.toArray(new BlockRow[list.size()]));
        this.clearSort();
    }

    public boolean canSelectAll() {
        return this.mSelection.canSelectAll();
    }

    public void clearSort() {
        if (this.clearSortWithoutNotify()) {
            this.notifyOfSortCleared();
        }
    }

    public boolean clearSortWithoutNotify() {
        int count = this.getColumnCount();
        boolean notify = false;
        int i = 0;
        while (i < count) {
            BlockColumn column = this.getColumnAtIndex(i);
            if (column.getSortSequence() != -1) {
                column.setSortCriteria(-1, column.isSortAscending());
                notify = true;
            }
            ++i;
        }
        return notify;
    }

    public List<BlockRow> collectRowsAndSetOwner(List<BlockRow> list, BlockRow row, boolean childrenOnly) {
        if (!childrenOnly) {
            list.add(row);
            row.setOwner(this);
        }
        if (row.isOpen() && row.hasChildren()) {
            for (BlockRow row2 : row.getChildren()) {
                this.collectRowsAndSetOwner(list, row2, false);
            }
        }
        return list;
    }

    public void deselect() {
        this.mSelection.deselect();
    }

    public void deselect(BlockRow row) {
        this.mSelection.deselect(this.getIndexOfRow(row));
    }

    public void deselect(int rowIndex) {
        this.mSelection.deselect(rowIndex);
    }

    public void deselect(int from, int to) {
        this.mSelection.deselect(from, to);
    }

    public void deselect(List<BlockRow> rows) {
        TIntHashSet set = new TIntHashSet();
        for (BlockRow row : rows) {
            set.add(this.getIndexOfRow(row));
        }
        this.mSelection.deselect(set.toArray());
    }

    public void dispose() {
        this.mListeners.clear();
        this.removeAllColumns();
        this.removeAllRows();
        this.mSavedAnchorRow = null;
        this.mSavedSelection = null;
        this.mUserRef = null;
    }

    public BlockColumn getColumnAtIndex(int index) {
        return this.mColumns.get(index);
    }

    public int getColumnCount() {
        return this.mColumns.size();
    }

    public List<BlockColumn> getColumns() {
        return this.mColumns;
    }

    public BlockColumn getColumnWithID(int id) {
        int count = this.getColumnCount();
        int i = 0;
        while (i < count) {
            BlockColumn column = this.getColumnAtIndex(i);
            if (column.getID() == id) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public BlockRow getFirstSelectedRow() {
        int index = this.getFirstSelectedRowIndex();
        return index == -1 ? null : this.getRowAtIndex(index);
    }

    public int getFirstSelectedRowIndex() {
        return this.mSelection.firstSelectedIndex();
    }

    public Collection<BlockColumn> getHiddenColumns() {
        ArrayList<BlockColumn> list = new ArrayList<BlockColumn>();
        for (BlockColumn column : this.mColumns) {
            if (column.isVisible()) continue;
            list.add(column);
        }
        return list;
    }

    public int getIndentWidth() {
        return this.mIndentWidth;
    }

    public int getIndentWidth(BlockRow row, BlockColumn column) {
        if (this.mShowIndent && column.isPrimary()) {
            return this.getIndentWidth() * ((this.showOutline() ? 1 : 0) + row.getDepth());
        }
        return 0;
    }

    public int getIndexOfColumn(BlockColumn column) {
        return this.mColumns.indexOf(column);
    }

    public int getIndexOfRow(BlockRow row) {
        if (this.mRowIndexes == null) {
            this.mRowIndexes = new TObjectIntHashMap();
            int count = this.getRowCount();
            int i = 0;
            while (i < count) {
                this.mRowIndexes.put((Object)this.mRows.get(i), i);
                ++i;
            }
        }
        return this.mRowIndexes.get((Object)row);
    }

    public BlockRow getLastSelectedRow() {
        int index = this.getLastSelectedRowIndex();
        return index == -1 ? null : this.getRowAtIndex(index);
    }

    public int getLastSelectedRowIndex() {
        return this.mSelection.lastSelectedIndex();
    }

    public int getRecursiveRowCount() {
        List<BlockRow> list = this.getTopLevelRows();
        int count = list.size();
        for (BlockRow row : list) {
            count += row.getRecursiveChildCount();
        }
        return count;
    }

    public BlockRow getRowAtIndex(int index) {
        return this.mRows.get(index);
    }

    public int getRowCount() {
        return this.mRows.size();
    }

    public int getRowHeight() {
        return this.mRowHeight;
    }

    public List<BlockRow> getRows() {
        return this.mRows;
    }

    @Override
    public Object getSelectableObjectAtIndex(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return null;
        }
        return this.getRowAtIndex(index);
    }

    public StdSelection getSelection() {
        return this.mSelection;
    }

    public List<BlockRow> getSelectionAsList() {
        return this.getSelectionAsList(false);
    }

    public List<BlockRow> getSelectionAsList(boolean minimal) {
        ArrayList<BlockRow> list = new ArrayList<BlockRow>(this.mSelection.getCount());
        int index = this.mSelection.firstSelectedIndex();
        while (index != -1) {
            BlockRow row = this.getRowAtIndex(index);
            boolean add = true;
            if (minimal) {
                BlockRow parent = row.getParent();
                while (parent != null) {
                    if (this.mSelection.isSelected(this.getIndexOfRow(parent))) {
                        add = false;
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (add) {
                list.add(row);
            }
            index = this.mSelection.nextSelectedIndex(index + 1);
        }
        return list;
    }

    public int getSelectionCount() {
        return this.mSelection.getCount();
    }

    public List<BlockRow> getTopLevelRows() {
        if (this.mTopLevelRows == null) {
            this.mTopLevelRows = new ArrayList<BlockRow>();
            for (BlockRow row : this.mRows) {
                if (row.getParent() != null) continue;
                this.mTopLevelRows.add(row);
            }
        }
        return new ArrayList<BlockRow>(this.mTopLevelRows);
    }

    public Object getUserRef() {
        return this.mUserRef;
    }

    public int getVisibleColumnCount() {
        int count = 0;
        for (BlockColumn column : this.mColumns) {
            if (!column.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasSelection() {
        return !this.mSelection.isEmpty();
    }

    public boolean isExporting() {
        return this.mExporting;
    }

    public boolean isExtendedRowSelected(BlockRow row) {
        while (row != null) {
            if (this.isRowSelected(row)) {
                return true;
            }
            row = row.getParent();
        }
        return false;
    }

    public boolean isExtendedRowSelected(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return false;
        }
        return this.isExtendedRowSelected(this.getRowAtIndex(index));
    }

    public boolean isRowSelected(BlockRow row) {
        return this.mSelection.isSelected(this.getIndexOfRow(row));
    }

    public boolean isRowSelected(int index) {
        return this.mSelection.isSelected(index);
    }

    public void removeAllColumns() {
        this.mColumns.clear();
    }

    public void removeAllRows() {
        BlockRow[] rows = this.mRows.toArray(new BlockRow[0]);
        this.mTopLevelRows = null;
        this.mSelection.deselect();
        this.mSelection.setSize(0);
        this.notifyOfRowsWillBeRemoved(rows);
        this.mRowIndexes = null;
        this.mRows.clear();
        this.mRowSet.clear();
        BlockRow[] blockRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            BlockRow element = blockRowArray[n2];
            element.setOwner(null);
            ++n2;
        }
        this.notifyOfRowsWereRemoved(rows);
    }

    public void removeColumn(BlockColumn column) {
        this.mColumns.remove(column);
    }

    public void removeListener(IBlockOutlineModelListener listener) {
        this.mListeners.remove(listener);
    }

    public void removeRow(BlockRow row) {
        this.removeRows(new BlockRow[]{row});
    }

    public void removeRow(int index) {
        this.removeRows(new int[]{index});
    }

    public void removeRows(BlockRow[] rows) {
        TIntHashSet set = new TIntHashSet();
        BlockRow[] blockRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            BlockRow row = blockRowArray[n2];
            int n3 = index = this.mRowIndexes != null ? this.getIndexOfRow(row) : this.mRows.indexOf(row);
            if (index > -1) {
                this.collectRowIndexes(set, index);
            }
            ++n2;
        }
        this.removeRowsInternal(set.toArray());
    }

    public void removeRows(int[] indexes) {
        TIntHashSet set = new TIntHashSet();
        int max = this.getRowCount();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > -1 && index < max) {
                this.collectRowIndexes(set, index);
            }
            ++n2;
        }
        this.removeRowsInternal(set.toArray());
    }

    public void removeSelection() {
        int[] indexes = this.mSelection.getSelectedIndexes();
        this.mSelection.deselect();
        this.removeRows(indexes);
    }

    public void rowOpenStateChanged(BlockRow row, boolean open) {
        if (row.hasChildren() && this.mRowSet.contains(row)) {
            if (open) {
                if (this.mAccumulateRowOpens) {
                    BlockRow parent = row.getParent();
                    while (parent != null) {
                        if (this.mRowsToOpen.contains(parent)) {
                            return;
                        }
                        parent = parent.getParent();
                    }
                    this.mRowsToOpen.add(row);
                } else {
                    this.addChildren(row);
                }
            } else {
                this.removeRows(row.getChildren().toArray(new BlockRow[0]));
            }
        }
    }

    public void select() {
        this.mSelection.select();
    }

    public void select(BlockRow row, boolean add) {
        this.mSelection.select(this.getIndexOfRow(row), add);
    }

    public void select(Collection<? extends BlockRow> rows, boolean add) {
        TIntHashSet set = new TIntHashSet();
        for (BlockRow blockRow : rows) {
            set.add(this.getIndexOfRow(blockRow));
        }
        this.mSelection.select(set.toArray(), add);
    }

    public void select(int rowIndex, boolean add) {
        this.mSelection.select(rowIndex, add);
    }

    public void select(int from, int to, boolean add) {
        this.mSelection.select(from, to, add);
    }

    public void select(int[] rowIndexes, boolean add) {
        this.mSelection.select(rowIndexes, add);
    }

    @Override
    public void selectionAboutToChange() {
        if (this.mNotifyOfSelections) {
            IBlockOutlineModelListener[] listeners;
            IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
                element.selectionWillChange(this);
                ++n2;
            }
        }
    }

    @Override
    public void selectionDidChange() {
        if (this.mNotifyOfSelections) {
            IBlockOutlineModelListener[] listeners;
            IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
                element.selectionDidChange(this);
                ++n2;
            }
        }
    }

    public void setAccumulateRowOpens(boolean accumulate) {
        if (this.mAccumulateRowOpens != accumulate) {
            this.mAccumulateRowOpens = accumulate;
            if (accumulate) {
                this.mRowsToOpen = new HashSet<BlockRow>();
            } else {
                if (this.mRowsToOpen != null) {
                    for (BlockRow row : this.mRowsToOpen) {
                        this.rowOpenStateChanged(row, true);
                    }
                }
                this.mRowsToOpen = null;
            }
        }
    }

    public void setExporting(boolean exporting) {
        this.mExporting = exporting;
    }

    public void setIndentWidth(int width) {
        this.mIndentWidth = width;
    }

    public void setRowHeight(int height) {
        this.mRowHeight = height;
    }

    public void setShowIndent(boolean show) {
        this.mShowIndent = show;
    }

    public void setShowOutline(boolean show) {
        this.mShowOutline = show;
    }

    public void setUserRef(Object userRef) {
        this.mUserRef = userRef;
    }

    public boolean showIndent() {
        return this.mShowIndent;
    }

    public boolean showOutline() {
        return this.mShowOutline;
    }

    public void sort() {
        this.sort(false);
    }

    public void sort(boolean restoring) {
        this.mTopLevelRows = null;
        this.preserveSelection();
        this.mRowIndexes = null;
        BlockRowSorter.sort(this.mColumns, this.mRows, true);
        this.restoreSelection();
        this.notifyOfSort(restoring);
    }

    private void addChildren(BlockRow row) {
        List<BlockRow> list = this.collectRowsAndSetOwner(new ArrayList<BlockRow>(), row, true);
        this.preserveSelection();
        this.mRows.addAll(this.mRows.indexOf(row) + 1, list);
        this.mRowSet.addAll(list);
        this.mSelection.setSize(this.getRowCount());
        this.mRowIndexes = null;
        this.restoreSelection();
        this.notifyOfRowAdditions(list.toArray(new BlockRow[0]));
    }

    private int collectRowIndexes(TIntHashSet set, int index) {
        BlockRow row = this.getRowAtIndex(index);
        int max = this.getRowCount();
        set.add(index++);
        while (index < max) {
            BlockRow next = this.getRowAtIndex(index);
            if (!next.isDescendentOf(row)) break;
            set.add(index++);
        }
        return index;
    }

    private IBlockOutlineModelListener[] getCurrentListeners() {
        return this.mListeners.toArray(new IBlockOutlineModelListener[0]);
    }

    private void notifyOfRowAdditions(BlockRow[] rows) {
        IBlockOutlineModelListener[] listeners;
        IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
            element.rowsAdded(this, rows);
            ++n2;
        }
    }

    private void notifyOfRowsWereRemoved(BlockRow[] rows) {
        IBlockOutlineModelListener[] listeners;
        IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
            element.rowsWereRemoved(this, rows);
            ++n2;
        }
    }

    private void notifyOfRowsWillBeRemoved(BlockRow[] rows) {
        IBlockOutlineModelListener[] listeners;
        IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
            element.rowsWillBeRemoved(this, rows);
            ++n2;
        }
    }

    private void notifyOfSort(boolean restoring) {
        IBlockOutlineModelListener[] listeners;
        IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
            element.sorted(this, restoring);
            ++n2;
        }
    }

    private void removeRowsInternal(int[] indexes) {
        BlockRow[] rows = new BlockRow[indexes.length];
        this.mTopLevelRows = null;
        Arrays.sort(indexes);
        int i = 0;
        while (i < indexes.length) {
            rows[i] = this.getRowAtIndex(indexes[i]);
            ++i;
        }
        this.preserveSelection();
        this.notifyOfRowsWillBeRemoved(rows);
        this.mRowIndexes = null;
        i = indexes.length - 1;
        while (i >= 0) {
            this.mRowSet.remove(this.mRows.remove(indexes[i]));
            rows[i].setOwner(null);
            --i;
        }
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowsWereRemoved(rows);
    }

    void notifyOfSortCleared() {
        IBlockOutlineModelListener[] listeners;
        IBlockOutlineModelListener[] iBlockOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineModelListener element = iBlockOutlineModelListenerArray[n2];
            element.sortCleared(this);
            ++n2;
        }
    }

    void preserveSelection() {
        if (this.mPreservationDepth++ == 0) {
            int anchor = this.mSelection.getAnchor();
            this.mSavedAnchorRow = anchor != -1 ? this.getRowAtIndex(anchor) : null;
            this.mSavedSelection = this.getSelectionAsList();
            this.mNotifyOfSelections = false;
            this.deselect();
        }
    }

    void restoreSelection() {
        if (--this.mPreservationDepth == 0) {
            this.select(this.mSavedSelection, false);
            if (this.mSavedAnchorRow != null) {
                this.mSelection.setAnchor(this.getIndexOfRow(this.mSavedAnchorRow));
            }
            this.mSavedAnchorRow = null;
            this.mSavedSelection = null;
            this.mNotifyOfSelections = true;
        }
    }
}

