/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ScrollingBlock
extends Block
implements IBlockLayout,
Block.IBlockResizeListener,
BlockScrollBar.IBlockScrollListener {
    private BlockScrollBar mHBar;
    private BlockScrollBar mVBar;
    private Block mViewPort;
    private Block mContent;
    private Point mMinimumSize = new Point(32, 32);
    private boolean mAdjusting;
    private Expansion mHExpansion = Expansion.NO_SMALLER_THAN_VIEWPORT;
    private Expansion mVExpansion = Expansion.NO_SMALLER_THAN_VIEWPORT;

    private static final void adjustScrollBar(BlockScrollBar scrollbar, int pos, int size, int viewPortSize) {
        if (scrollbar != null) {
            long current = scrollbar.getValue();
            if (pos < 0) {
                current += (long)pos;
            } else if (pos + size >= viewPortSize) {
                current += (long)(pos + size - (viewPortSize - 1));
            }
            scrollbar.setValue(current);
        }
    }

    public ScrollingBlock() {
        this.mViewPort = new Block();
        this.mViewPort.setBackgroundColor(Colors.getListBackground());
        this.add(this.mViewPort);
        this.setLayout(this);
    }

    public ScrollingBlock(Block content) {
        this();
        this.setContent(content);
    }

    public @NonNull Point getViewOffset() {
        if (this.mContent != null) {
            return this.mContent.getLocation();
        }
        return new Point(0, 0);
    }

    @Override
    public final void blockResized(Block block) {
        this.adjustScrollBars();
    }

    public final BlockScrollBar getHorizontalBar() {
        return this.mHBar;
    }

    public final Expansion getHorizontalExpansion() {
        return this.mHExpansion;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return new Point(this.mMinimumSize.x, this.mMinimumSize.y);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        if (this.mContent != null) {
            return this.mContent.getPreferredSize(widthHint, heightHint);
        }
        return this.getMinimumSize(widthHint, heightHint);
    }

    public final BlockScrollBar getVerticalBar() {
        return this.mVBar;
    }

    public final Expansion getVerticalExpansion() {
        return this.mVExpansion;
    }

    public final Block getViewPort() {
        return this.mViewPort;
    }

    @Override
    public final void layout(Block target) {
        Point prefSize;
        this.adjustScrollBars();
        Rectangle bounds = this.getLocalBounds();
        if (this.mHBar != null) {
            prefSize = this.mHBar.getPreferredSize(-1, -1);
            this.mHBar.setBounds(bounds.x - 1, bounds.y + bounds.height - (prefSize.y - 1), 2 + (this.mVBar != null ? bounds.width - (prefSize.y - 1) : bounds.width), prefSize.y);
        }
        if (this.mVBar != null) {
            prefSize = this.mVBar.getPreferredSize(-1, -1);
            this.mVBar.setBounds(bounds.x + bounds.width - (prefSize.x - 1), bounds.y - 1, prefSize.x, 2 + (this.mHBar != null ? bounds.height - (prefSize.x - 1) : bounds.height));
        }
        if (this.mHBar != null) {
            bounds.height -= this.mHBar.getHeight() - 1;
            if (bounds.height < 0) {
                bounds.height = 0;
            }
        }
        if (this.mVBar != null) {
            bounds.width -= this.mVBar.getWidth() - 1;
            if (bounds.width < 0) {
                bounds.width = 0;
            }
        }
        this.mViewPort.setBounds(bounds);
    }

    @Override
    public final void scrollBarWasAdjusted(BlockScrollBar scrollBar, boolean adjustedByUser) {
        if (!this.mAdjusting) {
            int x = this.mContent.getX();
            int y = this.mContent.getY();
            int value = (int)(-scrollBar.getValue());
            if (scrollBar == this.mHBar) {
                x = value;
            } else {
                y = value;
            }
            this.mContent.setLocation(x, y);
        }
    }

    @Override
    public final void scrollIntoView(int x, int y, int width, int height) {
        if (this.mContent != null) {
            ScrollingBlock.adjustScrollBar(this.mHBar, x, width, this.mViewPort.getWidth());
            ScrollingBlock.adjustScrollBar(this.mVBar, y, height, this.mViewPort.getHeight());
        }
    }

    public final void setContent(Block content) {
        if (content != this.mContent) {
            if (this.mContent != null) {
                this.mContent.removeResizeListener(this);
                this.mContent.removeFromParent();
            }
            this.mContent = content;
            if (this.mHBar != null) {
                this.applyScrollIncrement(true, this.mHBar);
            }
            if (this.mVBar != null) {
                this.applyScrollIncrement(false, this.mVBar);
            }
            if (this.mContent != null) {
                this.mViewPort.add(this.mContent);
                this.mContent.addResizeListener(this);
            }
            this.adjustScrollBars();
            this.repaint();
        }
    }

    public final void setHorizontalExpansion(Expansion expansion) {
        if (this.mHExpansion != expansion) {
            this.mHExpansion = expansion;
            this.adjustScrollBars();
        }
    }

    public final void setMinimumSize(Point size) {
        this.mMinimumSize.x = size.x;
        this.mMinimumSize.y = size.y;
    }

    public final void setVerticalExpansion(Expansion expansion) {
        if (this.mVExpansion != expansion) {
            this.mVExpansion = expansion;
            this.adjustScrollBars();
        }
    }

    @Override
    protected final boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        if ((stateMask & 0x40000) != 0) {
            return false;
        }
        if (vertical) {
            if (this.mVBar != null) {
                int multiple = 1;
                if (this.mContent instanceof IScrollableBlock) {
                    IScrollableBlock scrollable = (IScrollableBlock)((Object)this.mContent);
                    multiple = scrollable.getVerticalIncrement();
                }
                this.mVBar.setValue(this.mVBar.getValue() - (long)(amount * multiple));
            }
        } else if (this.mHBar != null) {
            int multiple = 1;
            if (this.mContent instanceof IScrollableBlock) {
                IScrollableBlock scrollable = (IScrollableBlock)((Object)this.mContent);
                multiple = scrollable.getHorizontalIncrement();
            }
            this.mHBar.setValue(this.mHBar.getValue() - (long)(amount * multiple));
        }
        return true;
    }

    private final void adjustContentSize(Point contentSize, Point availableSize) {
        switch (this.mHExpansion) {
            case SIZE_OF_VIEWPORT: {
                contentSize.x = availableSize.x;
                break;
            }
            case NO_SMALLER_THAN_VIEWPORT: {
                if (contentSize.x >= availableSize.x) break;
                contentSize.x = availableSize.x;
                break;
            }
        }
        switch (this.mVExpansion) {
            case SIZE_OF_VIEWPORT: {
                contentSize.y = availableSize.y;
                break;
            }
            case NO_SMALLER_THAN_VIEWPORT: {
                if (contentSize.y >= availableSize.y) break;
                contentSize.y = availableSize.y;
                break;
            }
        }
    }

    private final void adjustScrollBars() {
        if (!this.mAdjusting) {
            this.mAdjusting = true;
            if (this.mContent != null) {
                Point availableSize = this.getSize();
                Point contentSize = this.mContent.getSize();
                Point preferredSize = null;
                if (this.mHExpansion == Expansion.NO_SMALLER_THAN_VIEWPORT) {
                    preferredSize = this.mContent.getPreferredSize(-1, -1);
                    contentSize.x = preferredSize.x;
                }
                if (this.mVExpansion == Expansion.NO_SMALLER_THAN_VIEWPORT) {
                    if (preferredSize == null) {
                        preferredSize = this.mContent.getPreferredSize(-1, -1);
                    }
                    contentSize.y = preferredSize.y;
                }
                if (contentSize.x <= availableSize.x && contentSize.y <= availableSize.y) {
                    this.adjustContentSize(contentSize, availableSize);
                    this.mContent.setBounds(0, 0, contentSize.x, contentSize.y);
                    this.disposeBothScrollBars();
                } else {
                    int y;
                    int x;
                    boolean needLayout = false;
                    if (this.mHExpansion == Expansion.SIZE_OF_VIEWPORT || contentSize.x <= availableSize.x) {
                        if (this.mHBar != null) {
                            this.remove(this.mHBar);
                            this.mHBar = null;
                            needLayout = true;
                        }
                    } else if (contentSize.x > availableSize.x) {
                        availableSize.y -= 16;
                        if (this.mHBar == null) {
                            this.mHBar = this.createScrollBar(true);
                            needLayout = true;
                        }
                    }
                    if (this.mVExpansion == Expansion.SIZE_OF_VIEWPORT || contentSize.y <= availableSize.y) {
                        if (this.mVBar != null) {
                            this.remove(this.mVBar);
                            this.mVBar = null;
                            needLayout = true;
                        }
                    } else if (contentSize.y > availableSize.y) {
                        availableSize.x -= 16;
                        if (this.mVBar == null) {
                            this.mVBar = this.createScrollBar(false);
                            needLayout = true;
                            if (this.mHExpansion != Expansion.SIZE_OF_VIEWPORT && contentSize.x > availableSize.x) {
                                availableSize.y -= 16;
                                if (this.mHBar == null) {
                                    this.mHBar = this.createScrollBar(true);
                                }
                            }
                        }
                    }
                    this.adjustContentSize(contentSize, availableSize);
                    if (this.mHBar != null) {
                        x = this.mContent.getX();
                        this.mHBar.setMaximum(contentSize.x);
                        this.mHBar.setThumb(availableSize.x);
                        this.mHBar.setValue(-x);
                        x = (int)(-this.mHBar.getValue());
                    } else {
                        x = 0;
                    }
                    if (this.mVBar != null) {
                        y = this.mContent.getY();
                        this.mVBar.setMaximum(contentSize.y);
                        this.mVBar.setThumb(availableSize.y);
                        this.mVBar.setValue(-y);
                        y = (int)(-this.mVBar.getValue());
                    } else {
                        y = 0;
                    }
                    this.mContent.setBounds(x, y, contentSize.x, contentSize.y);
                    if (needLayout) {
                        this.layout();
                    }
                }
            } else {
                this.disposeBothScrollBars();
            }
            this.mAdjusting = false;
        }
    }

    private final void applyScrollIncrement(boolean horizontal, BlockScrollBar bar) {
        if (this.mContent instanceof IScrollableBlock) {
            IScrollableBlock scrollable = (IScrollableBlock)((Object)this.mContent);
            bar.setIncrement(horizontal ? scrollable.getHorizontalIncrement() : scrollable.getVerticalIncrement());
        }
    }

    private final BlockScrollBar createScrollBar(boolean horizontal) {
        BlockScrollBar bar = new BlockScrollBar(horizontal, null);
        this.applyScrollIncrement(horizontal, bar);
        bar.addScrollListener(this);
        this.add(bar);
        return bar;
    }

    private final void disposeBothScrollBars() {
        if (this.mHBar != null || this.mVBar != null) {
            if (this.mHBar != null) {
                this.remove(this.mHBar);
                this.mHBar = null;
            }
            if (this.mVBar != null) {
                this.remove(this.mVBar);
                this.mVBar = null;
            }
            this.layout();
        }
    }

    public static enum Expansion {
        NONE,
        SIZE_OF_VIEWPORT,
        NO_SMALLER_THAN_VIEWPORT;

    }
}

