/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.BlockComposite;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.IBlockContentProposalProvider;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class Block {
    protected static boolean CONTEXT_MENU_SHOWING;
    private Block mParent;
    private final @NonNull List<@NonNull Block> mChildren = new ArrayList<Block>();
    private IBlockLayout mLayout;
    private Object mLayoutData;
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private Color mBackgroundColor;
    private Cursor mCursor;
    private String mToolTip;
    private boolean mEnabled = true;
    private boolean mFocusable;
    private boolean mHasFocus;
    private boolean mRemovesOtherFocus;
    private @NonNull BlockType type = BlockType.NONE;
    private List<IBlockResizeListener> mResizeListeners = new ArrayList<IBlockResizeListener>();
    private List<IBlockMoveListener> mMoveListeners = new ArrayList<IBlockMoveListener>();

    public @NonNull BlockType getType() {
        return this.type;
    }

    public void setType(@NonNull BlockType type) {
        this.type = type;
    }

    public final void clear() {
        for (Block child : this.mChildren) {
            this.handleRemovedChild(child);
            child.clear();
        }
        this.mChildren.clear();
    }

    public final void add(Block block) {
        this.add(block, -1);
    }

    public final void add(Block block, int index) {
        if (block instanceof BlockRoot) {
            throw new IllegalArgumentException(BlockRoot.class.getSimpleName() + " is not a valid child");
        }
        Block existingParent = block.getParent();
        if (existingParent != null) {
            existingParent.remove(block);
        }
        if (index < 0) {
            this.mChildren.add(block);
        } else {
            this.mChildren.add(index, block);
        }
        block.mParent = this;
        block.wasAdded(this);
        this.childWasAdded(block);
    }

    public final synchronized void addMoveListener(IBlockMoveListener listener) {
        this.mMoveListeners.add(listener);
    }

    public final synchronized void addResizeListener(IBlockResizeListener listener) {
        this.mResizeListeners.add(listener);
    }

    public final boolean contains(int x, int y) {
        return x >= 0 && x < this.mWidth && y >= 0 && y < this.mHeight;
    }

    public final boolean contains(Point where) {
        return this.contains(where.x, where.y);
    }

    public final GC createTemporaryGC() {
        BlockComposite owner = this.getOwner();
        GC gc = owner != null && !owner.isDisposed() ? new GC((Drawable)owner) : new GC((Drawable)Display.getCurrent());
        gc.setTextAntialias(1);
        return gc;
    }

    public final Block findBlockAt(int x, int y, boolean deep) {
        if (!this.contains(x, y)) {
            return null;
        }
        for (Block child : this.mChildren) {
            int yy;
            int xx;
            if (!child.contains(xx = x - child.mX, yy = y - child.mY)) continue;
            return deep ? child.findBlockAt(xx, yy, deep) : child;
        }
        return this;
    }

    public final Block findBlockAt(Point where, boolean deep) {
        return this.findBlockAt(where.x, where.y, deep);
    }

    public final void flattenFocusables(List<Block> list) {
        if (this.mFocusable && this.mEnabled) {
            list.add(this);
        }
        for (Block child : this.mChildren) {
            child.flattenFocusables(list);
        }
    }

    public void focusGained(boolean fromKeyboard) {
        this.mHasFocus = true;
        this.repaint();
    }

    public void focusLost() {
        this.mHasFocus = false;
        this.repaint();
    }

    public final Point fromDisplay(int x, int y) {
        BlockComposite owner = this.getOwner();
        Point where = owner != null && !owner.isDisposed() ? owner.toControl(x, y) : new Point(x, y);
        return this.fromRoot(where);
    }

    public final Point fromDisplay(Point where) {
        BlockComposite owner = this.getOwner();
        if (owner != null && !owner.isDisposed()) {
            Point result = owner.toControl(where);
            where.x = result.x;
            where.y = result.y;
        }
        return this.fromRoot(where);
    }

    public final Point fromRoot(int x, int y) {
        Block block = this;
        while (block != null) {
            x -= block.mX;
            y -= block.mY;
            block = block.mParent;
        }
        return new Point(x, y);
    }

    public final Point fromRoot(Point where) {
        Block block = this;
        int x = where.x;
        int y = where.y;
        while (block != null) {
            x -= block.mX;
            y -= block.mY;
            block = block.mParent;
        }
        where.x = x;
        where.y = y;
        return where;
    }

    public final Rectangle fromRoot(Rectangle bounds) {
        Block block = this;
        int x = bounds.x;
        int y = bounds.y;
        while (block != null) {
            x -= block.mX;
            y -= block.mY;
            block = block.mParent;
        }
        bounds.x = x;
        bounds.y = y;
        return bounds;
    }

    public final int fromRootX(int x) {
        Block block = this;
        while (block != null) {
            x -= block.mX;
            block = block.mParent;
        }
        return x;
    }

    public final int fromRootY(int y) {
        Block block = this;
        while (block != null) {
            y -= block.mY;
            block = block.mParent;
        }
        return y;
    }

    public final Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.mX, this.mY, this.mWidth, this.mHeight);
    }

    public final Block getChild(int index) {
        return this.mChildren.get(index);
    }

    public final int getChildCount() {
        return this.mChildren.size();
    }

    public final @NonNull Block @NonNull [] getChildren() {
        return this.mChildren.toArray(new Block[this.mChildren.size()]);
    }

    public Stream<Block> getFlattenedChildren() {
        return Stream.concat(Stream.of(this), Arrays.stream(this.getChildren()).flatMap(Block::getFlattenedChildren));
    }

    public final Block getCommonParent(Block block) {
        List<Block> myChain = this.getParentChain();
        List<Block> otherChain = block.getParentChain();
        int max = Math.min(myChain.size(), otherChain.size());
        Block last = null;
        int i = 0;
        while (i < max) {
            Block current = myChain.get(i);
            if (current != otherChain.get(i)) break;
            last = current;
            ++i;
        }
        return last;
    }

    public final ScrollingBlock getContainingScrollingBlock() {
        Block parent = this.mParent;
        while (parent != null) {
            if (parent instanceof ScrollingBlock) {
                return (ScrollingBlock)parent;
            }
            parent = parent.mParent;
        }
        return null;
    }

    public IBlockContentProposalProvider getContentProposalProvider() {
        return null;
    }

    public String getContentsForProposal() {
        return null;
    }

    public final Cursor getCursor(Point where) {
        return this.mCursor;
    }

    public int getCursorPositionForProposal() {
        return 0;
    }

    public Point getCursorRangeForProposal() {
        return new Point(0, 0);
    }

    public final Display getDisplay() {
        BlockComposite owner = this.getOwner();
        if (owner != null && !owner.isDisposed()) {
            return owner.getDisplay();
        }
        return null;
    }

    public final Block getFirstEnabledParent() {
        Block parent = this.mParent;
        while (parent != null && !parent.mEnabled) {
            parent = parent.mParent;
        }
        return parent;
    }

    public Rectangle getFocusArea() {
        return new Rectangle(0, 0, 0, 0);
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public Rectangle getInsertionBoundsForProposal() {
        return null;
    }

    public IBlockLayout getLayout() {
        return this.mLayout;
    }

    public final Object getLayoutData() {
        return this.mLayoutData;
    }

    public final Rectangle getLocalBounds() {
        return new Rectangle(0, 0, this.mWidth, this.mHeight);
    }

    public final @NonNull Point getLocation() {
        return new Point(this.mX, this.mY);
    }

    public final Color getLogicalBackgroundColor() {
        Color color = this.mBackgroundColor;
        Block block = this;
        while (color == null && block != null) {
            Color color2 = color = (block = block.getParent()) != null ? block.getBackgroundColor() : Colors.getWidgetBackground();
        }
        return color;
    }

    public Point getMinimumSize(int widthHint, int heightHint) {
        if (this.mLayout != null) {
            return this.mLayout.getMinimumSize(this, widthHint, heightHint);
        }
        return new Point(32, 32);
    }

    public BlockComposite getOwner() {
        BlockRoot root = this.getRoot();
        if (root != null) {
            return root.getOwner();
        }
        return null;
    }

    public final Block getParent() {
        return this.mParent;
    }

    public final List<Block> getParentChain() {
        ArrayList<Block> chain = new ArrayList<Block>();
        Block parent = this.mParent;
        while (parent != null) {
            chain.add(parent);
            parent = parent.mParent;
        }
        Collections.reverse(chain);
        return chain;
    }

    public Point getPreferredSize(int widthHint, int heightHint) {
        if (this.mLayout != null) {
            return this.mLayout.getPreferredSize(this, widthHint, heightHint);
        }
        return new Point(32, 32);
    }

    public final BlockRoot getRoot() {
        Block parent = this.mParent;
        while (parent != null && !(parent instanceof BlockRoot)) {
            parent = parent.getParent();
        }
        return (BlockRoot)parent;
    }

    public final Shell getShell() {
        BlockComposite owner = this.getOwner();
        if (owner != null && !owner.isDisposed()) {
            return owner.getShell();
        }
        return null;
    }

    public final Point getSize() {
        return new Point(this.mWidth, this.mHeight);
    }

    public String getToolTip() {
        return this.mToolTip;
    }

    public String getToolTip(Point where) {
        return this.getToolTip();
    }

    public final Rectangle getViewPortBounds() {
        Rectangle bounds = this.getLocalBounds();
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null) {
            Block viewPort = scroller.getViewPort();
            Rectangle viewBounds = this.fromRoot(viewPort.toRoot(viewPort.getLocalBounds()));
            bounds.intersect(viewBounds);
        }
        return bounds;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getX() {
        return this.mX;
    }

    public final int getY() {
        return this.mY;
    }

    public final boolean hasFocus() {
        if (this.mHasFocus && !CONTEXT_MENU_SHOWING) {
            Display display = this.getDisplay();
            return display != null && this.getOwner() == display.getFocusControl();
        }
        return false;
    }

    public void insertProposalContents(String contents, int cursorPosition) {
    }

    public final boolean isDescendentOf(Block block) {
        Block parent = this.mParent;
        while (parent != null && parent != block) {
            parent = parent.mParent;
        }
        return parent == block;
    }

    public final boolean isEnabled() {
        return this.mEnabled;
    }

    public final boolean isFocusable() {
        return this.mFocusable;
    }

    public final void layout() {
        if (this.mLayout != null) {
            this.mLayout.layout(this);
        }
        this.repaint();
    }

    public final void layoutAll() {
        this.layout();
        for (Block child : this.mChildren) {
            child.layoutAll();
        }
    }

    public final boolean move(int childToMove, int beforeChild) {
        return ListUtils.moveBefore(this.mChildren, (int)childToMove, (int)beforeChild);
    }

    public final boolean move(Block childToMove, Block beforeChild) {
        if (childToMove != beforeChild && childToMove.mParent == this && (beforeChild == null || beforeChild.mParent == this)) {
            int ci = this.mChildren.indexOf(childToMove);
            int bi = beforeChild == null ? this.mChildren.size() : this.mChildren.indexOf(beforeChild);
            return this.move(ci, bi);
        }
        return false;
    }

    public boolean obeyCommand(CommandAction action) {
        return false;
    }

    public void pack() {
        this.setSize(this.getPreferredSize(-1, -1));
        this.repaint();
    }

    public final void paint(GC gc, int clipX, int clipY, int clipWidth, int clipHeight) {
        Rectangle clipping = new Rectangle(clipX, clipY, clipWidth, clipHeight);
        Rectangle bounds = this.getLocalBounds();
        clipping.intersect(bounds);
        if (!clipping.isEmpty()) {
            block12: {
                gc.setClipping(this.toRoot(new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height)));
                this.toRoot(bounds);
                gc.setTranslate(bounds.x, bounds.y);
                try {
                    try {
                        this.paintSelf(gc);
                    }
                    catch (Throwable throwable) {
                        CommonPlugin.error((Throwable)throwable);
                        gc.clearTranslate();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    gc.clearTranslate();
                    throw throwable;
                }
                gc.clearTranslate();
            }
            int i = this.mChildren.size();
            while (--i >= 0) {
                Block child = this.mChildren.get(i);
                Rectangle childClip = child.getBounds();
                childClip.intersect(clipping);
                if (childClip.isEmpty()) continue;
                child.paint(gc, childClip.x - child.mX, childClip.y - child.mY, childClip.width, childClip.height);
            }
            gc.setTranslate(bounds.x, bounds.y);
            gc.setClipping(new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height));
            try {
                try {
                    this.paintSelfOver(gc);
                }
                catch (Throwable throwable) {
                    CommonPlugin.error((Throwable)throwable);
                    gc.clearTranslate();
                }
            }
            finally {
                gc.clearTranslate();
            }
        }
    }

    public final void paintAsRoot(GC gc) {
        Block parent = this.mParent;
        int x = this.mX;
        int y = this.mY;
        this.mParent = null;
        this.mX = 0;
        this.mY = 0;
        try {
            this.paint(gc, 0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            this.mParent = parent;
            this.mX = x;
            this.mY = y;
        }
    }

    public final void releaseCapturedMouse() {
        BlockComposite owner = this.getOwner();
        if (owner != null) {
            owner.releaseCapturedMouse();
        }
    }

    public final void remove(@NonNull Block block) {
        if (this.mChildren.remove(block)) {
            this.handleRemovedChild(block);
        }
    }

    public final void remove(int index) {
        this.handleRemovedChild(this.mChildren.remove(index));
    }

    public final @NonNull List<@NonNull Block> removeMatching(@NonNull Predicate<@NonNull Block> test) {
        ArrayList<@NonNull Block> removed = new ArrayList<Block>();
        Iterator<@NonNull Block> childIter = this.mChildren.iterator();
        while (childIter.hasNext()) {
            Block child = childIter.next();
            if (!test.test(child)) continue;
            childIter.remove();
            this.handleRemovedChild(child);
            removed.add(child);
        }
        return removed;
    }

    private final void handleRemovedChild(@NonNull Block removed) {
        removed.mParent = null;
        BlockComposite owner = this.getOwner();
        if (owner != null) {
            owner.getFocus();
        }
        removed.wasRemoved(this);
        this.childWasRemoved(removed);
    }

    public final void removeFromParent() {
        if (this.mParent != null) {
            this.mParent.remove(this);
        }
    }

    public final synchronized void removeMoveListener(IBlockMoveListener listener) {
        this.mMoveListeners.remove(listener);
    }

    public final synchronized void removeResizeListener(IBlockResizeListener listener) {
        this.mResizeListeners.remove(listener);
    }

    public final boolean removesOtherFocus() {
        return this.mRemovesOtherFocus;
    }

    public final void repaint() {
        this.repaint(0, 0, this.mWidth, this.mHeight);
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.mParent != null && x < this.mWidth && y < this.mHeight) {
            if (x < 0) {
                width += x;
                x = 0;
            }
            if (width > 0) {
                if (x + width > this.mWidth) {
                    width = this.mWidth - x;
                }
                if (width > 0) {
                    if (y < 0) {
                        height += y;
                        y = 0;
                    }
                    if (height > 0) {
                        if (y + height > this.mHeight) {
                            height = this.mHeight - y;
                        }
                        if (height > 0) {
                            this.mParent.repaint(this.mX + x, this.mY + y, width, height);
                        }
                    }
                }
            }
        }
    }

    public final void repaint(Rectangle bounds) {
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public final void scrollIntoView() {
        this.scrollIntoView(this.getLocalBounds());
    }

    public void scrollIntoView(int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            Block parent = this.mParent;
            x += this.mX;
            y += this.mY;
            while (parent != null && !(parent instanceof ScrollingBlock)) {
                x += parent.mX;
                y += parent.mY;
                parent = parent.mParent;
            }
            if (parent != null) {
                parent.scrollIntoView(x, y, width, height);
            }
        }
    }

    public final void scrollIntoView(Rectangle bounds) {
        this.scrollIntoView(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public final void setBackgroundColor(Color backgroundColor) {
        if (this.mBackgroundColor == null ? backgroundColor != null : !this.mBackgroundColor.equals((Object)backgroundColor)) {
            this.mBackgroundColor = backgroundColor;
            this.repaint();
        }
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public final void setBounds(Rectangle bounds) {
        this.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public final void setCursor(Cursor cursor) {
        this.mCursor = cursor;
    }

    public void setCursorPositionForProposal(int index) {
    }

    public void setCursorRangeForProposal(Point range) {
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public final void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    public void setLayout(IBlockLayout layout) {
        this.mLayout = layout;
    }

    public final void setLayoutData(Object layoutData) {
        this.mLayoutData = layoutData;
    }

    public final void setLocation(int x, int y) {
        this.reshape(x, y, this.mWidth, this.mHeight);
    }

    public final void setLocation(Point location) {
        this.setLocation(location.x, location.y);
    }

    public void setProposalContents(String contents, int cursorPosition) {
    }

    public final void setRemovesOtherFocus(boolean removes) {
        this.mRemovesOtherFocus = removes;
    }

    public final void setSize(int width, int height) {
        this.reshape(this.mX, this.mY, width, height);
    }

    public final void setSize(Point size) {
        this.setSize(size.x, size.y);
    }

    public void setToolTip(String text) {
        this.mToolTip = text;
    }

    public final void showContextMenuInDisplayCoords(final Menu menu, Point where) {
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent event) {
                Task.scheduleOnUIThread(() -> menu.dispose());
                Block.this.releaseCapturedMouse();
                CONTEXT_MENU_SHOWING = false;
                Block.this.repaint();
            }

            public void menuShown(MenuEvent event) {
                CONTEXT_MENU_SHOWING = true;
            }
        });
        menu.setVisible(true);
        menu.setLocation(where);
    }

    public final void showContextMenu(Menu menu, Point where) {
        this.showContextMenuInDisplayCoords(menu, this.toDisplay(where));
    }

    public final Point toDisplay(int x, int y) {
        Point result = this.toRoot(x, y);
        BlockComposite owner = this.getOwner();
        return owner != null && !owner.isDisposed() ? owner.toDisplay(result) : result;
    }

    public final Point toDisplay(Point where) {
        where = this.toRoot(where);
        BlockComposite owner = this.getOwner();
        if (owner != null && !owner.isDisposed()) {
            Point loc = owner.toDisplay(where);
            where.x = loc.x;
            where.y = loc.y;
        }
        return where;
    }

    public final Point toRoot(int x, int y) {
        Block block = this;
        while (block != null) {
            x += block.mX;
            y += block.mY;
            block = block.mParent;
        }
        return new Point(x, y);
    }

    public final Point toRoot(Point where) {
        Block block = this;
        int x = where.x;
        int y = where.y;
        while (block != null) {
            x += block.mX;
            y += block.mY;
            block = block.mParent;
        }
        where.x = x;
        where.y = y;
        return where;
    }

    public final Rectangle toRoot(Rectangle bounds) {
        Block block = this;
        int x = bounds.x;
        int y = bounds.y;
        while (block != null) {
            x += block.mX;
            y += block.mY;
            block = block.mParent;
        }
        bounds.x = x;
        bounds.y = y;
        return bounds;
    }

    public final int toRootX(int x) {
        Block block = this;
        while (block != null) {
            x += block.mX;
            block = block.mParent;
        }
        return x;
    }

    public final int toRootY(int y) {
        Block block = this;
        while (block != null) {
            y += block.mY;
            block = block.mParent;
        }
        return y;
    }

    protected void childWasAdded(Block child) {
    }

    protected void childWasRemoved(Block child) {
    }

    protected boolean keyPressed(int code, char ch, int location, int stateMask) {
        return false;
    }

    protected boolean keyReleased(int code, char ch, int location, int stateMask) {
        return false;
    }

    protected void mouseDown(Point where, int button, int stateMask, int count) {
    }

    protected void mouseDrag(Point where, int button, int stateMask) {
    }

    protected void mouseDragHover(Point where, int button, int stateMask) {
    }

    protected void mouseEnter(Point where, int stateMask) {
    }

    protected void mouseExit() {
    }

    protected void mouseHover(Point where, int stateMask) {
    }

    protected void mouseMove(Point where, int stateMask) {
    }

    protected boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        return false;
    }

    protected void mouseUp(Point where, int button, int stateMask, int count) {
    }

    protected void paintSelf(GC gc) {
        if (this.mBackgroundColor != null) {
            gc.setBackground(this.mBackgroundColor);
            gc.fillRectangle(this.getLocalBounds());
        }
    }

    protected void paintSelfOver(GC gc) {
    }

    protected void wasAdded(Block parent) {
    }

    protected void wasRemoved(Block parent) {
    }

    protected void wasResized() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reshape(int x, int y, int width, int height) {
        Object listener;
        int n;
        int n2;
        Object[] objectArray;
        Object[] listeners;
        boolean resized;
        boolean moved;
        boolean bl = moved = this.mX != x || this.mY != y;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        boolean bl2 = resized = this.mWidth != width || this.mHeight != height;
        if (moved || resized) {
            this.repaint();
        }
        if (moved) {
            this.mX = x;
            this.mY = y;
        }
        if (resized) {
            this.mWidth = width;
            this.mHeight = height;
        }
        if (resized) {
            this.layout();
            this.wasResized();
            Block block = this;
            synchronized (block) {
                listeners = this.mResizeListeners.toArray(new IBlockResizeListener[this.mResizeListeners.size()]);
            }
            objectArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                listener.blockResized(this);
                ++n;
            }
        }
        if (moved) {
            listener = this;
            synchronized (listener) {
                listeners = this.mMoveListeners.toArray(new IBlockMoveListener[this.mMoveListeners.size()]);
            }
            objectArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                listener.blockMoved(this);
                ++n;
            }
        }
        if (moved || resized) {
            this.repaint();
        }
    }

    public static enum BlockType {
        CHART_PANEL,
        HEAT_MAP_PANEL,
        NONE;

    }

    public static interface IBlockMoveListener {
        public void blockMoved(Block var1);
    }

    public static interface IBlockResizeListener {
        public void blockResized(Block var1);
    }
}

