/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.contextmenu;

import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.contextmenu.IContextMenuSelectionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ContextMenu
implements MenuListener,
SelectionListener,
Runnable,
Comparator<IContextMenuContributor> {
    private static final String ID = "id";
    private static final String MENU_ID = "menu";
    private static final String CONTRIBUTOR_ID = "contributor";
    private Control mHandlerTarget;
    private Control mClickTarget;
    private Menu mMenu;
    private ISelection mSelection;
    private HashMap<String, Menu> mCascadeMenus = new HashMap();
    private HashSet<IContextMenuContributor> mContributors = new HashSet();
    private ArrayList<IContextMenuContributor> mCurrentContributors = new ArrayList();

    public static void createConditionalSeparator(Menu menu) {
        MenuItem[] items = menu.getItems();
        if (items.length > 0 && items[items.length - 1].getStyle() != 2) {
            ContextMenu.createSeparator(menu);
        }
    }

    public static MenuItem createSeparator(Menu menu) {
        return new MenuItem(menu, 2);
    }

    public ContextMenu(Control target) {
        this(target, target);
    }

    public ContextMenu(Control clickTarget, Control handlerTarget) {
        if (!(handlerTarget instanceof ISelectionProvider) && !(handlerTarget instanceof IContextMenuSelectionResolver)) {
            throw new IllegalArgumentException("target implement either ISelectionProvider or IContextMenuSelectionResolver");
        }
        this.mHandlerTarget = handlerTarget;
        this.mClickTarget = clickTarget;
        this.mMenu = new Menu(clickTarget);
        this.mMenu.addMenuListener((MenuListener)this);
        this.mMenu.setData((Object)this);
        clickTarget.setMenu(this.mMenu);
    }

    public final void add(IContextMenuContributor contributor) {
        this.mContributors.add(contributor);
    }

    @Override
    public final int compare(IContextMenuContributor left, IContextMenuContributor right) {
        int rp;
        int lp = left.getPriority();
        if (lp < (rp = right.getPriority())) {
            return -1;
        }
        if (lp > rp) {
            return 1;
        }
        lp = left.hashCode();
        if (lp < (rp = right.hashCode())) {
            return -1;
        }
        if (lp > rp) {
            return 1;
        }
        return 0;
    }

    public final @NonNull MenuItem createCascadeMenu(String title, String id, boolean enabled) {
        return this.createCascadeMenu(this.mMenu, title, id, enabled);
    }

    private @NonNull MenuItem createCascadeMenu(Menu parent, String title, String id, boolean enabled) {
        MenuItem item = new MenuItem(parent, 64);
        item.setText(title);
        if (!enabled) {
            item.setEnabled(false);
        }
        Menu menu = new Menu(item);
        item.setMenu(menu);
        this.mCascadeMenus.put(id, menu);
        return item;
    }

    public final @NonNull MenuItem createCascadeMenu(String title, String menuId, String id, boolean enabled) {
        @Nullable Menu parent = this.mCascadeMenus.get(menuId);
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        return this.createCascadeMenu(parent, title, id, enabled);
    }

    public final MenuItem createCascadeMenuItem(IContextMenuContributor contributor, String menuID, String title, String itemID, boolean enabled) {
        MenuItem item = this.setupMenuItem(contributor, new MenuItem(this.mCascadeMenus.get(menuID), 8), title, itemID, enabled, false);
        item.setData(MENU_ID, (Object)menuID);
        return item;
    }

    public final MenuItem createCascadeMenuItem(IContextMenuContributor contributor, String menuID, String title, String itemID, boolean enabled, boolean checked) {
        MenuItem item = this.setupMenuItem(contributor, new MenuItem(this.mCascadeMenus.get(menuID), 32), title, itemID, enabled, checked);
        item.setData(MENU_ID, (Object)menuID);
        return item;
    }

    public final void createConditionalSeparator() {
        ContextMenu.createConditionalSeparator(this.mMenu);
    }

    public final void createConditionalSeparator(String id) {
        ContextMenu.createConditionalSeparator(this.mCascadeMenus.get(id));
    }

    public final MenuItem createMenuItem(IContextMenuContributor contributor, String title, Image image, String id, boolean enabled) {
        MenuItem item = this.createMenuItem(contributor, title, id, enabled);
        item.setImage(image);
        return item;
    }

    public final MenuItem createMenuItem(IContextMenuContributor contributor, String title, String id, boolean enabled) {
        return this.setupMenuItem(contributor, new MenuItem(this.mMenu, 8), title, id, enabled, false);
    }

    public final MenuItem createMenuItem(IContextMenuContributor contributor, String title, String id, boolean enabled, boolean checked) {
        return this.setupMenuItem(contributor, new MenuItem(this.mMenu, 32), title, id, enabled, checked);
    }

    public final void createSeparator() {
        ContextMenu.createSeparator(this.mMenu);
    }

    public final void createSeparator(String id) {
        ContextMenu.createSeparator(this.mCascadeMenus.get(id));
    }

    public final Control getClickControl() {
        return this.mClickTarget;
    }

    public final Set<IContextMenuContributor> getContributors() {
        return Collections.unmodifiableSet(this.mContributors);
    }

    public final Control getHandlerControl() {
        return this.mHandlerTarget;
    }

    public final ISelection getSelection() {
        return this.mSelection;
    }

    public final void menuHidden(MenuEvent event) {
        Display.getDefault().asyncExec((Runnable)this);
    }

    public void menuShown(MenuEvent event) {
        this.cleanup();
        this.mCurrentContributors.addAll(this.mContributors);
        Collections.sort(this.mCurrentContributors, this);
        this.mSelection = this.mHandlerTarget instanceof IContextMenuSelectionResolver ? ((IContextMenuSelectionResolver)this.mHandlerTarget).getSelection(this.mClickTarget, this.mClickTarget.toControl(event.display.getCursorLocation())) : ((ISelectionProvider)this.mHandlerTarget).getSelection();
        for (IContextMenuContributor contributor : this.mCurrentContributors) {
            contributor.prepareMenu(this);
        }
    }

    public final void remove(IContextMenuContributor contributor) {
        this.mContributors.remove(contributor);
    }

    @Override
    public final void run() {
        this.cleanup();
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public final void widgetSelected(SelectionEvent event) {
        MenuItem item = (MenuItem)event.widget;
        IContextMenuContributor contributor = (IContextMenuContributor)item.getData(CONTRIBUTOR_ID);
        if (contributor != null) {
            contributor.handleCommand(this, item, (String)item.getData(MENU_ID), (String)item.getData(ID));
        }
        this.cleanup();
    }

    private void cleanup() {
        if (!this.mMenu.isDisposed()) {
            MenuItem[] menuItemArray = this.mMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        for (IContextMenuContributor contributor : this.mCurrentContributors) {
            contributor.cleanup(this);
        }
        this.mCurrentContributors.clear();
        this.mSelection = null;
    }

    private final MenuItem setupMenuItem(IContextMenuContributor contributor, MenuItem item, String title, String id, boolean enabled, boolean checked) {
        item.setText(title);
        if (!enabled) {
            item.setEnabled(false);
        }
        if (checked) {
            item.setSelection(true);
        }
        item.setData(ID, (Object)id);
        item.setData(CONTRIBUTOR_ID, (Object)contributor);
        item.addSelectionListener((SelectionListener)this);
        return item;
    }
}

