/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ToolbarReadout
extends Canvas
implements PaintListener {
    private static final int H_MARGIN = 4;
    private static final int CORNER_RADIUS = 8;
    private Image mImage;
    private int mImageAlignment;
    private String mText;
    private int mTextAlignment;
    private int mDesiredMinimumTextWidth = 20;

    public ToolbarReadout(Composite parent, Image image, int imageAlignment, String text, int textAlignment, String tooltip) {
        super(parent, 0x20040000);
        this.mImage = image;
        this.mImageAlignment = imageAlignment;
        this.mText = text;
        this.mTextAlignment = textAlignment;
        this.setToolTipText(tooltip);
        this.addPaintListener(this);
    }

    public ToolbarReadout(Composite parent, String text, int textAlignment, String tooltip) {
        this(parent, null, 16384, text, textAlignment, tooltip);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        FontInfo fontInfo = FontInfo.get(this.getFont());
        Point size = fontInfo.getExtent(this.mText);
        int height = fontInfo.getHeight();
        if (size.y < height) {
            size.y = height;
        }
        if (this.mDesiredMinimumTextWidth > size.x) {
            size.x = this.mDesiredMinimumTextWidth;
        }
        size.x += 10;
        if (this.mImage != null) {
            Rectangle bounds = this.mImage.getBounds();
            size.x += bounds.width + 4;
            if (bounds.height > size.y) {
                size.y = bounds.height;
            }
        }
        size.y += 2;
        return size;
    }

    public Image getImage() {
        return this.mImage;
    }

    public String getText() {
        return this.mText;
    }

    public void paintControl(PaintEvent event) {
        GC gc = new GC(event.gc);
        Rectangle clientArea = this.getClientArea();
        Color color = Colors.getWidgetBackground();
        gc.setBackground(color);
        gc.fillRectangle(clientArea);
        gc.setAntialias(1);
        gc.setBackground(Colors.lighten(color, 50));
        gc.fillRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, 8, 8);
        Rectangle bounds = new Rectangle(clientArea.x + 1 + 4, clientArea.y + 1, clientArea.width - 10, clientArea.height - 2);
        if (this.mImage != null) {
            Rectangle imageBounds = this.mImage.getBounds();
            int y = bounds.y + (bounds.height - imageBounds.height) / 2;
            int size = imageBounds.width + 4;
            if (this.mImageAlignment == 131072) {
                gc.drawImage(this.mImage, bounds.x + bounds.width - imageBounds.width, y);
            } else {
                gc.drawImage(this.mImage, bounds.x, y);
                bounds.x += size;
            }
            bounds.width -= size;
        }
        if (this.mText != null && !this.mText.isEmpty()) {
            FontInfo info = FontInfo.get(this.getFont());
            String text = TextDrawing.truncateString(this.getFont(), this.mText, bounds.width, 131072);
            int x = switch (this.mTextAlignment) {
                default -> bounds.x;
                case 0x1000000 -> bounds.x + bounds.width / 2;
                case 131072 -> bounds.x + bounds.width;
            };
            gc.setForeground(Colors.getWidgetForeground());
            TextDrawing.drawString(gc, text, x, bounds.y + (bounds.height - info.getHeight()) / 2, this.mTextAlignment);
        }
        gc.setForeground(Colors.getWidgetNormalShadow());
        gc.drawRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, 8, 8);
        gc.setAntialias(0);
    }

    public void setDesiredMinimumTextWidth(int minimum) {
        this.mDesiredMinimumTextWidth = minimum;
    }

    public void setImage(Image image, int alignment) {
        this.mImage = image;
        this.mImageAlignment = alignment;
        this.redraw();
    }

    public boolean setText(String text) {
        if (this.mText == null ? text != null : !this.mText.equals(text)) {
            this.mText = text;
            this.redraw();
            return true;
        }
        return false;
    }
}

