/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.IProvidesStateMaskAtMouseDown;
import com.arm.streamline.widget.SafeUpdate;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ImageButton
extends Canvas
implements IProvidesStateMaskAtMouseDown,
PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
DisposeListener,
IPropertyChangeListener {
    private static final int MARGIN = 3;
    private static final int CORNER_RADIUS = 4;
    private static final int MENU_GAP = 2;
    private Action mAction;
    private Image mImage;
    private Image mDisabledImage;
    private Image mDisabledMenuImage;
    private int mPreferredImageWidth;
    private int mPreferredImageHeight;
    protected boolean mDrawBorder;
    private boolean mInMouseDown;
    protected boolean mPressed;
    private boolean mEnabled = true;
    private boolean mHasDropDown;
    private boolean mToggle;
    private boolean mSelected;
    private Set<IClickListener> mClickListeners = new HashSet<IClickListener>();
    private int mStateMaskAtMouseDown;

    public ImageButton(Composite parent, Action action) {
        this(parent, action.getImageDescriptor().createImage(), action.getStyle() == 2);
        this.mAction = action;
        this.mHasDropDown = this.mAction.getMenuCreator() != null;
        this.mAction.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setSelected(this.mAction.isChecked());
        this.setEnabled(this.mAction.isEnabled());
        this.adjustTooltipFromAction();
    }

    public ImageButton(Composite parent, Image image) {
        this(parent, image, false, image.getBounds().width, image.getBounds().height);
    }

    public ImageButton(Composite parent, Image image, boolean toggle) {
        this(parent, image, toggle, image.getBounds().width, image.getBounds().height);
    }

    public ImageButton(Composite parent, Image image, boolean toggle, int preferredImageWidth, int preferredImageHeight) {
        super(parent, 0x20000000);
        this.mToggle = toggle;
        this.mImage = image;
        this.setPreferredImageSize(preferredImageWidth, preferredImageHeight);
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addDisposeListener(this);
    }

    public final synchronized void addClickListener(IClickListener listener) {
        this.mClickListeners.add(listener);
    }

    public final Point computeSize(int wHint, int hHint, boolean changed) {
        int margins = 6;
        Point size = new Point(this.mPreferredImageWidth, this.mPreferredImageHeight);
        if (this.mHasDropDown) {
            Rectangle bounds = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW).getBounds();
            size.x += 2 + bounds.width;
            if (size.y < bounds.height) {
                size.y = bounds.height;
            }
        }
        size.x += margins;
        size.y += margins;
        return size;
    }

    public final int getPreferredImageHeight() {
        return this.mPreferredImageHeight;
    }

    public final int getPreferredImageWidth() {
        return this.mPreferredImageWidth;
    }

    @Override
    public final int getStateMaskAtMouseDown() {
        return this.mStateMaskAtMouseDown;
    }

    public final boolean isReallyEnabled() {
        return this.mEnabled;
    }

    public final boolean isSelected() {
        return this.mSelected;
    }

    public final void mouseDoubleClick(MouseEvent event) {
    }

    public final void mouseDown(MouseEvent event) {
        if (this.mEnabled) {
            if (this.mHasDropDown) {
                this.mStateMaskAtMouseDown = event.stateMask;
                final IMenuCreator menuCreator = this.mAction.getMenuCreator();
                Menu menu = menuCreator.getMenu((Control)this);
                menu.setLocation(this.toDisplay(0, this.getSize().y));
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public final void menuHidden(MenuEvent menuEvent) {
                        Task.callOnUIThread((Runnable)new Runnable(){

                            @Override
                            public final void run() {
                                menuCreator.dispose();
                                (this).ImageButton.this.mPressed = false;
                                (this).ImageButton.this.mDrawBorder = false;
                                SafeUpdate.redraw((Control)ImageButton.this);
                            }
                        });
                    }
                });
                menu.setVisible(true);
                this.mPressed = true;
                SafeUpdate.redraw((Control)this);
                return;
            }
            this.setCapture(true);
            this.mPressed = true;
            this.mInMouseDown = true;
            SafeUpdate.redraw((Control)this);
        }
    }

    public final void mouseEnter(MouseEvent event) {
        this.mDrawBorder = true;
        SafeUpdate.redraw((Control)this);
    }

    public final void mouseExit(MouseEvent event) {
        this.mDrawBorder = false;
        SafeUpdate.redraw((Control)this);
    }

    public final void mouseHover(MouseEvent event) {
    }

    public final void mouseMove(MouseEvent event) {
        if (this.mInMouseDown) {
            boolean wasPressed = this.mPressed;
            this.mPressed = this.getClientArea().contains(event.x, event.y);
            if (this.mPressed != wasPressed) {
                SafeUpdate.redraw((Control)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mouseUp(MouseEvent event) {
        if (this.mInMouseDown) {
            this.setCapture(false);
            this.mInMouseDown = false;
            this.mPressed = false;
            if (this.mToggle) {
                this.mSelected = !this.mSelected;
            }
            SafeUpdate.redraw((Control)this);
            if (this.getClientArea().contains(event.x, event.y)) {
                IClickListener[] listeners;
                ImageButton imageButton = this;
                synchronized (imageButton) {
                    listeners = this.mClickListeners.toArray(new IClickListener[this.mClickListeners.size()]);
                }
                IClickListener[] iClickListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IClickListener listener = iClickListenerArray[n2];
                    listener.buttonClicked(this);
                    ++n2;
                }
                if (this.mAction != null) {
                    this.mAction.run();
                }
            }
        }
    }

    public final void paintControl(PaintEvent event) {
        boolean enabled = this.mEnabled;
        GC gc = new GC(event.gc);
        Rectangle bounds = this.getClientArea();
        gc.setAntialias(1);
        Color color = this.getBackground();
        if (this.mToggle && this.mSelected) {
            color = Colors.blend(color, Colors.getCyan(), 10);
        }
        if (this.mPressed || enabled && this.mDrawBorder || this.mToggle && this.mSelected) {
            Color lightColor = Colors.lighten(color, 15);
            Color darkColor = Colors.darken(color, 20);
            Color topColor = this.mPressed ? darkColor : lightColor;
            Color bottomColor = this.mPressed ? lightColor : darkColor;
            Pattern pattern = new Pattern(gc.getDevice(), (float)bounds.x, (float)bounds.y, (float)bounds.x, (float)(bounds.y + bounds.height - 1), topColor, bottomColor);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            pattern.dispose();
        }
        Rectangle imageBounds = this.mImage.getBounds();
        if (!enabled && this.mDisabledImage == null) {
            this.mDisabledImage = new Image(gc.getDevice(), this.mImage, 1);
        }
        if (this.mHasDropDown) {
            Image menuImage = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW);
            Rectangle menuImageBounds = menuImage.getBounds();
            if (!enabled && this.mDisabledMenuImage == null) {
                this.mDisabledMenuImage = new Image(gc.getDevice(), menuImage, 1);
            }
            int x = bounds.x + (bounds.width - (imageBounds.width + 2 + menuImageBounds.width)) / 2;
            gc.drawImage(enabled ? this.mImage : this.mDisabledImage, x, bounds.y + (bounds.height - imageBounds.height) / 2);
            gc.drawImage(enabled ? menuImage : this.mDisabledMenuImage, x + imageBounds.width + 2, bounds.y + (bounds.height - menuImageBounds.height) / 2);
        } else {
            gc.drawImage(enabled ? this.mImage : this.mDisabledImage, bounds.x + (bounds.width - imageBounds.width) / 2, bounds.y + (bounds.height - imageBounds.height) / 2);
        }
        if (this.mPressed || enabled && this.mDrawBorder || this.mToggle && this.mSelected) {
            gc.setForeground(Colors.darken(color, 30));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        gc.setAntialias(0);
    }

    public final void propertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "enabled": {
                this.setEnabled((Boolean)event.getNewValue());
                SafeUpdate.redraw((Control)this);
                break;
            }
            case "checked": {
                this.setSelected((Boolean)event.getNewValue());
                SafeUpdate.redraw((Control)this);
                break;
            }
            case "toolTipText": 
            case "text": {
                this.adjustTooltipFromAction();
                break;
            }
        }
    }

    public final synchronized void removeClickListener(IClickListener listener) {
        this.mClickListeners.remove(listener);
    }

    public final void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            SafeUpdate.redraw((Control)this);
        }
    }

    public final void setPreferredImageSize(int width, int height) {
        this.mPreferredImageWidth = width;
        this.mPreferredImageHeight = height;
    }

    public final void setSelected(boolean selected) {
        if (this.mToggle && this.mSelected != selected) {
            this.mSelected = selected;
            SafeUpdate.redraw((Control)this);
        }
    }

    public final void widgetDisposed(DisposeEvent event) {
        if (this.mDisabledImage != null) {
            this.mDisabledImage.dispose();
            this.mDisabledImage = null;
        }
        if (this.mDisabledMenuImage != null) {
            this.mDisabledMenuImage.dispose();
            this.mDisabledMenuImage = null;
        }
        if (this.mAction != null) {
            this.mImage.dispose();
            this.mImage = null;
            this.mAction.removePropertyChangeListener((IPropertyChangeListener)this);
            this.mAction = null;
        }
    }

    private final void adjustTooltipFromAction() {
        String tooltip = this.mAction.getToolTipText();
        if (tooltip == null || tooltip.isEmpty()) {
            tooltip = this.mAction.getText();
        }
        this.setToolTipText(tooltip);
    }

    public static interface IClickListener {
        public void buttonClicked(ImageButton var1);
    }
}

