/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.widget.DirectScrollCanvas;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class DirectScrollCanvasLayout
extends Layout {
    private Control mLeftSide;
    private Control mRightSide;
    private Control mTopSide;
    private Control mBottomSide;

    public Control getBottomSide() {
        return this.mBottomSide;
    }

    public Control getLeftSide() {
        return this.mLeftSide;
    }

    public Control getRightSide() {
        return this.mRightSide;
    }

    public Control getTopSide() {
        return this.mTopSide;
    }

    public void setBottomSide(Control control) {
        this.mBottomSide = control;
    }

    public void setLeftSide(Control control) {
        this.mLeftSide = control;
    }

    public void setRightSide(Control control) {
        this.mRightSide = control;
    }

    public void setTopSide(Control control) {
        this.mTopSide = control;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = composite.computeSize(-1, -1);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (composite instanceof DirectScrollCanvas) {
            int min;
            int remaining;
            int adj;
            int min2;
            int remaining2;
            Point sideSize;
            Point size = composite.getSize();
            DirectScrollCanvas canvas = (DirectScrollCanvas)composite;
            Slider hSlider = canvas.getHorizontalSlider();
            Slider vSlider = canvas.getVerticalSlider();
            Point hSize = hSlider.computeSize(-1, -1);
            Point vSize = vSlider.computeSize(-1, -1);
            Rectangle hBounds = new Rectangle(0, size.y - hSize.y, size.x - (vSlider.getVisible() ? vSize.x : 0), hSize.y);
            Rectangle vBounds = new Rectangle(size.x - vSize.x, 0, vSize.x, size.y - (hSlider.getVisible() ? hSize.y : 0));
            if (this.mLeftSide != null) {
                sideSize = this.mLeftSide.computeSize(-1, hSize.y);
                remaining2 = hBounds.width - sideSize.x;
                min2 = hSize.y * 3;
                if (remaining2 < min2) {
                    sideSize.x -= min2 - remaining2;
                    if (sideSize.x < 0) {
                        sideSize.x = 0;
                    }
                }
                this.mLeftSide.setBounds(hBounds.x, hBounds.y, sideSize.x, hSize.y);
                hBounds.x += sideSize.x;
                hBounds.width -= sideSize.x;
            }
            if (this.mRightSide != null) {
                sideSize = this.mRightSide.computeSize(-1, hSize.y);
                adj = this.mBottomSide == null ? Math.min(sideSize.x, vSize.x) : 0;
                sideSize.x -= adj;
                remaining = hBounds.width - sideSize.x;
                min = hSize.y * 3;
                if (remaining < min) {
                    sideSize.x -= min - remaining;
                    if (sideSize.x < 0) {
                        sideSize.x = 0;
                    }
                }
                this.mRightSide.setBounds(hBounds.x + hBounds.width - sideSize.x, hBounds.y, sideSize.x + adj, hSize.y);
                hBounds.width -= sideSize.x;
            }
            if (this.mTopSide != null) {
                sideSize = this.mTopSide.computeSize(vSize.x, -1);
                remaining2 = vBounds.height - sideSize.y;
                min2 = vSize.x * 3;
                if (remaining2 < min2) {
                    sideSize.y -= min2 - remaining2;
                    if (sideSize.y < 0) {
                        sideSize.y = 0;
                    }
                }
                this.mTopSide.setBounds(vBounds.x, vBounds.y, vSize.x, sideSize.y);
                vBounds.y += sideSize.y;
                vBounds.height -= sideSize.y;
            }
            if (this.mBottomSide != null) {
                sideSize = this.mBottomSide.computeSize(vSize.x, -1);
                adj = Math.min(sideSize.y, hSize.y);
                sideSize.y -= adj;
                remaining = vBounds.height - sideSize.y;
                min = vSize.x * 3;
                if (remaining < min) {
                    sideSize.y -= min - remaining;
                    if (sideSize.y < 0) {
                        sideSize.y = 0;
                    }
                }
                this.mBottomSide.setBounds(vBounds.x, vBounds.y + vBounds.height - sideSize.y, vSize.x, sideSize.y + adj);
                vBounds.height -= sideSize.y;
            }
            hSlider.setBounds(hBounds);
            vSlider.setBounds(vBounds);
        }
    }
}

