/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.AutoScroller;
import com.arm.streamline.widget.DirectScrollCanvasLayout;
import com.arm.streamline.widget.IMouseWheelHandler;
import com.arm.streamline.widget.MouseWheelTracker;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Slider;

public abstract class DirectScrollCanvas
extends Canvas
implements Listener,
IMouseWheelHandler {
    private Slider mHSlider = new Slider((Composite)this, 524544);
    private Slider mVSlider = new Slider((Composite)this, 524800);
    private AutoScroller mAutoScroller;
    private MouseWheelTracker mMouseWheelListener;
    private boolean mFirstPaint = true;
    private boolean mAutoHideScrollBars = true;
    private boolean firstTime = true;

    public DirectScrollCanvas(Composite parent) {
        this(parent, 0);
    }

    public DirectScrollCanvas(Composite parent, int flags) {
        super(parent, flags | 0x20000000 | 0x40000);
        this.setupSlider(this.mHSlider);
        this.setupSlider(this.mVSlider);
        this.mMouseWheelListener = MouseWheelTracker.create((Control)this);
        this.addListener(11, this);
        this.addListener(9, this);
        this.setLayout(new DirectScrollCanvasLayout());
        this.mAutoScroller = AutoScroller.create((Scrollable)this);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(1, 1);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle bounds = super.computeTrim(x, y, width, height);
        Point sliderSize = this.getSliderSize();
        return new Rectangle(bounds.x, bounds.y, bounds.width + sliderSize.x, bounds.height + sliderSize.y);
    }

    public Point fromVirtual(Point pt) {
        pt.x -= this.mHSlider.getSelection();
        pt.y -= this.mVSlider.getSelection();
        return pt;
    }

    public Rectangle fromVirtual(Rectangle bounds) {
        bounds.x -= this.mHSlider.getSelection();
        bounds.y -= this.mVSlider.getSelection();
        return bounds;
    }

    public AutoScroller getAutoScroller() {
        return this.mAutoScroller;
    }

    public @NonNull Rectangle getClientAreaExcludingSliders() {
        Rectangle bounds = super.getClientArea();
        Point sliderSize = this.getSliderSize();
        bounds.width -= sliderSize.x;
        bounds.height -= sliderSize.y;
        return bounds;
    }

    public @NonNull Point getSliderSize() {
        Point size = new Point(0, 0);
        if (this.mVSlider.getVisible()) {
            size.x += this.mVSlider.computeSize((int)-1, (int)-1).x;
        }
        if (this.mHSlider.getVisible()) {
            size.y += this.mHSlider.computeSize((int)-1, (int)-1).y;
        }
        return size;
    }

    public Slider getHorizontalSlider() {
        return this.mHSlider;
    }

    public Slider getVerticalSlider() {
        return this.mVSlider;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 9: {
                if (this.mFirstPaint) {
                    this.mFirstPaint = false;
                    this.adjustSliders();
                }
                GC gc = new GC(event.gc);
                Rectangle clipping = gc.getClipping();
                Rectangle bounds = this.getClientArea();
                gc.setClipping(bounds.intersection(clipping));
                this.toVirtual(bounds);
                gc.setTranslate(-bounds.x, -bounds.y);
                this.paintCanvas(gc);
                gc.setClipping(clipping);
                break;
            }
            case 11: {
                this.wasResized();
                break;
            }
            case 13: {
                this.wasScrolled();
                break;
            }
        }
    }

    @Override
    public void handleMouseWheel(boolean vertical, int amount) {
        int tmp;
        Slider slider = vertical ? this.mVSlider : this.mHSlider;
        int original = slider.getSelection();
        int value = original - slider.getIncrement() * amount;
        if (value > (tmp = slider.getMaximum() - slider.getThumb())) {
            value = tmp;
        }
        if (value < (tmp = slider.getMinimum())) {
            value = tmp;
        }
        if (value != original) {
            slider.setSelection(value);
            this.wasScrolled();
        }
    }

    public boolean isAutoHideScrollBars() {
        return this.mAutoHideScrollBars;
    }

    public void redrawVirtual(Rectangle bounds) {
        this.fromVirtual(bounds);
        this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        this.toVirtual(bounds);
    }

    public void scrollRectIntoView(Rectangle bounds, boolean verticalOnly) {
        if (this.mHSlider.isDisposed() || this.mVSlider.isDisposed()) {
            return;
        }
        int oldX = this.mHSlider.getSelection();
        int oldY = this.mVSlider.getSelection();
        int x = oldX;
        int y = oldY;
        Rectangle viewPort = this.toVirtual(this.getClientArea());
        if (!verticalOnly) {
            if (bounds.x < viewPort.x) {
                x = bounds.x;
            } else if (bounds.width >= viewPort.width) {
                if (bounds.x > viewPort.x) {
                    x = bounds.x;
                } else if (bounds.x + bounds.width < viewPort.x + viewPort.width) {
                    x = bounds.x + bounds.width - viewPort.width;
                }
            } else if (bounds.x + bounds.width >= viewPort.x + viewPort.width) {
                x = bounds.x + bounds.width - viewPort.width;
            }
            if (x != oldX) {
                this.mHSlider.setSelection(x);
            }
        }
        if (bounds.y < viewPort.y) {
            y = bounds.y;
        } else if (bounds.height >= viewPort.height) {
            if (bounds.y > viewPort.y) {
                y = bounds.y;
            } else if (bounds.y + bounds.height < viewPort.y + viewPort.height) {
                y = bounds.y + bounds.height - viewPort.height;
            }
        } else if (bounds.y + bounds.height >= viewPort.y + viewPort.height) {
            y = bounds.y + bounds.height - viewPort.height;
        }
        if (y != oldY) {
            this.mVSlider.setSelection(y);
        }
        if (oldX != this.mHSlider.getSelection() || oldY != this.mVSlider.getSelection()) {
            this.wasScrolled();
        }
    }

    public void setAutoHideScrollBars(boolean autoHideScrollBars) {
        this.mAutoHideScrollBars = autoHideScrollBars;
        this.redraw();
    }

    public Point toVirtual(Point pt) {
        pt.x += this.mHSlider.getSelection();
        pt.y += this.mVSlider.getSelection();
        return pt;
    }

    public Rectangle toVirtual(Rectangle bounds) {
        bounds.x += this.mHSlider.getSelection();
        bounds.y += this.mVSlider.getSelection();
        return bounds;
    }

    public void wasScrolled() {
        this.redraw();
    }

    protected void adjustSliders() {
        if (this.isDisposed() || !this.getVisible()) {
            return;
        }
        Point size = this.computeContentSize(-1, -1);
        boolean horizontalNeedsAdjusting = true;
        boolean verticalNeedsAdjusting = true;
        boolean needsLayout = false;
        while (horizontalNeedsAdjusting || verticalNeedsAdjusting) {
            boolean changed;
            Point pageSize;
            if (horizontalNeedsAdjusting) {
                pageSize = this.getPageSize();
                changed = this.adjustOneSlider(this.mHSlider, size.x, pageSize.x);
                if (changed) {
                    verticalNeedsAdjusting = true;
                    needsLayout = true;
                }
                horizontalNeedsAdjusting = false;
            }
            if (!verticalNeedsAdjusting) continue;
            pageSize = this.getPageSize();
            changed = this.adjustOneSlider(this.mVSlider, size.y, pageSize.y);
            if (changed) {
                horizontalNeedsAdjusting = true;
                needsLayout = true;
            }
            verticalNeedsAdjusting = false;
        }
        if (needsLayout || this.firstTime) {
            this.layout(true);
            this.firstTime = false;
        }
    }

    protected Point computeContentSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint);
    }

    protected void disableMouseTracking() {
        this.mMouseWheelListener.disable();
        this.mAutoScroller.disable();
    }

    protected void enableMouseTracking() {
        this.mMouseWheelListener.enable();
        this.mAutoScroller.enable();
    }

    protected Point getPageSize() {
        Rectangle hostRect = this.getClientArea();
        return new Point(hostRect.width, hostRect.height);
    }

    protected abstract void paintCanvas(GC var1);

    protected void wasResized() {
        int oldX = this.mHSlider.getSelection();
        int oldY = this.mVSlider.getSelection();
        this.adjustSliders();
        if (oldX != this.mHSlider.getSelection() || oldY != this.mVSlider.getSelection()) {
            this.redraw();
        }
    }

    private boolean adjustOneSlider(Slider slider, int max, int pageSize) {
        boolean changed = false;
        boolean visible = this.mAutoHideScrollBars ? pageSize < max : true;
        changed = visible ^ slider.getVisible();
        slider.setVisible(visible);
        slider.setMaximum(max);
        slider.setThumb(Math.min(max, pageSize));
        slider.setPageIncrement(Math.max(pageSize - slider.getIncrement(), 1));
        return changed;
    }

    private void setupSlider(Slider slider) {
        slider.setMaximum(0);
        slider.setThumb(0);
        slider.setSelection(0);
        slider.setVisible(true);
        slider.addListener(13, (Listener)this);
    }

    @Deprecated
    public ScrollBar getVerticalBar() {
        return super.getVerticalBar();
    }

    @Deprecated
    public ScrollBar getHorizontalBar() {
        return super.getHorizontalBar();
    }
}

