/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.deviceconn.ssh.sshj.ISFTPClient;
import com.arm.streamline.deviceconn.ssh.sshj.ISSHClient;
import com.arm.streamline.deviceconn.ssh.sshj.SSHClientFactory;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import com.arm.streamline.utility.target.IRemoteTransfer;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LinuxRemoteTransfer
implements IRemoteTransfer {
    private ICredentials mCredentials;
    private ISSHClient mSshClient;
    private ISFTPClient mSftp;
    private final @NonNull IProgressMonitor monitor;
    private static final int SSH_PORT = 22;
    private static final int SSH_CONNECTION_TIMEOUT = 5000;

    public LinuxRemoteTransfer(ICredentials credentials, @NonNull IProgressMonitor monitor) {
        this.mCredentials = credentials;
        this.monitor = monitor;
    }

    protected @NonNull ISSHClient createSshClient() {
        return SSHClientFactory.createClient();
    }

    protected @NonNull List<String> findPrivateKeys() {
        File[] keyFiles;
        File sshDir = new File(System.getProperty("user.home"), ".ssh");
        if (sshDir.exists() && sshDir.isDirectory() && (keyFiles = sshDir.listFiles((dir, name) -> name.equals("id_rsa") || name.equals("id_ecdsa") || name.equals("id_ed25519") || name.equals("id_dsa"))) != null) {
            return Arrays.stream(keyFiles).map(File::getAbsolutePath).collect(Collectors.toList());
        }
        return List.of();
    }

    @Override
    public void close() throws IOException {
        if (this.mSshClient != null) {
            if (this.mSshClient.isConnected()) {
                this.mSshClient.disconnect();
            }
            this.mSshClient = null;
            this.mSftp = null;
        }
    }

    private boolean ensureConnected() throws IOException {
        if (this.mSftp != null) {
            return true;
        }
        boolean isSuccess = false;
        ISSHClient client = null;
        ISFTPClient sftp = null;
        try {
            while (!isSuccess && this.mCredentials != null && !this.monitor.isCanceled()) {
                client = this.createSshClient();
                try {
                    CredentialsAddress address = this.mCredentials.getAddress();
                    assert (!address.android);
                    String hostname = address.address;
                    String username = (String)NullChecking.neverNullOr((Object)this.mCredentials.getUsername(), (Object)"");
                    String password = (String)NullChecking.neverNullOr((Object)this.mCredentials.getPassword(), (Object)"");
                    List<String> keyFiles = this.findPrivateKeys();
                    client.setConnectTimeout(5000);
                    client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
                    client.connect(hostname, 22);
                    if (!password.isEmpty()) {
                        client.authPassword(username, password);
                    } else if (!keyFiles.isEmpty()) {
                        client.authPublickey(username, keyFiles.toArray(new String[0]));
                    } else {
                        throw new UserAuthException("No password or key file given");
                    }
                    sftp = client.newSFTPClient();
                    if (!client.isConnected()) break;
                    isSuccess = true;
                    break;
                }
                catch (UserAuthException e) {
                    if (client.isConnected()) {
                        client.disconnect();
                    }
                    Error.show(new Exception(String.format("Authentication Error: %s", e.getMessage())));
                    this.mCredentials = this.mCredentials.reprompt();
                }
            }
            if (this.monitor.isCanceled()) {
                this.mCredentials = null;
                isSuccess = false;
            }
            if (isSuccess) {
                this.mSshClient = client;
                this.mSftp = sftp;
                client = null;
                if (this.mCredentials != null) {
                    TargetAuthentication.cache(LinuxRemoteTransfer.asTargetAuth(this.mCredentials));
                }
            }
            boolean bl = isSuccess;
            return bl;
        }
        finally {
            if (client != null && client.isConnected()) {
                client.disconnect();
            }
        }
    }

    @Override
    public @Nullable File copy(@NonNull String src, @NonNull File dst) throws IOException, InterruptedException {
        boolean isConnected = this.ensureConnected();
        if (isConnected) {
            assert (this.mSshClient != null);
            assert (this.mSftp != null);
            File modified_dst = dst;
            if (dst.isDirectory()) {
                File srcFile = new File(src);
                modified_dst = new File(dst, srcFile.getName());
            }
            this.mSftp.get(src, modified_dst.getAbsolutePath());
            FileAttributes fileAttr = this.mSftp.stat(src);
            if (fileAttr != null) {
                modified_dst.setLastModified(fileAttr.getMtime() * 1000L);
            }
        }
        return isConnected ? dst : null;
    }

    private static @NonNull TargetAuthentication asTargetAuth(@NonNull ICredentials credentials) {
        TargetAuthentication auth = new TargetAuthentication();
        auth.setAddress(credentials.getAddress());
        auth.setUserName(credentials.getUsername());
        auth.setPassword(credentials.getPassword());
        return auth;
    }

    @Override
    public boolean shouldCacheTargetAuthentication() {
        return this.mCredentials != null;
    }
}

