/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.utility.target.IRemoteTransfer;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidRemoteTransfer
implements IRemoteTransfer {
    private static final Pattern ANDROID_LS_TIME = Pattern.compile(" (\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}) ");
    private static final Pattern GNU_STAT = Pattern.compile("Modify: (\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})");
    private static final @NonNull String RUN_AS_DATA_PATH = "/data/data/";
    private static final @NonNull String ANDROID_FILE_SEPARATOR_CHAR = "/";
    private final @NonNull IProgressMonitor monitor;
    private final @NonNull IAdbCommandRunner commandRunner;
    private final @NonNull AdbDeviceRootMode rootMode;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode;
    private final boolean hasStat;

    public AndroidRemoteTransfer(@NonNull IAdbCommandRunner commandRunner, @NonNull IProgressMonitor monitor) throws IOException {
        this.commandRunner = commandRunner;
        this.monitor = monitor;
        this.rootMode = IAdbCommandRunner.detectRootMode((IAdbCommandRunner)commandRunner);
        IAdbCommandRunner.WrapMode currentRootMode = IAdbCommandRunner.rootWrapMode((AdbDeviceRootMode)this.rootMode);
        this.wrapMode = currentRootMode == null ? IAdbCommandRunner.WrapMode.PLAIN : currentRootMode;
        this.hasStat = this.checkIfStatExistOnDevice();
    }

    private boolean checkIfStatExistOnDevice() {
        try {
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IBasicInteractiveShell.InteractiveCommandResult resultForWhichStat = this.commandRunner.runCommandAndGetOutput("which", new String[]{"stat"});
            if (resultForWhichStat.status.isSuccessful()) {
                return resultForWhichStat.output.size() == 1;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
    }

    private @NonNull PullTuple pull(@NonNull File localFile, @NonNull String remotePath) throws IOException {
        return new PullTuple(this.commandRunner.adbPull(false, localFile, remotePath), remotePath, null);
    }

    @Override
    public @Nullable File copy(@NonNull String src, @NonNull File dst) throws IOException, InterruptedException {
        PullTuple pullResult;
        if (this.monitor.isCanceled()) {
            return null;
        }
        try {
            pullResult = this.pull(dst, src);
        }
        catch (IOException e) {
            int lastIndexOf = src.lastIndexOf(ANDROID_FILE_SEPARATOR_CHAR);
            @NonNull String apkPackageName = src.substring(lastIndexOf == -1 ? 0 : lastIndexOf + 1);
            @Nullable Pair<@NonNull String, @NonNull String> androidFileNameAndPath = this.getAndroidFileNameAndPath(apkPackageName);
            if (androidFileNameAndPath != null) {
                @NonNull String name = (String)androidFileNameAndPath.first;
                @NonNull String path = (String)androidFileNameAndPath.second;
                try {
                    pullResult = this.pull(dst, path);
                }
                catch (IOException e1) {
                    e1.addSuppressed(e);
                    throw e1;
                }
                if (pullResult.localFile.getName().contentEquals("base.apk")) {
                    @NonNull File renamedApk = new File(pullResult.localFile.getParentFile(), (String)(name.endsWith(".apk") ? name : name + ".apk"));
                    pullResult.localFile.renameTo(renamedApk);
                    pullResult = new PullTuple(renamedApk, pullResult.remotePath, pullResult.remotePackage);
                }
            }
            if (src.startsWith(RUN_AS_DATA_PATH)) {
                IBasicInteractiveShell.InteractiveCommandResult result;
                @NonNull String replaceFirst = src.replaceFirst(RUN_AS_DATA_PATH, "");
                int indexOfSeparator = replaceFirst.indexOf(ANDROID_FILE_SEPARATOR_CHAR);
                @NonNull String apkNamePath = replaceFirst.substring(0, indexOfSeparator);
                @NonNull String toDownload = replaceFirst.substring(indexOfSeparator + 1);
                @NonNull String remoteFilename = toDownload.substring(toDownload.lastIndexOf(ANDROID_FILE_SEPARATOR_CHAR) + 1);
                @NonNull File targetFile = new File(dst, remoteFilename);
                IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult = result = this.commandRunner.isRootAs(this.wrapMode) ? this.commandRunner.runCommandAndGetOutputAsStream(this.wrapMode, () -> new AbstractAsyncByteReaderLineReaderAndLogger.OutputStreamByteConsumer(targetFile), "cat", new String[]{src}) : this.commandRunner.runCommandAndGetOutputAsStream(() -> new AbstractAsyncByteReaderLineReaderAndLogger.OutputStreamByteConsumer(targetFile), "run-as", new String[]{apkNamePath, "cat", toDownload});
                if (!result.status.isSuccessful()) {
                    throw new AdbCommandIOException(this.commandRunner.isRootAs(this.wrapMode) ? String.format("ROOT-PREFIX cat %s", apkNamePath, src) : String.format("run-as %s cat %s", apkNamePath, toDownload), result);
                }
                pullResult = new PullTuple(targetFile, src, apkNamePath);
            }
            throw e;
        }
        if (dst.isDirectory()) {
            File srcFile = new File(src);
            dst = new File(dst, srcFile.getName());
        }
        this.updateLocalFileTimeStamp(pullResult, dst);
        return pullResult.localFile;
    }

    private void updateLocalFileTimeStamp(@NonNull PullTuple pullResult, @NonNull File dst) throws IOException {
        if (this.hasStat) {
            IBasicInteractiveShell.InteractiveCommandResult resultForStat;
            IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult = resultForStat = pullResult.remotePackage != null ? this.commandRunner.runCommandAndGetOutput("run-as", new String[]{(String)NullChecking.neverNull((Object)pullResult.remotePackage), "stat", pullResult.remotePath}) : this.commandRunner.runCommandAndGetOutput("stat", new String[]{pullResult.remotePath});
            if (resultForStat.status.isSuccessful()) {
                AndroidRemoteTransfer.updateTimeStampDetails(dst, resultForStat.output);
            }
        } else {
            IBasicInteractiveShell.InteractiveCommandResult resultForLs;
            IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult = resultForLs = pullResult.remotePackage != null ? this.commandRunner.runCommandAndGetOutput("run-as", new String[]{(String)NullChecking.neverNull((Object)pullResult.remotePackage), "ls", "-la", pullResult.remotePath}) : this.commandRunner.runCommandAndGetOutput("ls", new String[]{"-la", pullResult.remotePath});
            if (resultForLs.status.isSuccessful()) {
                AndroidRemoteTransfer.updateTimeStampDetails(dst, resultForLs.output);
            }
        }
    }

    private static void updateTimeStampDetails(@NonNull File dst, @NonNull List<@NonNull String> output) {
        for (String line : output) {
            Matcher m = ANDROID_LS_TIME.matcher(line);
            if (m.find()) {
                int year = Integer.parseInt(m.group(1));
                int month = Integer.parseInt(m.group(2));
                int day = Integer.parseInt(m.group(3));
                int hour = Integer.parseInt(m.group(4));
                int minute = Integer.parseInt(m.group(5));
                dst.setLastModified(new GregorianCalendar(year, month - 1, day, hour, minute + 1).getTimeInMillis() + 999L);
                break;
            }
            Matcher m2 = GNU_STAT.matcher(line);
            if (!m2.find()) continue;
            int year = Integer.parseInt(m2.group(1));
            int month = Integer.parseInt(m2.group(2));
            int day = Integer.parseInt(m2.group(3));
            int hour = Integer.parseInt(m2.group(4));
            int minute = Integer.parseInt(m2.group(5));
            int second = Integer.parseInt(m2.group(6));
            dst.setLastModified(new GregorianCalendar(year, month - 1, day, hour, minute, second).getTimeInMillis());
            break;
        }
    }

    private @Nullable Pair<@NonNull String, @NonNull String> getAndroidFileNameAndPath(@NonNull String exePath) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult commandResult = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "pm", new String[]{"list", "packages", "-f", exePath});
        if (!commandResult.status.isSuccessful()) {
            return null;
        }
        for (String line : commandResult.output) {
            String packageName;
            String substr;
            int lastIndexOf;
            if (!line.startsWith("package:") || (lastIndexOf = (substr = line.substring(8)).lastIndexOf("=")) < 0 || !(packageName = substr.substring(lastIndexOf + 1)).equals(exePath)) continue;
            return new Pair((Object)exePath, (Object)substr.substring(0, lastIndexOf));
        }
        return null;
    }

    @Override
    public boolean shouldCacheTargetAuthentication() {
        return false;
    }

    private static final class PullTuple {
        public final @NonNull File localFile;
        public final @NonNull String remotePath;
        public final @Nullable String remotePackage;

        public PullTuple(@NonNull File localFile, @NonNull String remotePath, @Nullable String remotePackage) {
            this.localFile = localFile;
            this.remotePath = remotePath;
            this.remotePackage = remotePackage;
        }
    }
}

