/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.deviceconn.ssh.SshCommandRunner;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.ISshRunnerFactory;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class SshRunnerFactory
implements ISshRunnerFactory {
    public static final @NonNull SshRunnerFactory SINGLETON = new SshRunnerFactory();

    @Override
    public @NonNull ISshCommandRunner create(@NonNull ISshTargetLauncher launcher) throws IOException {
        SshDeviceConfiguration config;
        String host = launcher.getTargetAddress();
        int port = launcher.getSshPort();
        String username = (String)NullChecking.neverNull((Object)launcher.getUserName());
        String passFilePath = launcher.getPassKey();
        if (passFilePath != null && !passFilePath.isEmpty()) {
            config = new SshDeviceConfiguration(host, port, username, new File(passFilePath), null);
        } else {
            String password = (String)NullChecking.neverNull((Object)launcher.getPassword());
            config = new SshDeviceConfiguration(host, port, username, password);
        }
        return new SshCommandRunner(config, null, (TIntIntMap)new TIntIntHashMap());
    }
}

